/************************************************************************/
/*									*/
/*  Headers/Footers tool:						*/
/*									*/
/************************************************************************/

#   ifndef	TED_HEADER_FOOTER_TOOL_H
#   define	TED_HEADER_FOOTER_TOOL_H

/************************************************************************/
/*									*/
/*  A Header/Footer Tool. I.E. The header footer page on the 'Format	*/
/*  Tool'								*/
/*									*/
/************************************************************************/

typedef enum WhatPages
    {
    PAGES_FIRST_PAGE= 0,
    PAGES_SUBSEQUENT_PAGES,
    PAGES_ALL_PAGES,
    PAGES_ODD_PAGES,
    PAGES_EVEN_PAGES,
    PAGES__COUNT
    } WhatPages;

typedef struct HeaderFooterPageResources
    {
    char *		hfprSectionHeaderText;
    char *		hfprTitlepgText;

    char *		hfprDocumentHeaderText;
    char *		hfprFacingpText;
    char *		hfprChangeDocText;
    char *		hfprRevertDocText;

    char *		hfprPagesHeaderText;
    char *		hfprPagesOptionTexts[PAGES__COUNT];

    char *		hfprDeleteHeaderText;
    char *		hfprEditHeaderText;
    char *		hfprDeleteFooterText;
    char *		hfprEditFooterText;
    } HeaderFooterPageResources;

typedef struct HeaderFooterTool
    {
    EditApplication *		hftApplication;
    AppInspector *		hftInspector;

    int				hftSectionNumber;

    DocumentProperties		hftDocPropertiesChosen;
    DocumentProperties		hftDocPropertiesSet;

    SectionProperties		hftSectPropertiesChosen;
    SectionProperties		hftSectPropertiesSet;
    int				hftPagesChosen;
    unsigned char		hftPagesOptionsEnabled[PAGES__COUNT];

    APP_WIDGET			hftSectionFrame;
    APP_WIDGET			hftSectionPaned;
    APP_WIDGET			hftTitlepgToggle;

    APP_WIDGET			hftDocumentFrame;
    APP_WIDGET			hftDocumentPaned;
    APP_WIDGET			hftFacingpToggle;
    APP_WIDGET			hftRevertDocButton;
    APP_WIDGET			hftChangeDocButton;

    APP_WIDGET			hftPagesFrame;
    APP_WIDGET			hftPagesPaned;
    AppOptionmenu		hftPagesOptionmenu;
    APP_WIDGET			hftPagesItems[PAGES__COUNT];

    APP_WIDGET			hftDeleteHeaderButton;
    APP_WIDGET			hftEditHeaderButton;
    APP_WIDGET			hftDeleteFooterButton;
    APP_WIDGET			hftEditFooterButton;
    } HeaderFooterTool;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern void tedFormatToolRefreshHeaderFooterTool( HeaderFooterTool *	hft,
						InspectorSubject *	is,
					const BufferSelection *		bs,
					const DocumentProperties *	dp );

extern void tedFormatToolGetHeaderFooterResourceTable( EditApplication * ea,
					HeaderFooterPageResources *	hfpr,
					InspectorSubjectResources *	isr );

#   endif	/*  TED_HEADER_FOOTER_TOOL_H */
