/************************************************************************/
/*  Ted: Interface to the find tool.					*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"

#   include	<appSpellTool.h>
#   include	"docFind.h"

#   include	<appDebugon.h>

static void tedFindToolClosed(		void *		voidea	)
    {
    EditApplication *	ea=	(EditApplication *)voidea;

    ea->eaFindTool= (void *)0;
    }

static int tedFindToolFindNext(		void *		voidea,
					void *		vprog )
    {
    regProg *			prog= (regProg *)vprog;

    EditApplication *		ea= (EditApplication *)voidea;
    EditDocument *		ed= ea->eaCurrentDocument;
    TedDocument *		td;
    BufferDocument *		bd;

    int				ret;
    BufferPosition		bpFrom;

    SelectionScope		ssNew;
    BufferSelection		bsNew;

    int				scrolledX= 0;
    int				scrolledY= 0;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;
    bpFrom= td->tdSelection.bsEnd;
    ssNew= td->tdSelectionScope;

    docInitSelection( &bsNew );

#   if 0
    ret= docFindFindNextInTree( &bsNew, &bpFrom, &(bd->bdItem),
				    docFindParaFindNext, (void *)prog );
#   else
    ret= docFindFindNextInDocument( &bsNew, &ssNew, &bpFrom, bd,
				    docFindParaFindNext, (void *)prog );
#   endif

    if  ( ret < 0 )
	{ LDEB(ret); return -1;	}

    if  ( ret == 0 )
	{
	tedSetSelection( ed, &ssNew, &bsNew, &scrolledX, &scrolledY );

	tedAdaptToolsToSelection( ed );
	}

    return ret;
    }

static int tedFindToolFindPrev(		void *		voidea,
					void *		vprog	)
    {
    regProg *			prog= (regProg *)vprog;

    EditApplication *		ea= (EditApplication *)voidea;
    EditDocument *		ed= ea->eaCurrentDocument;
    TedDocument *		td;
    BufferDocument *		bd;

    int				ret;
    BufferPosition		bpFrom;

    SelectionScope		ssNew;
    BufferSelection		bsNew;

    int				scrolledX= 0;
    int				scrolledY= 0;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;
    bpFrom= td->tdSelection.bsBegin;
    ssNew= td->tdSelectionScope;

    docInitSelection( &bsNew );

#   if 0
    ret= docFindFindPrevInTree( &bsNew, &bpFrom, &(bd->bdItem),
				    docFindParaFindPrev, (void *)prog );
#   else
    ret= docFindFindPrevInDocument( &bsNew, &ssNew, &bpFrom, bd,
				    docFindParaFindPrev, (void *)prog );
#   endif

    if  ( ret < 0 )
	{ LDEB(ret); return -1;	}

    if  ( ret == 0 )
	{
	tedSetSelection( ed, &ssNew, &bsNew, &scrolledX, &scrolledY );

	tedAdaptToolsToSelection( ed );
	}

    return ret;
    }

void tedDocToolFind(			APP_WIDGET	findOption,
					void *		voided,
					void *		voidcbs )
    {
    EditDocument *	ed= (EditDocument *)voided;
    EditApplication *	ea= ed->edApplication;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    if  ( ! ea->eaFindTool )
	{
	char *			pixmapName= "tedfind";
	APP_BITMAP_IMAGE	iconPixmap= (APP_BITMAP_IMAGE)0;
	APP_BITMAP_MASK		iconMask= (APP_BITMAP_MASK)0;

	if  ( appGetImagePixmap( ea, pixmapName, &iconPixmap, &iconMask )  )
	    { SDEB(pixmapName); return;	}

	ea->eaFindTool= appMakeFindTool( findOption,
			    ea, "tedFindTool",
			    iconPixmap, iconMask,
			    tedFindToolClosed,
			    tedFindToolFindNext,
			    tedFindToolFindPrev,
			    tedAppReplace,
			    (void *)ea );
	if  ( ! ea->eaFindTool )
	    { XDEB(ea->eaFindTool); return;	}
	}

    appShowFindTool( ed->edToplevel.atTopWidget, ea->eaFindTool );

    appFindToolDisableReplace( ea->eaFindTool );

    return;
    }

static int tedSpellFindNext(	void *			voidea,
				SpellCheckContext *	scc )
    {
    EditApplication *		ea= (EditApplication *)voidea;
    EditDocument *		ed= ea->eaCurrentDocument;
    TedDocument *		td;
    BufferDocument *		bd;

    int				ret;
    BufferPosition		bpFrom;

    SelectionScope		ssNew;
    BufferSelection		bsNew;

    int				scrolledX= 0;
    int				scrolledY= 0;

    if  ( ! ed )
	{ XDEB(ed); return -1;	}

    td= (TedDocument *)ed->edPrivateData;
    bd= td->tdDocument;
    bpFrom= td->tdSelection.bsEnd;
    ssNew= td->tdSelectionScope;

    docInitSelection( &bsNew );

#   if 0
    ret= docFindFindNextInTree( &bsNew, &bpFrom, &(bd->bdItem),
					docSpellParaFindNext, (void *)scc );
#   else
    ret= docFindFindNextInDocument( &bsNew, &ssNew, &bpFrom, bd,
					docSpellParaFindNext, (void *)scc );
#   endif

    if  ( ret < 0 )
	{ LDEB(ret); return -1;	}

    if  ( ret == 0 )
	{
	tedSetSelection( ed, &ssNew, &bsNew, &scrolledX, &scrolledY );

	tedAdaptToolsToSelection( ed );

	if  ( ea->eaSpellTool )
	    {
	    unsigned char	save;

	    save= bsNew.bsEnd.bpBi->biParaString[bsNew.bsEnd.bpStroff];
	    bsNew.bsEnd.bpBi->biParaString[bsNew.bsEnd.bpStroff]= '\0';

	    appSpellMakeGuesses( ea->eaSpellTool,
		    bsNew.bsBegin.bpBi->biParaString+ bsNew.bsBegin.bpStroff );

	    bsNew.bsEnd.bpBi->biParaString[bsNew.bsEnd.bpStroff]= save;
	    }
	}

    return ret;
    }

/************************************************************************/
/*									*/
/*  Show or create a spelling tool.					*/
/*									*/
/************************************************************************/

static void tedSpellToolClosed(		void *		voidea	)
    {
    EditApplication *	ea= (EditApplication *)voidea;

    ea->eaSpellTool= (void *)0;
    }

void tedDocToolSpell(		APP_WIDGET	spellOption,
				void *		voided,
				void *		voidcbs )
    {
    EditDocument *	ed=	(EditDocument *)voided;
    EditApplication *	ea=	ed->edApplication;

    if  ( ! ea->eaSpellTool )
	{
	char *			pixmapName= "tedspell";
	APP_BITMAP_IMAGE	iconPixmap= (APP_BITMAP_IMAGE)0;
	APP_BITMAP_MASK		iconMask= (APP_BITMAP_MASK)0;

	if  ( appGetImagePixmap( ea, pixmapName, &iconPixmap, &iconMask )  )
	    { SDEB(pixmapName); return;	}

	ea->eaSpellTool= appMakeSpellTool( spellOption, ea, "tedSpellTool",
			    iconPixmap, iconMask,
			    tedSpellToolClosed, tedSpellFindNext,
			    tedAppReplace, (void *)ea );
	}
    else{ appShowSpellTool( ea->eaSpellTool ); }

    return;
    }
