/************************************************************************/
/*									*/
/*  The 'Cell' page of the 'Ted' format tool.				*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<stddef.h>
#   include	<appDebugon.h>

#   include	<appGeoString.h>
#   include	<appUnit.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

/************************************************************************/
/*									*/
/*  Refresh the 'Column' page of the format tool.			*/
/*									*/
/************************************************************************/

static void tedFormatToolRefreshCellPage(	CellTool *	ct )
    {
    CellProperties *		cp= &(ct->ctPropertiesChosen);
    const TableRectangle *	tr= &(ct->ctTableRectangle);

    appIntegerToTextWidget( ct->ctRowText, tr->trRow0- tr->trRow00+ 1 );
    appIntegerToTextWidget( ct->ctColumnText, tr->trCol0+ 1 );

    tedFormatReflectBorder( &(ct->ctTopBorderTool), &(cp->cpTopBorder) );
    tedFormatReflectBorder( &(ct->ctBottomBorderTool), &(cp->cpBottomBorder) );
    tedFormatReflectBorder( &(ct->ctLeftBorderTool), &(cp->cpLeftBorder) );
    tedFormatReflectBorder( &(ct->ctRightBorderTool), &(cp->cpRightBorder) );

#   if 0
    appSetOptionmenu( &(ct->ctShadingTool.stStyleOptionmenu),
						    cp->cpShadingPattern );
#   endif
    }

void tedFormatToolRefreshCellTool(	CellTool *			ct,
					InspectorSubject *		is,
					const TableRectangle *		tr,
					const BufferSelection *		bs )
    {
    const RowProperties *	rp;
    const CellProperties *	cp;

    const BufferItem *		rowBi;
    const BufferItem *		cellBi;

    cellBi= bs->bsBegin.bpBi;
    cellBi= cellBi->biParent;
    rowBi= cellBi->biParent;

    rp= &(rowBi->biRowProperties);
    cp= &(rp->rpCells[cellBi->biNumberInParent]);

    if  ( docCopyCellProperties( &(ct->ctPropertiesChosen), cp ) )
	{ LDEB(1); return;	}
    if  ( docCopyCellProperties( &(ct->ctPropertiesSet), cp ) )
	{ LDEB(1); return;	}

    ct->ctTableRectangle= *tr;
    appGuiEnableWidget( is->isPrevButton, tr->trCol0 > 0 );
    appGuiEnableWidget( is->isNextButton, tr->trCol1 < tr->trCol11 );

    tedFormatToolRefreshCellPage( ct );

    return;
    }

/************************************************************************/
/*  Set/Revert buttons have been pushed.				*/
/************************************************************************/

static void tedTableChangeCellPushed(	APP_WIDGET	w,
					void *		voidct,
					void *		voidpbcs	 )
    {
    CellTool *		ct= (CellTool *)voidct;
    CellProperties *	cp= &(ct->ctPropertiesChosen);

    if  ( tedBorderToolGetWidth( &(ct->ctTopBorderTool),
						&(cp->cpTopBorder) ) )
	{ return;	}

    if  ( tedBorderToolGetWidth( &(ct->ctBottomBorderTool),
						&(cp->cpBottomBorder) ) )
	{ return;	}

    if  ( tedBorderToolGetWidth( &(ct->ctLeftBorderTool),
						&(cp->cpLeftBorder) ) )
	{ return;	}

    if  ( tedBorderToolGetWidth( &(ct->ctRightBorderTool),
						&(cp->cpRightBorder) ) )
	{ return;	}

LDEB(1);
    return;
    }

static void tedFormatRevertCellPushed(		APP_WIDGET	w,
						void *		voidct,
						void *		voidpbcs )
    {
    CellTool *	ct= (CellTool *)voidct;

    docCopyCellProperties( &(ct->ctPropertiesChosen), &(ct->ctPropertiesSet) );

    tedFormatToolRefreshCellPage( ct );

    return;
    }

/************************************************************************/
/*									*/
/*  A cell shading was chosen in the option menu.			*/
/*									*/
/************************************************************************/

#   if 0
static void tedCellShadingChosen(	APP_WIDGET	w,
					void *		voidct,
					void *		voidtbcs )
    {
    CellTool *			ct= (CellTool *)voidct;
    CellProperties *		cp= &(ct->ctPropertiesChosen);

    int					shading= -1;

    for ( shading= 0; shading < DOCsp_COUNT; shading++ )
	{
	if  ( ct->ctShadingTool.stStyleItems[shading] == w )
	    { break;	}
	}

    if  ( shading >= 0 && shading < DOCsp_COUNT )
	{ cp->cpShadingPattern= shading;		}
    else{ LLDEB(shading,DOCsp_COUNT);			}

    return;
    }
#   endif

static void tedCellBorderStyleChosen(	APP_WIDGET	w,
					void *		voidct,
					void *		voidtbcs )
    {
    CellTool *		ct= (CellTool *)voidct;
    CellProperties *	cp= &(ct->ctPropertiesChosen);

    if  ( ! tedBorderToolGetStyle( &(ct->ctTopBorderTool),
						&(cp->cpTopBorder), w ) )
	{ return;	}

    if  ( ! tedBorderToolGetStyle( &(ct->ctBottomBorderTool),
						&(cp->cpBottomBorder), w ) )
	{ return;	}

    if  ( ! tedBorderToolGetStyle( &(ct->ctLeftBorderTool),
						&(cp->cpLeftBorder), w ) )
	{ return;	}

    if  ( ! tedBorderToolGetStyle( &(ct->ctRightBorderTool),
						&(cp->cpRightBorder), w ) )
	{ return;	}

    XDEB(w); return;
    }

/************************************************************************/
/*									*/
/*  Previous/Next Column/Row buttons have been pushed.			*/
/*									*/
/************************************************************************/

static void tedCellPreviousColumn(	APP_WIDGET	w,
					void *		voidct,
					void *		voidpbcs )
    {
    CellTool *		ct= (CellTool *)voidct;
    EditApplication *	ea= ct->ctApplication;
    EditDocument *	ed= ea->eaCurrentDocument;
    TedDocument *	td;

    TableRectangle	tr;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tr= ct->ctTableRectangle;
    td= (TedDocument *)ed->edPrivateData;

    if  ( docShiftTableRectangleByColumns( &tr, -1 ) )
	{ return;	}

    tedAppSetTableSelection( ed, &(td->tdSelectionScope), &tr );
    }

/*
static void tedTableSelectCell(		APP_WIDGET	w,
					void *		voidct,
					void *		voidpbcs	 )
    {
    CellTool *		ct= (CellTool *)voidct;
    EditApplication *	ea= ct->ctApplication;
    EditDocument *	ed= ea->eaCurrentDocument;
    TedDocument *	td;

    TableRectangle	tr;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tr= ct->ctTableRectangle;
    td= (TedDocument *)ed->edPrivateData;

    tedAppSetTableSelection( ed, &(td->tdSelectionScope), &tr );
    }
*/

static void tedCellNextColumn(		APP_WIDGET	w,
					void *		voidct,
					void *		voidpbcs	 )
    {
    CellTool *		ct= (CellTool *)voidct;
    EditApplication *	ea= ct->ctApplication;
    EditDocument *	ed= ea->eaCurrentDocument;
    TedDocument *	td;

    TableRectangle	tr;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tr= ct->ctTableRectangle;
    td= (TedDocument *)ed->edPrivateData;

    if  ( docShiftTableRectangleByColumns( &tr, +1 ) )
	{ return;	}

    tedAppSetTableSelection( ed, &(td->tdSelectionScope), &tr );
    }

/************************************************************************/
/*									*/
/*  One of the 'Cell Border' toggles has been activated.		*/
/*									*/
/************************************************************************/

static void tedCellToggleBorder(	APP_WIDGET	w,
					void *		voidct,
					void *		voidtbcs )
    {
    CellTool *		ct= (CellTool *)voidct;
    CellProperties *	cp= &(ct->ctPropertiesChosen);
    int			set;

    const int		influenceStyleMenu= 1;

    set= appGuiGetToggleStateFromCallback( w, voidtbcs );

    if  ( w == ct->ctTopBorderTool.btOnOffToggle )
	{
	tedFormatToggleBorder( &(cp->cpTopBorder), &(ct->ctTopBorderTool),
						    influenceStyleMenu, set );
	return;
	}

    if  ( w == ct->ctBottomBorderTool.btOnOffToggle )
	{
	tedFormatToggleBorder( &(cp->cpBottomBorder), &(ct->ctBottomBorderTool),
						    influenceStyleMenu, set );
	return;
	}

    if  ( w == ct->ctLeftBorderTool.btOnOffToggle )
	{
	tedFormatToggleBorder( &(cp->cpLeftBorder), &(ct->ctLeftBorderTool),
						    influenceStyleMenu, set );
	return;
	}

    if  ( w == ct->ctRightBorderTool.btOnOffToggle )
	{
	tedFormatToggleBorder( &(cp->cpRightBorder), &(ct->ctRightBorderTool),
						    influenceStyleMenu, set );
	return;
	}

    XDEB(w); return;
    }

/************************************************************************/
/*									*/
/*  Make a Cell tool, I.E. the 'Cell' page of the format tool.		*/
/*									*/
/************************************************************************/

void tedFormatFillCellPage(	CellTool *			ct,
				const CellPageResources *	cpr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr )
    {
    APP_WIDGET	rowLabel;
    APP_WIDGET	columnLabel;

    APP_WIDGET	row= (APP_WIDGET)0;

    const int	textColumns= 10;

    /**************/

    docInitTableRectangle( &(ct->ctTableRectangle) );

    docInitCellProperties( &(ct->ctPropertiesSet) );
    docInitCellProperties( &(ct->ctPropertiesChosen) );

    appMakeLabelAndTextRow( &row, &rowLabel, &(ct->ctRowText),
			    pageWidget, cpr->cprRow, textColumns, 0 );
    appMakeLabelAndTextRow( &row, &columnLabel, &(ct->ctColumnText),
			    pageWidget, cpr->cprColumn, textColumns, 0 );


#   if 0
    tedFormatMakeShadingTool( &(ct->ctShadingTool), &row,
				    pageWidget, cpr->cprShadingPattern );
#   endif

    tedFormatMakeBorderTool( &(ct->ctTopBorderTool), &row, pageWidget,
			cpr->cprTopBorder, tedCellToggleBorder, (void *)ct );

    tedFormatMakeBorderTool( &(ct->ctBottomBorderTool), &row, pageWidget,
			cpr->cprBottomBorder, tedCellToggleBorder, (void *)ct );

    tedFormatMakeBorderTool( &(ct->ctLeftBorderTool), &row, pageWidget,
			cpr->cprLeftBorder, tedCellToggleBorder, (void *)ct );

    tedFormatMakeBorderTool( &(ct->ctRightBorderTool), &row, pageWidget,
			cpr->cprRightBorder, tedCellToggleBorder, (void *)ct );

    appInspectorMakeButtonRow( &row, pageWidget,
		    &(is->isPrevButton), &(is->isNextButton),
		    isr->isrPrevButtonText, isr->isrNextButtonText,
		    tedCellPreviousColumn, tedCellNextColumn, ct );

    /* ??
    appInspectorMakeButtonRow( &row, pageWidget,
		    &(is->isSelectButton), &(is->isDeleteButton),
		    isr->isrSelectButtonText, isr->isrDeleteButtonText,
		    tedTableSelectColumn, tedTableDeleteColumn, ct );
    */

    appInspectorMakeButtonRow( &row, pageWidget,
		    &(is->isRevertButton), &(is->isApplyButton),
		    isr->isrRevert, isr->isrApplyToSubject,
		    tedFormatRevertCellPushed, tedTableChangeCellPushed,
		    (void *)ct );

    return;
    }

void tedFormatFillCellChoosers(		CellTool *			ct,
					const CellPageResources *	cpr )
    {
#   if 0
    tedFormatFillShadingTool( &(ct->ctShadingTool),
					tedCellShadingChosen, (void *)ct );
#   endif

    tedFormatFillBorderTool( &(ct->ctTopBorderTool),
					tedCellBorderStyleChosen, (void *)ct );
    tedFormatFillBorderTool( &(ct->ctBottomBorderTool),
					tedCellBorderStyleChosen, (void *)ct );
    tedFormatFillBorderTool( &(ct->ctLeftBorderTool),
					tedCellBorderStyleChosen, (void *)ct );
    tedFormatFillBorderTool( &(ct->ctRightBorderTool),
					tedCellBorderStyleChosen, (void *)ct );
    return;
    }

void tedFormatFinishCellPage(		CellTool *			ct,
					TedFormatTool *			tft,
					const CellPageResources *	cpr )
    {
#   if 0
    tedFormatFinishShadingTool( &(ct->ctShadingTool), tft );
#   endif

    tedFormatFinishBorderTool( &(ct->ctTopBorderTool), tft );
    tedFormatFinishBorderTool( &(ct->ctBottomBorderTool), tft );
    tedFormatFinishBorderTool( &(ct->ctLeftBorderTool), tft );
    tedFormatFinishBorderTool( &(ct->ctRightBorderTool), tft );
    }

/************************************************************************/
/*									*/
/*  Get row tool resources.						*/
/*									*/
/************************************************************************/

static AppConfigurableResource TED_TedCellSubjectResourceTable[]=
    {
    APP_RESOURCE( "tableToolCell",
		offsetof(InspectorSubjectResources,isrSubjectName),
		"Cell" ),
    APP_RESOURCE( "tableToolChangeCell",
		offsetof(InspectorSubjectResources,isrApplyToSubject),
		"Apply to Cell" ),
    APP_RESOURCE( "tableToolRevert",
		offsetof(InspectorSubjectResources,isrRevert),
		"Revert" ),
    APP_RESOURCE( "tableToolCellNextColumn",
		offsetof(InspectorSubjectResources,isrNextButtonText),
		"Next Column" ),
    APP_RESOURCE( "tableToolCellPreviousColumn",
		offsetof(InspectorSubjectResources,isrPrevButtonText),
		"Previous Column" ),
    APP_RESOURCE( "tableToolSelectCell",
		offsetof(InspectorSubjectResources,isrSelectButtonText),
		"Select Cell" ),
    };

static AppConfigurableResource TED_TedCellToolResourceTable[]=
    {
    APP_RESOURCE( "tableToolCellRow",
		offsetof(CellPageResources,cprRow),
		"Row" ),
    APP_RESOURCE( "tableToolCellColumn",
		offsetof(CellPageResources,cprColumn),
		"Column" ),
    APP_RESOURCE( "tableToolCellTopBorder",
		offsetof(CellPageResources,cprTopBorder),
		"Top Border" ),
    APP_RESOURCE( "tableToolCellBottomBorder",
		offsetof(CellPageResources,cprBottomBorder),
		"Bottom Border" ),
    APP_RESOURCE( "tableToolCellLeftBorder",
		offsetof(CellPageResources,cprLeftBorder),
		"Left Border" ),
    APP_RESOURCE( "tableToolCellRightBorder",
		offsetof(CellPageResources,cprRightBorder),
		"Right Border" ),
    APP_RESOURCE( "tableToolCellColumnSpan",
		offsetof(CellPageResources,cprColumnSpan),
		"Columns Occupied" ),
    APP_RESOURCE( "tableToolCellShadingPattern",
		offsetof(CellPageResources,cprShadingPattern),
		"Shading Pattern" ),
    APP_RESOURCE( "tableToolCellVerticalAlignment",
		offsetof(CellPageResources,cprVerticalAlignment),
		"Vertical Alignment" ),
    };

void tedFormatToolGetCellResourceTable(	EditApplication *		ea,
					CellPageResources *		cpr,
					InspectorSubjectResources *	isr )
    {
    appGuiGetResourceValues( ea, (void *)cpr,
				TED_TedCellToolResourceTable,
				sizeof(TED_TedCellToolResourceTable)/
				sizeof(AppConfigurableResource) );

    appGuiGetResourceValues( ea, (void *)isr,
				TED_TedCellSubjectResourceTable,
				sizeof(TED_TedCellSubjectResourceTable)/
				sizeof(AppConfigurableResource) );

    return;
    }
