/************************************************************************/
/*									*/
/*  A Border Tool. Used on the pages of the format tool.		*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<stddef.h>
#   include	<appDebugon.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

/************************************************************************/
/*									*/
/*  Show the border width in a border tool.				*/
/*									*/
/************************************************************************/

static void tedBorderToolShowWide(
				BorderTool *			bt,
				const BorderProperties *	bp )
    {
    appEnableText( bt->btWideText, bp->bpStyle != DOCbsNONE );

    if  ( bp->bpStyle != DOCbsNONE )
	{
	char	scratch[80];

	appGeoLengthToString( scratch, bp->bpPenWideTwips, UNITtyPOINTS );
	appStringToTextWidget( bt->btWideText, scratch );
	}
    else{ appStringToTextWidget( bt->btWideText, "" );	}

    return;
    }

/************************************************************************/
/*									*/
/*  Update a 'HasBorder' toggle.					*/
/*									*/
/************************************************************************/

void tedFormatReflectBorder(	BorderTool *			bt,
				const BorderProperties *	bp )
    {
    int		set= 0;

    if  ( bp->bpPenWideTwips > 0	&&
	  bp->bpStyle != DOCbsNONE	)
	{ set= 1;	}

    appGuiSetToggleState( bt->btOnOffToggle, set );

    tedBorderToolShowWide( bt, bp );

#   if 0
    appGuiEnableOptionmenu( &(bt->btStyleOptionmenu), set );

    appSetOptionmenu( &(bt->btStyleOptionmenu), bp->bpStyle );
#   endif

    return;
    }

/************************************************************************/
/*									*/
/*  One of the border on/off toggles has been activated by a user.	*/
/*									*/
/************************************************************************/

void tedFormatToggleBorder(	BorderProperties *	bp,
				BorderTool *		bt,
				int			influenceStyleMenu,
				int			set )
    {
    if  ( set )
	{
	bp->bpStyle= DOCbsS;

	if  ( bp->bpPenWideTwips == 0 )
	    { bp->bpPenWideTwips= 15;	}
	}
    else{ bp->bpStyle= DOCbsNONE;	}

    tedBorderToolShowWide( bt, bp );

#   if 0
    if  ( influenceStyleMenu )
	{
	appGuiEnableOptionmenu( &(bt->btStyleOptionmenu), set );
	}
#   endif

    }

/************************************************************************/
/*									*/
/*  The user typed 'Enter' in the 'Width' text box.			*/
/*									*/
/************************************************************************/

static void tedFormatBorderWidthChanged(	APP_WIDGET	w,
						void *		voidafc,
						void *		voidcbs )
    {
    int			wide= 0;
    int			changed= 0;

    char		scratch[80];

    const int		minValue= 1;
    const int		adaptToMin= 0;
    const int		maxValue= 75;
    const int		adaptToMax= 0;

    if  ( appGetLengthFromTextWidget( w, &wide, &changed, UNITtyPOINTS,
				minValue, adaptToMin, maxValue, adaptToMax ) )
	{ return;	}

    appGeoLengthToString( scratch, wide, UNITtyPOINTS );
    appStringToTextWidget( w, scratch );

    return;
    }


/************************************************************************/
/*									*/
/*  Make a BorderTool.							*/
/*									*/
/************************************************************************/

void tedFormatMakeBorderTool(		BorderTool *		bt,
					APP_WIDGET *		pRow,
					APP_WIDGET		page,
					const char *		text,
					APP_TOGGLE_CALLBACK	callback,
					void *			through )
    {
    const int	heightResizable= 0;
    APP_WIDGET	row= appMakeRowInColumn( page, 2, heightResizable );

    const int	toggleColumn= 0;
    const int	textColumn= toggleColumn+ 1;
    const int	textColspan= 1;

    const int	textColumns= 10;
    const int	textEnabled= 0;

    bt->btOnOffToggle= appMakeToggleInRow( row, text, callback, through,
							    toggleColumn );

    appMakeTextInRow( &(bt->btWideText), row, textColumn, textColspan,
						    textColumns, textEnabled );

    appGuiSetGotValueCallbackForText( bt->btWideText,
				    tedFormatBorderWidthChanged, through );

#   if 0
    /*  Border Styles are not for Ted 2.9: */

    appMakeOptionmenuInRow( &(bt->btStyleOptionmenu), row, 1, 1 );

    appGuiEnableOptionmenu( &(bt->btStyleOptionmenu), 0 );
#   endif

    *pRow= row; return;
    }

void tedFormatCleanBorderTool(		BorderTool *		bt )
    {
    return;
    }

void tedFormatFillBorderTool(		BorderTool *		bt,
					APP_BUTTON_CALLBACK	callBack,
					void *			target )
    {
#   if 0
    int		i;

    for ( i= 0; i < DOCbs_COUNT; i++ )
	{
	bt->btStyleItems[i]= appAddPixmapItemToOptionmenu(
				&(bt->btStyleOptionmenu), callBack, target );
	}
#   endif
    }

/************************************************************************/
/*									*/
/*  Set the pixmap for a border style chooser in a format page.		*/
/*									*/
/************************************************************************/

# if 0
static void tedBorderSetLineSolid(	AppDrawingData *	add,
					int			thick )
    {
#   ifdef USE_MOTIF
    XSetLineAttributes( add->addDisplay, add->addGc,
			thick, LineSolid, CapButt, JoinMiter );
#   endif

#   ifdef USE_GTK
    gdk_gc_set_line_attributes( add->addGc,
			thick, GDK_LINE_SOLID, GDK_CAP_BUTT, GDK_JOIN_MITER );
#   endif
    }

static void tedBorderSetLineDashes(	AppDrawingData *	add,
					const unsigned char *	dashes,
					int			dashCount,
					int			thick )
    {
#   ifdef USE_MOTIF
    XSetLineAttributes( add->addDisplay, add->addGc,
				thick, LineOnOffDash, CapButt, JoinMiter );

    XSetDashes( add->addDisplay, add->addGc, 0,
					(const char *)dashes, dashCount );
#   endif

#   ifdef USE_GTK
    gdk_gc_set_line_attributes( add->addGc,
		thick, GDK_LINE_ON_OFF_DASH, GDK_CAP_BUTT, GDK_JOIN_MITER );

    gdk_gc_set_dashes( add->addGc, 0, (char *)dashes, dashCount );
#   endif
    }

static const unsigned char TED_Border_DOT[]=	{ 1, 2 };
static const unsigned char TED_Border_DASH[]=	{ 3, 3 };
static const unsigned char TED_Border_DASHSM[]=	{ 3, 1 };
static const unsigned char TED_Border_DASHD[]=	{ 4, 2, 2, 2 };
static const unsigned char TED_Border_DASHDD[]=	{ 4, 2, 2, 2, 2, 2 };

static APP_BITMAP_IMAGE
tedFormatToolMakeBorderPixmap(		APP_WIDGET		w,
					TedFormatTool *		tft,
					AppDrawingData *	parent_add,
					int			wide,
					int			high,
					int			style )
    {
    int			x0;
    int			x1;
    int			y0;
    int			y1;

    int			x;
    int			y;

    const int		marg= 4;

    APP_BITMAP_IMAGE	pixmap;
    AppDrawingData	add;

    if  ( tft->tftBorderPixmaps[style] )
	{ return tft->tftBorderPixmaps[style];	}

    wide -= 2* marg;
    high -= 2* marg;

    wide -= 2;

    x0= 0; x1= x0+ wide;
    y0= 0; y1= y0+ high;

    pixmap= appMakePixmap( parent_add, wide, high );
    tft->tftBorderPixmaps[style]= pixmap;

    appInitDrawingData( &add );
    appCloneDrawingEnvironment( &add, parent_add,
		    1.0, parent_add->addMagnifiedPixelsPerTwip, pixmap );

    appDrawSetForegroundWhite( &add );
    appDrawFillRectangle( &add, x0, y0, wide, high );

    appDrawSetForegroundBlack( &add );

    appDrawDrawLine( &add, x0, y0, x1, y0 );
    appDrawDrawLine( &add, x1-1, y0, x1-1, y1 );
    appDrawDrawLine( &add, x1, y1-1, x0, y1-1 );
    appDrawDrawLine( &add, x0, y1, x0, y0 );

    switch( style )
	{
	case DOCbsNONE:
	    break;

	case DOCbsS:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTH:
	    tedBorderSetLineSolid( &add, 2 );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsSH:
	    tedBorderSetLineSolid( &add, 2 );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsDB:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 1;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    y= ( y0+ y1 )/ 2+ 1;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsHAIR:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsDOT:
	    tedBorderSetLineDashes( &add,
			    TED_Border_DOT, sizeof( TED_Border_DOT ), 1 );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsDASH:
	    tedBorderSetLineDashes( &add,
			    TED_Border_DASH, sizeof( TED_Border_DASH ), 1 );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsDASHD:
	    tedBorderSetLineDashes( &add,
			TED_Border_DASHD, sizeof( TED_Border_DASHD ), 1 );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsDASHDD:
	    tedBorderSetLineDashes( &add,
			TED_Border_DASHDD, sizeof( TED_Border_DASHDD ), 1 );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTRIPLE:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    y= ( y0+ y1 )/ 2+ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTNTHSG:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 2 );
	    y= ( y0+ y1 )/ 2+ 1;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTHTNSG:
	    tedBorderSetLineSolid( &add, 2 );
	    y= ( y0+ y1 )/ 2- 1;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2+ 1;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTNTHTNSG:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 3;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 2 );
	    y= ( y0+ y1 )/ 2+ 0;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2+ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTNTHMG:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 3 );
	    y= ( y0+ y1 )/ 2+ 1;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTHTNMG:
	    tedBorderSetLineSolid( &add, 3 );
	    y= ( y0+ y1 )/ 2- 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2+ 1;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTNTHTNMG:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 3;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 3 );
	    y= ( y0+ y1 )/ 2+ 0;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2+ 3;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTNTHLG:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 3;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 4 );
	    y= ( y0+ y1 )/ 2+ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTHTNLG:
	    tedBorderSetLineSolid( &add, 4 );
	    y= ( y0+ y1 )/ 2- 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2+ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsTNTHTNLG:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 4;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 4 );
	    y= ( y0+ y1 )/ 2+ 0;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2+ 3;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsWAVY:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2;
	    x= x0;
#	    define	W	2
#	    define	W2	4
	    appDrawDrawLine( &add, x, y, x+ W, y+ W ); x += W;
	    while( x < x1 )
		{
		appDrawDrawLine( &add, x, y+ W, x+ W2, y- W ); x += W2;
		appDrawDrawLine( &add, x, y- W, x+ W2, y+ W ); x += W2;
		}
	    break;

	case DOCbsWAVYDB:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2- 2;
	    x= x0;
	    appDrawDrawLine( &add, x, y, x+ W, y+ W ); x += W;
	    while( x < x1 )
		{
		appDrawDrawLine( &add, x, y+ W, x+ W2, y- W ); x += W2;
		appDrawDrawLine( &add, x, y- W, x+ W2, y+ W ); x += W2;
		}

	    y= ( y0+ y1 )/ 2+ 2;
	    x= x0;
	    appDrawDrawLine( &add, x, y, x+ W, y+ W ); x += W;
	    while( x < x1 )
		{
		appDrawDrawLine( &add, x, y+ W, x+ W2, y- W ); x += W2;
		appDrawDrawLine( &add, x, y- W, x+ W2, y+ W ); x += W2;
		}
	    break;

	case DOCbsDASHSM:
	    tedBorderSetLineDashes( &add,
			TED_Border_DASHSM, sizeof( TED_Border_DASHSM ), 1 );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	case DOCbsDASHDOTSTR:
	    y= ( y0+ y1 )/ 2;
	    x= x0- 2;
	    while( x < x1 )
		{
		appDrawDrawLine( &add, x, y+ 1, x+ 3, y- 2 ); x += 2;
		appDrawDrawLine( &add, x, y+ 1, x+ 3, y- 2 ); x += 1;
		appDrawDrawLine( &add, x, y+ 1, x+ 3, y- 2 ); x += 2;
		}
	    break;

	case DOCbsEMBOSS:
	case DOCbsENGRAVE:
	    tedBorderSetLineSolid( &add, 1 );
	    y= ( y0+ y1 )/ 2;
	    appDrawDrawLine( &add, x0, y, x1, y );
	    break;

	default:
	    LDEB(style);
	    break;
	}

    appCleanDrawingData( &add );

    return pixmap;
    }

# endif

void tedFormatFinishBorderTool(	BorderTool *		bt,
				TedFormatTool *		tft )
    {
#   if 0
    int			wide;
    int			high;

    int			i;

    appOptionmenuRefreshWidth( &(bt->btStyleOptionmenu) );

    appDrawGetSizeOfWidget( &wide, &high, bt->btStyleOptionmenu.aomInplace );

    appPixmapOptionmenuSetButtonMargins( &(bt->btStyleOptionmenu) );

    for ( i= 0; i < DOCbs_COUNT; i++ )
	{
	APP_BITMAP_IMAGE	pixmap;

	if  ( ! tft->tftPixmapAddAllocated )
	    {
	    appSetDrawingDataForWidget( bt->btStyleItems[i], 1.0,
						    &(tft->tftPixmapAdd) );
	    tft->tftPixmapAddAllocated= 1;
	    }

	pixmap= tedFormatToolMakeBorderPixmap( bt->btStyleItems[i], tft,
					&(tft->tftPixmapAdd), wide, high, i );

#	ifdef USE_MOTIF
	XtVaSetValues( bt->btStyleItems[i],
				    XmNlabelPixmap,		pixmap,
				    NULL );
#	endif
	}

    /*
    appPixmapOptionmenuSetButtonMargins( &(bt->btStyleOptionmenu) );
    */
#   endif

    return;
    }

/************************************************************************/
/*									*/
/*  Retrieve the style from the widget in the callback of a border	*/
/*  tool style option.							*/
/*									*/
/************************************************************************/

int tedBorderToolGetStyle(	const BorderTool *	bt,
				BorderProperties *	bp,
				APP_WIDGET		w )
    {
#   if 0
    int		i;

    for ( i= 0; i < DOCbs_COUNT; i++ )
	{
	if  ( bt->btStyleItems[i] == w )
	    { bp->bpStyle= i; return 0;	}
	}

#   endif
    return -1;
    }


/************************************************************************/
/*									*/
/*  Retrieve the style from the widget in the callback of a border	*/
/*  tool style option.							*/
/*									*/
/************************************************************************/

int tedBorderToolGetWidth(	const BorderTool *	bt,
				BorderProperties *	bp )
    {
    int			changed= 0;

    const int		minValue= 1;
    const int		adaptToMin= 0;
    const int		maxValue= 75;
    const int		adaptToMax= 0;

    int			wide= bp->bpPenWideTwips;

    if  ( bp->bpStyle != DOCbsNONE )
	{
	if  ( appGetLengthFromTextWidget( bt->btWideText,
			    &wide, &changed, UNITtyPOINTS,
			    minValue, adaptToMin, maxValue, adaptToMax ) )
	    { return -1;	}

	bp->bpPenWideTwips= wide;
	}

    return 0;
    }

