/************************************************************************/
/*									*/
/*  Spell checking utility routines.					*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"
#   include	"docFind.h"

#   include	<ind.h>
#   include	<charnames.h>

/************************************************************************/
/*									*/
/*  Find the first misspelling from a certain position in a document.	*/
/*									*/
/************************************************************************/

int docSpellParaFindNext(	const BufferItem *	paraBi,
				int			stroff,
				int *			pStart,
				int *			pLength,
				void *			through )
    {
    SpellCheckContext *		scc= (SpellCheckContext *)through;
    SpellScanJob		ssj;
    int				acceptedPos= stroff;
    const unsigned char *	str= paraBi->biParaString+ stroff;

    indInitSpellScanJob( &ssj );

    if  ( stroff > 0						&&
	  ( scc->sccCharKinds[ str[ 0] ] & CHARisALNUM )	&&
	  ( scc->sccCharKinds[ str[-1] ] & CHARisALNUM )	)
	{
	while( stroff < paraBi->biParaStrlen			&&
	       ( scc->sccCharKinds[ *str ] & CHARisALNUM )	)
	    { stroff++; str++; }
	}

    while( stroff < paraBi->biParaStrlen )
	{
	int		count;

	while( stroff < paraBi->biParaStrlen			&&
	       ! ( scc->sccCharKinds[ *str ] & CHARisALNUM )	)
	    {
	    indAddCharacterToPossibilities( &ssj, *str );
	    stroff++; str++;
	    }

	if  ( stroff >= paraBi->biParaStrlen )
	    { break;	}

	indAddCharacterToPossibilities( &ssj, *str );

	if  ( indNewPossibility( &ssj, stroff, *str ) )
	    { CDEB(*str); return -1;	}

	stroff++; str++;
	while( stroff < paraBi->biParaStrlen		&&
	       ( scc->sccCharKinds[*str] & CHARisALNUM )	)
	    {
	    indAddCharacterToPossibilities( &ssj, *str );
	    stroff++; str++;
	    }

	count= indCountPossibilities( &ssj, scc, stroff- 1, stroff,
				    stroff >= paraBi->biParaStrlen, *str );

	if  ( count == 0 )
	    {
	    PossibleWord *	maxpw;

	    maxpw= indMaximalPossibility( &ssj );

	    if  ( ! maxpw )
		{
		XDEB(maxpw); return -1;	}

	    *pStart= maxpw->pwStartPosition;
	    *pLength= maxpw->pwInsertionPoint;

	    indCleanSpellScanJob( &ssj );

	    return 0;
	    }

	indRejectPossibilities( &acceptedPos, acceptedPos, &ssj );
	}

    indCleanSpellScanJob( &ssj );

    return 1;
    }

