/************************************************************************/
/*									*/
/*  Save a BufferDocument into an RTF file.				*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	<appSystem.h>
#   include	"docRtf.h"

/************************************************************************/
/*									*/
/*  Save a tag with an argument.					*/
/*									*/
/************************************************************************/

void docRtfWriteNextLine(	int *			pCol,
				SimpleOutputStream *	sos )
    {
    int		col= *pCol;

    if  ( col > 0 )
	{
	sioOutPutString( "\r\n", sos );
	col= 0;
	}

    *pCol= col; return;
    }

void docRtfWriteTag(	const char *		tag,
			int *			pCol,
			SimpleOutputStream *	sos )
    {
    int		col= *pCol;
    int		len= strlen( tag );

    col += len;

    if  ( col > 72 )
	{
	docRtfWriteNextLine( &col, sos );
	col += len;
	}

    sioOutPutString( tag, sos );

    *pCol= col; return;
    }

void docRtfWriteDestinationBegin(	const char *		tag,
					int *			pCol,
					SimpleOutputStream *	sos )
    {
    int		col= *pCol;
    int		len= strlen( tag );

    col += 1+ len;

    if  ( col > 72 )
	{
	docRtfWriteNextLine( &col, sos );
	col += 1+ len;
	}

    sioOutPutCharacter( '{', sos );
    sioOutPutString( tag, sos );

    *pCol= col; return;
    }

void docRtfWriteArgDestinationBegin(	const char *		tag,
					int *			pCol,
					int			arg,
					SimpleOutputStream *	sos )
    {
    int		col= *pCol;
    char	scratch[20];
    int		len;

    sprintf( scratch, "%d", arg );

    len= strlen( tag )+ strlen( scratch );

    col += 1+ len;

    if  ( col > 72 )
	{
	docRtfWriteNextLine( &col, sos );
	col += 1+ len;
	}

    sioOutPutCharacter( '{', sos );
    sioOutPutString( tag, sos );
    sioOutPutString( scratch, sos );

    *pCol= col; return;
    }

void docRtfWriteDestinationEnd(		int *			pCol,
					SimpleOutputStream *	sos )
    {
    sioOutPutCharacter( '}', sos ); *pCol += 1;
    }

void docRtfWriteArgTag(	const char *		tag,
			int *			pCol,
			int			arg,
			SimpleOutputStream *	sos )
    {
    int		col= *pCol;
    char	scratch[20];
    int		len;

    sprintf( scratch, "%d", arg );

    len= strlen( tag )+ strlen( scratch );

    col += len;

    if  ( col > 72 )
	{
	docRtfWriteNextLine( &col, sos );
	col += len;
	}

    sioOutPutString( tag, sos );
    sioOutPutString( scratch, sos );

    *pCol= col; return;
    }

void docRtfEscapeString(	const unsigned char *	s,
				const unsigned char *	outputMapping,
				int *			pCol,
				int			n,
				SimpleOutputStream *	sos )
    {
    while( n && *s )
	{
	int		c= *s;

	if  ( outputMapping )
	    { c= outputMapping[c];	}

	switch( c )
	    {
	    case '{': case '\\': case '}':
		sioOutPutCharacter( '\\', sos );
		sioOutPutCharacter( c, sos );
		*pCol += 2;
		break;
	    default:
		if  ( c > 127 )
		    {
		    static char	hexdigits[]= "0123456789abcdef";

		    sioOutPutCharacter( '\\', sos );
		    sioOutPutCharacter( '\'', sos );
		    sioOutPutCharacter( hexdigits[ ( c >> 4 ) & 0x0f ], sos );
		    sioOutPutCharacter( hexdigits[ ( c >> 0 ) & 0x0f ], sos );
		    *pCol += 4;
		    }
		else{
		    sioOutPutCharacter( c, sos );
		    *pCol += 1;
		    }
		break;
	    }

	n--; s++;
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Write the tags that describe the geometry of a picture object.	*/
/*									*/
/************************************************************************/

int docRtfSavePictureTags(		InsertedObject *		io,
					int *				pCol,
					SimpleOutputStream *		sos )
    {
    int		xExt= io->ioXExtent;
    int		yExt= io->ioYExtent;

    if  ( xExt == 0 )
	{ xExt= (int)( 1000.0* io->ioTwipsWide )/ ( 20* POINTS_PER_CM ); }
    if  ( yExt == 0 )
	{ yExt= (int)( 1000.0* io->ioTwipsHigh )/ ( 20* POINTS_PER_CM ); }

    docRtfWriteArgTag( "\\picw", pCol, xExt, sos );
    docRtfWriteArgTag( "\\pich", pCol, yExt, sos );

    if  ( io->ioScaleX != 100 )
	{ docRtfWriteArgTag( "\\picscalex", pCol, io->ioScaleX, sos ); }
    if  ( io->ioScaleY != 100 )
	{ docRtfWriteArgTag( "\\picscaley", pCol, io->ioScaleY, sos ); }

    docRtfWriteArgTag( "\\picwgoal", pCol, io->ioTwipsWide, sos );
    docRtfWriteArgTag( "\\pichgoal", pCol, io->ioTwipsHigh, sos );

    if  ( io->ioTopCropTwips != 0 )
	{ docRtfWriteArgTag( "\\piccropt", pCol, io->ioTopCropTwips, sos ); }
    if  ( io->ioBottomCropTwips != 0 )
	{ docRtfWriteArgTag( "\\piccropb", pCol, io->ioBottomCropTwips, sos ); }
    if  ( io->ioLeftCropTwips != 0 )
	{ docRtfWriteArgTag( "\\piccropl", pCol, io->ioLeftCropTwips, sos ); }
    if  ( io->ioRightCropTwips != 0 )
	{ docRtfWriteArgTag( "\\piccropr", pCol, io->ioRightCropTwips, sos ); }

    if  ( io->ioBliptag == 0 )
	{ io->ioBliptag= appGetTimestamp(); 	}

    if  ( io->ioBliptag != 0 )
	{ docRtfWriteArgTag( "\\bliptag", pCol, io->ioBliptag, sos ); }

    return 0;
    }

/************************************************************************/
/*									*/
/*  Write object data.							*/
/*									*/
/************************************************************************/

int docRtfWriteMemoryBuffer(	const MemoryBuffer *		mb,
				int *				pCol,
				SimpleOutputStream *		sos )
    {
    const unsigned char *	s;
    int				i;

    int				col= *pCol;

    if  ( col+ mb->mbSize > 78 )
	{ docRtfWriteNextLine( &col, sos ); }

    s= mb->mbBytes;
    for ( i= 0; i < mb->mbSize; s++, i++ )
	{
	if  ( ! ( i % 78 ) )
	    { sioOutPutString( "\r\n", sos ); col= 0; }

	sioOutPutCharacter( *s, sos ); col++;
	}

    sioOutPutString( "\r\n}", sos ); col= 1;

    *pCol= col; return 0;
    }

/************************************************************************/
/*									*/
/*  Write a font table.							*/
/*									*/
/************************************************************************/

void docRtfWriteFontTable(	SimpleOutputStream *		sos,
				int *				pCol,
				const DocumentFontList *	dfl )
    {
    int				i;
    const DocumentFont *	df= dfl->dflFonts;

    docRtfWriteDestinationBegin( "\\fonttbl", pCol, sos );
    docRtfWriteNextLine( pCol, sos );

    for ( i= 0; i < dfl->dflCount; df++, i++ )
	{
	if  ( ! df->dfFamilyStyle && ! df->dfName )
	    { continue;	}

	docRtfWriteArgDestinationBegin( "\\f", pCol,
					    df->dfDocFamilyNumber, sos );

	sioOutPutCharacter( '\\', sos ); *pCol += 1;
	if  ( df->dfFamilyStyle )
	    {
	    sioOutPutString( df->dfFamilyStyle, sos );
	    *pCol += strlen( df->dfFamilyStyle );
	    }
	else{
	    sioOutPutString( "fnil", sos );
	    *pCol += 4;
	    }

	if  ( df->dfCharset != FONTcharsetDEFAULT )
	    { docRtfWriteArgTag( "\\fcharset", pCol, df->dfCharset, sos ); }

	if  ( df->dfPitch != FONTpitchDEFAULT )
	    { docRtfWriteArgTag( "\\fprq", pCol, df->dfPitch, sos ); }

	if  ( df->dfName )
	    {
	    sioOutPutCharacter( ' ', sos ); *pCol += 1;
	    sioOutPutString( df->dfName, sos );
	    *pCol += strlen( df->dfName );
	    }
	sioOutPutCharacter( ';', sos ); *pCol += 1;

	docRtfWriteDestinationEnd( pCol, sos );
	docRtfWriteNextLine( pCol, sos );
	}

    docRtfWriteDestinationEnd( pCol, sos );
    docRtfWriteNextLine( pCol, sos );

    return;
    }

/************************************************************************/
/*									*/
/*  Write a color table.						*/
/*									*/
/************************************************************************/

void docRtfWriteColorTable(	SimpleOutputStream *		sos,
				int *				pCol,
				const DocumentProperties *	dp )
    {
    int				i;
    const RGB8Color *		rgb8= dp->dpColors;

    docRtfWriteDestinationBegin( "\\colortbl", pCol, sos );
    docRtfWriteNextLine( pCol, sos );

    for ( i= 0; i < dp->dpColorCount; rgb8++, i++ )
	{
	if  ( i != dp->dpDefaultColor )
	    {
	    docRtfWriteArgTag( "\\red", pCol, rgb8->rgb8Red, sos );
	    docRtfWriteArgTag( "\\green", pCol, rgb8->rgb8Green, sos );
	    docRtfWriteArgTag( "\\blue", pCol, rgb8->rgb8Blue, sos );
	    }
	sioOutPutCharacter( ';', sos ); *pCol += 1;
	docRtfWriteNextLine( pCol, sos );
	}

    docRtfWriteDestinationEnd( pCol, sos );
    docRtfWriteNextLine( pCol, sos );

    return;
    }

/************************************************************************/
/*									*/
/*  Write a revision table.						*/
/*									*/
/************************************************************************/

void docRtfWriteRevisorTable(	SimpleOutputStream *		sos,
				const unsigned char *		outputMapping,
				int *				pCol,
				const DocumentProperties *	dp )
    {
    int				i;

    docRtfWriteDestinationBegin( "\\*\\revtbl", pCol, sos );
    docRtfWriteNextLine( pCol, sos );

    for ( i= 0; i < dp->dpAuthorCount; i++ )
	{
	int		col= 0;

	docRtfWriteDestinationBegin( "", pCol, sos );

	docRtfEscapeString( dp->dpAuthors[i], outputMapping, &col,
				strlen( (char *)dp->dpAuthors[i] ), sos );

	docRtfWriteDestinationEnd( pCol, sos );
	docRtfWriteNextLine( pCol, sos );
	}

    docRtfWriteDestinationEnd( pCol, sos );
    docRtfWriteNextLine( pCol, sos );

    return;
    }

