/************************************************************************/
/*									*/
/*  Identifies RTF control words					*/
/*									*/
/************************************************************************/

typedef enum RtfTag
    {
    RTFidRTF,
    RTFidRULER,

    RTFidUPR,
				/****************************************/
				/*  Document group.			*/
				/****************************************/
    RTFidFNIL,
    RTFidFROMAN,
    RTFidFSWISS,
    RTFidFMODERN,
    RTFidFSCRIPT,
    RTFidFDECOR,
    RTFidFTECH,
				/****************************************/
				/*  Kinds of font.			*/
				/****************************************/
    RTFidFCHARSET,
    RTFidFPRQ,
				/****************************************/
				/*  Font properties.			*/
				/****************************************/
    RTFidLIST,
    RTFidLISTID,
    RTFidLISTTEMPLATEID,
    RTFidLISTNAME,
    RTFidLISTSIMPLE,
    RTFidLISTRESTARTHDN,
				/****************************************/
				/*  Lists and their properties.		*/
				/****************************************/
    RTFidFONTTBL,
    RTFidCOLORTBL,
    RTFidPNTEXT,
    RTFidPN,
    RTFidSTYLESHEET,
    RTFidINFO,
    RTFidLISTTABLE,
				/****************************************/
				/*  Groups inside the document.		*/
				/****************************************/
    RTFidF,
    RTFidREVTBL,
				/****************************************/
				/*  Font number.			*/
				/****************************************/

    RTFidANSI,
    RTFidMAC,
    RTFidPC,
    RTFidPCA,
    RTFidUC,
    RTFidANSICPG,
				/****************************************/
				/*  Character sets.			*/
				/****************************************/
    RTFidRED,
    RTFidGREEN,
    RTFidBLUE,
				/****************************************/
				/*  Color references.			*/
				/****************************************/
    RTFidOGUTTER,

    RTFidDEFF,
    RTFidDEFLANGFE,
    RTFidVIEWKIND,
    RTFidVIEWSCALE,
				/****************************************/
				/*  Document properties.		*/
				/****************************************/
    RTFidSECTDEFAULTCL,
    RTFidLYTPRTMET,
				/****************************************/
				/*  Style sheet entries.		*/
				/****************************************/
    RTFidSBASEDON,
    RTFidSNEXT,
    RTFidSAUTOUPD,
    RTFidADDITIVE,
    RTFidSHIDDEN,
				/****************************************/
				/*  Document Formatting properties.	*/
				/****************************************/
    RTFidAENDDOC,
    RTFidAENDNOTES,
    RTFidAFTNBJ,
    RTFidAFTNNALC,
    RTFidAFTNNAR,
    RTFidAFTNNAUC,
    RTFidAFTNNCHI,
    RTFidAFTNNRLC,
    RTFidAFTNNRUC,
    RTFidAFTNRESTART,
    RTFidAFTNRSTPG,
    RTFidAFTNRSTCONT,
    RTFidAFTNSTART,
    RTFidAFTNTJ,
    RTFidALLPROT,
    RTFidANNOTPROT,
    RTFidBRKFRM,
    RTFidCVMME,
    RTFidDEFFORMAT,
    RTFidDEFLANG,
    RTFidDEFTAB,
    RTFidDOCTEMP,
    RTFidENDDOC,
    RTFidENDNOTES,
    RTFidFACINGP,
    RTFidFET,
    RTFidFLDALT,
    RTFidFORMDISP,
    RTFidFORMPROT,
    RTFidFORMSHADE,
    RTFidFRACWIDTH,
    RTFidFTNALT,
    RTFidFTNBJ,
    RTFidFTNNALC,
    RTFidFTNNAR,
    RTFidFTNNAUC,
    RTFidFTNNCHI,
    RTFidFTNNRLC,
    RTFidFTNNRUC,
    RTFidFTNRESTART,
    RTFidFTNRSTCONT,
    RTFidFTNRSTPG,
    RTFidFTNSTART,
    RTFidFTNTJ,
    RTFidGUTTER,
    RTFidHYPHAUTO,
    RTFidHYPHCAPS,
    RTFidHYPHCONSEC,
    RTFidHYPHHOTZ,
    RTFidLANDSCAPE,
    RTFidLINESTART,
    RTFidLINKSTYLES,
    RTFidLTRDOC,
    RTFidMAKEBACKUP,
    RTFidMARGB,
    RTFidMARGL,
    RTFidMARGMIRROR,
    RTFidMARGR,
    RTFidMARGT,
    RTFidNOCOLBAL,
    RTFidNOEXTRASPRL,
    RTFidNOTABIND,
    RTFidOTBLRUL,
    RTFidPAPERH,
    RTFidPAPERW,
    RTFidPGNSTART,
    RTFidPRCOLBL,
    RTFidPRINTDATA,
    RTFidPSOVER,
    RTFidPSZ,
    RTFidREVBAR,
    RTFidREVISIONS,
    RTFidREVPROP,
    RTFidREVPROT,
    RTFidRTLDOC,
    RTFidSPRSLNSP,
    RTFidSPRSSPBF,
    RTFidSPRSTSP,
    RTFidSUBFONTBYSIZE,
    RTFidSWPBDR,
    RTFidTRANSMF,
    RTFidIGHT,
    RTFidWIDOWCTRL,
    RTFidWRAPTRSP,
    RTFidVIEWZK,

    RTFidPGBRDRHEAD,
    RTFidPGBRDRFOOT,
    RTFidPGBRDRT,
    RTFidPGBRDRB,
    RTFidPGBRDRL,
    RTFidPGBRDRR,
    RTFidBRDRART,
    RTFidPGBRDROPT,
    RTFidPGBRDRSNAP,

    RTFidNOXLATTOYEN,
    RTFidEXPSHRTN,
    RTFidNOULTRLSPC,
    RTFidDNTBLNSBDB,
    RTFidNOSPACEFORUL,

    RTFidJCOMPRESS,
    RTFidJEXPAND,

    RTFidHORZDOC,
    RTFidDGHSPACE,
    RTFidDGVSPACE,
    RTFidDGHORIGIN,
    RTFidDGVORIGIN,
    RTFidDGHSHOW,
    RTFidDGVSHOW,
    RTFidDGMARGIN,

    RTFidNOLEAD,
    RTFidSPRSTSM,
    RTFidTRUNCEX,
    RTFidMSMCAP,
    RTFidSPLYTWNINE,
    RTFidFTNLYTWNINE,
    RTFidHTMAUTSP,
    RTFidUSELTBALN,
    RTFidALNTBLIND,
    RTFidLYTCALCTBLWD,
    RTFidLYTTBLRTGR,
    RTFidLNBRKRULE,

    RTFidBDRRLSWSIX,
    RTFidOLDAS,
				/****************************************/
				/*  Section Formatting Properties	*/
				/****************************************/
    RTFidBINFSXN,
    RTFidBINSXN,
    RTFidCOLNO,
    RTFidCOLSR,
    RTFidDS,
    RTFidENDNHERE,
    RTFidLINEBETCOL,
    RTFidLINECONT,
    RTFidLINEMOD,
    RTFidLINEPPAGE,
    RTFidLINERESTART,
    RTFidLINESTARTS,
    RTFidLINEX,
    RTFidLNDSCPSXN,
    RTFidLTRSECT,
    RTFidPGNHN,
    RTFidPGNHNSC,
    RTFidPGNHNSH,
    RTFidPGNHNSM,
    RTFidPGNHNSN,
    RTFidPGNHNSP,
    RTFidPGNX,
    RTFidPGNY,
    RTFidRTLSECT,
    RTFidSECTUNLOCKED,
    RTFidVERTALB,
    RTFidVERTALC,
    RTFidVERTALJ,
    RTFidVERTALT,

    RTFidSECTLINEGRID,
				/****************************************/
				/*  Paragraph Formatting Properties	*/
				/****************************************/
    RTFidINTBL,
    RTFidLEVEL,
    RTFidLTRPAR,
    RTFidNOLINE,
    RTFidRTLPAR,
    RTFidS,
    RTFidSBYS,
    RTFidSUBDOCUMENT,

    RTFidASPALPHA,
    RTFidASPNUM,

    RTFidJCLISTTAB,

    RTFidSBAUTO,
    RTFidSAAUTO,

    RTFidNOOVERFLOW,
    RTFidFAROMAN,

    RTFidTQL,			/*  Not in sqec				*/

				/****************************************/
				/*  Revision marks for paragraph	*/
				/*  numbers.				*/
				/****************************************/
    RTFidPNRAUTH,
    RTFidPNRDATE,
    RTFidPNRNFC,
    RTFidPNRPNBR,
    RTFidPNRRGB,
    RTFidPNRSTART,
    RTFidPNRSTOP,
    RTFidPNRXST,
				/****************************************/
				/*  Multilevel Lists.			*/
				/****************************************/
    RTFidPNSECLVL,

				/****************************************/
				/*  Tabs.				*/
				/****************************************/
    RTFidTB,
    RTFidTLDOT,
    RTFidTLEQ,
    RTFidTLHYPH,
    RTFidTLTH,
    RTFidTLUL,
    RTFidTQC,
    RTFidTQDEC,
    RTFidTQR,
    RTFidTX,

    RTFidADJUSTRIGHT, RTFidADJUSTLEFT,

    RTFidFC,
				/****************************************/
				/*  Paragraph Borders.			*/
				/****************************************/
    RTFidBOX,
    RTFidBRDRBAR,
    RTFidBRDRBTW,
    RTFidBRDRCF,
    RTFidBRDRDASH,
    RTFidBRDRL,
    RTFidBRDRR,
				/****************************************/
				/*  Character Formatting Properties	*/
				/****************************************/
    RTFidCB,
    RTFidCCHS,
    RTFidCF,
    RTFidCS,
    RTFidDELETED,
    RTFidDN,
    RTFidEXPND,
    RTFidEXPNDTW,
    /* RTFidF,	*/
    RTFidKERNING,
    RTFidLANG,
    RTFidNOPROOF,
    RTFidLTRCH,
    RTFidOUTL,
    RTFidREVAUTH,
    RTFidREVAUTHDEL,
    RTFidREVDTTM,
    RTFidREVDTTMDEL,
    RTFidREVISED,
    RTFidRTLCH,
    RTFidSHAD,
    RTFidULD,
    RTFidULDB,
    RTFidULNONE,
    RTFidULW,
    RTFidUP,
    RTFidV,
    RTFidHIGHLIGHT,

    RTFidCGRID,
    RTFidCHARSCALEX,

    RTFidCHBGHORIZ,
    RTFidCHBGVERT,
    RTFidCHBGFDIAG,
    RTFidCHBGBDIAG,
    RTFidCHBGCROSS,
    RTFidCHBGDCROSS,
    RTFidCHBGDKHORIZ,
    RTFidCHBGDKVERT,
    RTFidCHBGDKFDIAG,
    RTFidCHBGDKBDIAG,
    RTFidCHBGDKCROSS,
    RTFidCHBGDKDCROSS,

    RTFidCHBRDR,

    RTFidCHCBPAT,
    RTFidCHCFPAT,
    RTFidCHSHDNG,

    RTFidFAAUTO,
				/****************************************/
				/*  Pictures				*/
				/****************************************/
    RTFidPICT,
    RTFidNONSHPPICT,
    RTFidSHPPICT,

    RTFidBIN,
    RTFidDIBITMAP,
    RTFidMACPICT,
    RTFidPICBMP,
    RTFidPICBPP,
    RTFidPICCROPB,
    RTFidPICCROPL,
    RTFidPICCROPR,
    RTFidPICCROPT,
    RTFidPICH,
    RTFidPICHGOAL,
    RTFidPICSCALED,
    RTFidPICSCALEX,
    RTFidPICSCALEY,
    RTFidPICW,
    RTFidPICWGOAL,
    RTFidPMMETAFILE,
    RTFidWBITMAP,
    RTFidWBMBITSPIXEL,
    RTFidWBMPLANES,
    RTFidWBMWIDTHBYTES,
    RTFidWMETAFILE,
    RTFidPNGBLIP,
    RTFidJPEGBLIP,
    RTFidEMFBLIP,

    RTFidBLIPTAG,
    RTFidBLIPUPI,
				/****************************************/
				/*  Pictures, objects			*/
				/****************************************/
    RTFidOBJECT,
    RTFidOBJEMB,
    RTFidOBJCLASS,
    RTFidOBJNAME,
    RTFidOBJDATA,
    RTFidOBJW,
    RTFidOBJH,
    RTFidOBJSCALEX,
    RTFidOBJSCALEY,

    RTFidOBJSETSIZE,
    RTFidRSLTMERGE,
				/****************************************/
				/*  Special characters			*/
				/****************************************/
    RTFidBULLET,
    RTFidCHATN,
    RTFidCHDATE,
    RTFidCHDPA,
    RTFidCHDPL,
    RTFidCHFTN,
    RTFidCHFTNSEP,
    RTFidCHFTNSEPC,
    RTFidCHPGN,
    RTFidCHTIME,
    RTFidCOLUMN,
    RTFidEMDASH,
    RTFidEMSPACE,
    RTFidENDASH,
    RTFidENSPACE,
    RTFidLDBLQUOTE,
    RTFidLINE,
    RTFidLQUOTE,
    RTFidLTRMARK,
    RTFidPAGE,
    RTFidRDBLQUOTE,
    RTFidRQUOTE,
    RTFidRTLMARK,
    RTFidSECTNUM,
    RTFidSOFTCOL,
    RTFidSOFTLHEIGHT,
    RTFidSOFTLINE,
    RTFidSOFTPAGE,
    RTFidTAB,
    RTFidZWJ,
    RTFidZWNJ,

    RTFidU,
				/****************************************/
				/*  Hierarchy.				*/
				/****************************************/
    RTFidPAR,
    RTFidCELL,
    RTFidROW,
    RTFidSECT,
				/****************************************/
				/*  Table definitions			*/
				/****************************************/
    RTFidCELLX,
    RTFidCLBGBDIAG,
    RTFidCLBGCROSS,
    RTFidCLBGDCROSS,
    RTFidCLBGDKBDIAG,
    RTFidCLBGDKCROSS,
    RTFidCLBGDKDCROSS,
    RTFidCLBGDKFDIAG,
    RTFidCLBGDKHOR,
    RTFidCLBGDKVERT,
    RTFidCLBGFDIAG,
    RTFidCLBGHORIZ,
    RTFidCLBGVERT,
    RTFidCLBRDRB,
    RTFidCLBRDRL,
    RTFidCLBRDRR,
    RTFidCLBRDRT,
    RTFidCLCBPAT,
    RTFidCLCFPAT,
    RTFidCLSHDNG,
    RTFidCLMGF,
    RTFidCLMRG,
    RTFidCLVMGF,
    RTFidCLVMRG,
    RTFidLTRROW,
    RTFidRTLROW,
    RTFidTRBRDRB,
    RTFidTRBRDRH,
    RTFidTRBRDRL,
    RTFidTRBRDRR,
    RTFidTRBRDRT,
    RTFidTRBRDRV,
    RTFidTRGAPH,
    RTFidTRHDR,
    RTFidTRKEEP,
    RTFidTRLEFT,
    RTFidTROWD,
    RTFidTRQC,
    RTFidTRQL,
    RTFidTRQR,
    RTFidTRRH,

    RTFidTRPADDL,
    RTFidTRPADDR,
    RTFidTRPADDFL,
    RTFidTRPADDFR,
    RTFidTRWWIDTH,
    RTFidTRFTSWIDTH,

    RTFidCELLD,
    RTFidCLVERTALT,
    RTFidCLVERTALC,
    RTFidCLVERTALB,
    RTFidCLTXLRTB,
    RTFidCLTXTBRL,

    RTFidCLWWIDTH,
    RTFidCLFTSWIDTH,
				/****************************************/
				/*  Positioned objects and frames	*/
				/****************************************/
    RTFidDROPCAPLI,
    RTFidDROPCAPT,
				/****************************************/
				/*  Bullets and Numbering.		*/
				/*  (No destinations)			*/
				/****************************************/
    RTFidPNACROSS,
    RTFidPNB,
    RTFidPNCAPS,
    RTFidPNCARD,
    RTFidPNCF,
    RTFidPNDEC,
    RTFidPNF,
    RTFidPNFS,
    RTFidPNHANG,
    RTFidPNI,
    RTFidPNINDENT,
    RTFidPNLCLTR,
    RTFidPNLCRM,
    RTFidPNLVL,
    RTFidPNLVLBLT,
    RTFidPNLVLBODY,
    RTFidPNLVLCONT,
    RTFidPNNUMONCE,
    RTFidPNORD,
    RTFidPNORDT,
    RTFidPNPREV,
    RTFidPNQC,
    RTFidPNQL,
    RTFidPNQR,
    RTFidPNRESTART,
    RTFidPNSCAPS,
    RTFidPNSP,
    RTFidPNSTART,
    RTFidPNSTRIKE,
    RTFidPNUCLTR,
    RTFidPNUCRM,
    RTFidPNUL,
    RTFidPNULD,
    RTFidPNULDB,
    RTFidPNULNONE,
    RTFidPNULW,

    RTFidLS,
    RTFidILVL,
    RTFidPNRNOT,
				/****************************************/
				/*  Fields, Bookmarks.			*/
				/****************************************/
    RTFidDATAFIELD,
    RTFidFIELD,
    RTFidFLDDIRTY,
    RTFidFLDEDIT,
    RTFidFLDINST,
    RTFidFLDLOCK,
    RTFidFLDPRIV,
    RTFidFLDRSLT,

    RTFidBKMKSTART,
    RTFidBKMKEND,
    RTFidBKMKCOLF,
    RTFidBKMKCOLL,
				/****************************************/
				/*  Index entries.			*/
				/*  Table of contents entries.		*/
				/****************************************/
    RTFidXE,
    RTFidTXE,
    RTFidRXE,
    RTFidIXE,
    RTFidBXE,
    RTFidXEF,

    RTFidTC,
    RTFidTCN,
    RTFidTCF,
    RTFidTCL,
				/****************************************/
				/*  Footnote.				*/
				/*  ( Are destinations ).		*/
				/****************************************/
    RTFidFOOTNOTE,

				/****************************************/
				/*  Associated Character Properties	*/
				/****************************************/
    RTFidAB,
    RTFidACAPS,
    RTFidACF,
    RTFidADN,
    RTFidAEXPND,
    RTFidAF,
    RTFidAFS,
    RTFidAI,
    RTFidALANG,
    RTFidAOUTL,
    RTFidASCAPS,
    RTFidASHAD,
    RTFidASTRIKE,
    RTFidAUL,
    RTFidAULD,
    RTFidAULDB,
    RTFidAULNONE,
    RTFidAULW,
    RTFidAUP,

    RTFidLOCH,
    RTFidHICH,
    RTFidDBCH,
				/****************************************/
				/*  About bullet numbering.		*/
				/****************************************/
    RTFidPNTXTA,
    RTFidPNTXTB,
    RTFidLISTTEXT,
				/****************************************/
				/*  Groups inside the 'info' group.	*/
				/****************************************/
    RTFidTITLE,
    RTFidSUBJECT,
    RTFidAUTHOR,
    RTFidKEYWORDS,
    RTFidCOMMENT,
    RTFidHLINKBASE,
    RTFidOPERATOR,
    RTFidCREATIM,
    RTFidREVTIM,
    RTFidPRINTIM,
    RTFidVERSION,
    RTFidEDMINS,
    RTFidNOFPAGES,
    RTFidNOFWORDS,
    RTFidNOFCHARS,
    RTFidNOFCHARSWS,
    RTFidVERN,
				/****************************************/
				/*  Shapes.				*/
				/****************************************/
    RTFidSHP,

    RTFidSHPLEFT,
    RTFidSHPTOP,
    RTFidSHPBOTTOM,
    RTFidSHPRIGHT,
    RTFidSHPLID,
    RTFidSHPZ,
    RTFidSHPFHDR,
    RTFidSHPBXPAGE,
    RTFidSHPBXMARGIN,
    RTFidSHPBXCOLUMN,
    RTFidSHPBXIGNORE,
    RTFidSHPBYPAGE,
    RTFidSHPBYMARGIN,
    RTFidSHPBYCOLUMN,
    RTFidSHPBYIGNORE,
    RTFidSHPBYPARA,
    RTFidSHPWR,
    RTFidSHPWRK,
    RTFidSHPFBLWTXT,
    RTFidSHPLOCKANCHOR,

    RTFidSHPTXT,
    RTFidSHPRSLT,
    RTFidSHPINST,
    RTFidSHPGRP,

    RTFidSP,
    RTFidSV,
				/****************************************/
				/*  Fields in dates and times.		*/
				/****************************************/
    RTFidHR,
    RTFidMIN,
    RTFidSEC,
    RTFidDY,
    RTFidMO,
    RTFidYR,
				/****************************************/
				/*  Unknown				*/
				/****************************************/
    RTFidITAP,
    RTFidLIN,
    RTFidRIN,
    RTFidLANGNP,
    RTFidLANGFE,
    RTFidLANGFENP,
    RTFidNOLNHTADJTBL,

    RTFid__COUNT

    } RtfTag;

