/************************************************************************/
/*									*/
/*  Read/Write document properties to/from RTF.				*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	<psFont.h>

#   include	"docRtf.h"

/************************************************************************/
/*									*/
/*  Remember Document Properties.					*/
/*									*/
/************************************************************************/

void docRtfReadSetAnsicpg(	RtfReadingContext *	rrc,
				int			arg )
    {
    DocumentProperties *	dp= &(rrc->rrcBd->bdProperties);

    switch( arg )
	{
	case 1250:
	    memcpy( rrc->rrcInputMapping, docWIN1250_to_ISO2, 256 );
	    dp->dpAnsiCodePage= arg;
	    break;

	case 1251:
	    memcpy( rrc->rrcInputMapping, docWIN1251_to_KOI8R, 256 );
	    dp->dpAnsiCodePage= arg;
	    break;

	case 1252:
	    dp->dpAnsiCodePage= arg;
	    break;

	default:
	    LDEB(arg); break;
	}

    return;
    }

int docRtfRememberDocProperty(	SimpleInputStream *	sis,
				const RtfControlWord *	rcw,
				int			arg,
				RtfReadingContext *	rrc )
    {
    DocumentProperties *	dp= &(rrc->rrcBd->bdProperties);
    SectionProperties *		sp= &(rrc->rrcSectionProperties);

    switch( rcw->rcwId )
	{
	case RTFidMARGL:
	    dp->dpGeometry.dgLeftMarginTwips= arg;
	    sp->spDocumentGeometry.dgLeftMarginTwips= arg;
	    break;
	case RTFidMARGT:
	    dp->dpGeometry.dgTopMarginTwips= arg;
	    sp->spDocumentGeometry.dgTopMarginTwips= arg;
	    break;
	case RTFidMARGR:
	    dp->dpGeometry.dgRightMarginTwips= arg;
	    sp->spDocumentGeometry.dgRightMarginTwips= arg;
	    break;
	case RTFidMARGB:
	    dp->dpGeometry.dgBottomMarginTwips= arg;
	    sp->spDocumentGeometry.dgBottomMarginTwips= arg;
	    break;
	case RTFidPAPERW:
	    dp->dpGeometry.dgPageWideTwips= arg;
	    sp->spDocumentGeometry.dgPageWideTwips= arg;
	    break;
	case RTFidPAPERH:
	    dp->dpGeometry.dgPageHighTwips= arg;
	    sp->spDocumentGeometry.dgPageHighTwips= arg;
	    break;
	case RTFidGUTTER:
	    dp->dpGeometry.dgGutterTwips= arg;
	    sp->spDocumentGeometry.dgGutterTwips= arg;
	    break;

	case RTFidFACINGP:
	    dp->dpHasFacingPages= 1;
	    break;

	case RTFidWIDOWCTRL:
	    dp->dpWidowControl= 1;
	    break;

	case RTFidPGNSTART:
	    dp->dpStartPageNumber= arg;
	    break;
	case	RTFidDEFTAB:
	    dp->dpTabIntervalTwips= arg;
	    break;
	case	RTFidDEFF:
	    dp->dpDefaultFont= arg;
	    rrc->rrcCurrentTextAttribute.taFontNumber= arg;
	    break;

	case RTFidFET:
	    if  ( arg < 0 || arg > 2 )
		{ LDEB(arg); break;	}
	    dp->dpFootEndNoteType= arg;
	    break;

	case RTFidFTNSTART:
	    dp->dpStartFootnoteNumber= arg;
	    break;
	case RTFidAFTNSTART:
	    dp->dpStartEndnoteNumber= arg;
	    break;

	case RTFidENDNOTES:
	case RTFidENDDOC:
	case RTFidFTNTJ:
	case RTFidFTNBJ:
	    dp->dpFootnotePosition= rcw->rcwEnumValue;
	    break;

	case RTFidAENDNOTES:
	case RTFidAENDDOC:
	case RTFidAFTNTJ:
	case RTFidAFTNBJ:
	    dp->dpEndnotePosition= rcw->rcwEnumValue;
	    break;

	case RTFidFTNRSTCONT:
	case RTFidFTNRESTART:
	case RTFidFTNRSTPG:
	    dp->dpFootnotesRestart= rcw->rcwEnumValue;
	    break;

	case RTFidAFTNRSTCONT:
	case RTFidAFTNRESTART:
	case RTFidAFTNRSTPG:
	    dp->dpEndnotesRestart= rcw->rcwEnumValue;
	    break;

	case RTFidFTNNAR:
	case RTFidFTNNALC:
	case RTFidFTNNAUC:
	case RTFidFTNNRLC:
	case RTFidFTNNRUC:
	case RTFidFTNNCHI:
	    dp->dpFootnoteNumberStyle= rcw->rcwEnumValue;
	    break;

	case RTFidAFTNNAR:
	case RTFidAFTNNALC:
	case RTFidAFTNNAUC:
	case RTFidAFTNNRLC:
	case RTFidAFTNNRUC:
	case RTFidAFTNNCHI:
	    dp->dpEndnoteNumberStyle= rcw->rcwEnumValue;
	    break;

	case RTFidANSICPG:
	    docRtfReadSetAnsicpg( rrc, arg );
	    break;

	default:
	    break;
	}
    
    return 0;
    }

/************************************************************************/
/*									*/
/*  Save Document Properties to RTF.					*/
/*									*/
/************************************************************************/

static void docRtfSaveInfo(	const char *		tag,
				const unsigned char *	info,
				RtfWritingContext *	rwc,
				int *			pCol,
				SimpleOutputStream *	sos )
    {
    if  ( ! info )
	{ return;	}

    docRtfWriteDestinationBegin( tag, pCol, sos );

    docRtfEscapeString( info, rwc->rwcOutputMapping,
					pCol, strlen( (char *)info ), sos );

    docRtfWriteDestinationEnd( pCol, sos );
    docRtfWriteNextLine( pCol, sos );

    return;
    }

static void docRtfSaveDate(	const char *		tag,
				int *			pCol,
				const struct tm *	tm,
				SimpleOutputStream *	sos )
    {
    if  ( tm->tm_mday == 0 )
	{ return;	}

    docRtfWriteDestinationBegin( tag, pCol, sos );

    docRtfWriteArgTag( "\\yr",	pCol, tm->tm_year+ 1900, sos );
    docRtfWriteArgTag( "\\mo",	pCol, tm->tm_mon+ 1, sos );
    docRtfWriteArgTag( "\\dy",	pCol, tm->tm_mday, sos );
    docRtfWriteArgTag( "\\hr",	pCol, tm->tm_hour, sos );
    docRtfWriteArgTag( "\\min",	pCol, tm->tm_min, sos );
    docRtfWriteArgTag( "\\sec",	pCol, tm->tm_sec, sos );

    docRtfWriteDestinationEnd( pCol, sos );
    docRtfWriteNextLine( pCol, sos );

    return;
    }

int docRtfSaveDocumentProperties(	SimpleOutputStream *	sos,
					int *			pCol,
					RtfWritingContext *	rwc,
					const BufferDocument *	bd )
    {
    const DocumentProperties *	dp= &(bd->bdProperties);
    const DocumentGeometry *	dg= &(dp->dpGeometry);

    int				codePage= bd->bdProperties.dpAnsiCodePage;

    if  ( codePage >= 0 )
	{
	switch( codePage )
	    {
	    case 1250:
		docRtfWriteArgTag( "\\ansicpg", pCol, codePage, sos );
		memcpy( rwc->rwcOutputMapping, docISO2_to_WIN1250, 256 );
		break;

	    case 1251:
		docRtfWriteArgTag( "\\ansicpg", pCol, codePage, sos );
		memcpy( rwc->rwcOutputMapping, docKOI8R_to_WIN1251, 256 );
		break;

	    case 1252:
		docRtfWriteArgTag( "\\ansicpg", pCol, codePage, sos );
		break;

	    default:
		LDEB(codePage); break;
	    }
	}

    if  ( dp->dpFontList.dflCount > 0 )
	{
	docRtfWriteNextLine( pCol, sos );
	docRtfWriteFontTable( sos, pCol, &(dp->dpFontList) );
	}

    if  ( dp->dpColorCount > 0 )
	{
	docRtfWriteNextLine( pCol, sos );
	docRtfWriteColorTable( sos, pCol, dp );
	}

    if  ( bd->bdStyleSheet.dssStyleCount > 0 )
	{
	docRtfWriteNextLine( pCol, sos );
	docRtfWriteStyleSheet( sos, rwc->rwcOutputMapping,
						pCol, &(bd->bdStyleSheet) );
	}

    if  ( dp->dpAuthorCount > 0 )
	{
	docRtfWriteNextLine( pCol, sos );
	docRtfWriteRevisorTable( sos, rwc->rwcOutputMapping, pCol, dp );
	}

    if  ( docHasDocumentInfo( dp ) )
	{
	docRtfWriteNextLine( pCol, sos );
	docRtfWriteDestinationBegin( "\\info", pCol, sos );
	docRtfWriteNextLine( pCol, sos );

	docRtfSaveInfo( "\\title ",	dp->dpTitle, rwc, pCol, sos );
	docRtfSaveInfo( "\\author ",	dp->dpAuthor, rwc, pCol, sos );
	docRtfSaveInfo( "\\subject ",	dp->dpSubject, rwc, pCol, sos );
	docRtfSaveInfo( "\\keywords ",	dp->dpKeywords, rwc, pCol, sos );
	docRtfSaveInfo( "\\comment ",	dp->dpComment, rwc, pCol, sos );
	docRtfSaveInfo( "\\hlinkbase ",	dp->dpHlinkbase, rwc, pCol, sos );

	docRtfSaveDate( "\\creatim ",	pCol, &(dp->dpCreatim), sos );
	docRtfSaveDate( "\\revtim ",	pCol, &(dp->dpRevtim), sos );
	docRtfSaveDate( "\\printim ",	pCol, &(dp->dpPrintim), sos );

	docRtfWriteDestinationEnd( pCol, sos );
	}

    docRtfWriteNextLine( pCol, sos );

    docRtfWriteArgTag( "\\paperw", pCol, dg->dgPageWideTwips, sos );
    docRtfWriteArgTag( "\\paperh", pCol, dg->dgPageHighTwips, sos );

    docRtfWriteArgTag( "\\margl", pCol, dg->dgLeftMarginTwips, sos );
    docRtfWriteArgTag( "\\margr", pCol, dg->dgRightMarginTwips, sos );
    docRtfWriteArgTag( "\\margt", pCol, dg->dgTopMarginTwips, sos );
    docRtfWriteArgTag( "\\margb", pCol, dg->dgBottomMarginTwips, sos );

    if  ( dg->dgGutterTwips != 0 )
	{ docRtfWriteArgTag( "\\gutter", pCol, dg->dgGutterTwips, sos ); }

    if  ( dp->dpHasFacingPages )
	{ docRtfWriteTag( "\\facingp", pCol, sos );	}

    if  ( dp->dpWidowControl )
	{ docRtfWriteTag( "\\widowctrl", pCol, sos );	}

    if  ( dp->dpTabIntervalTwips > 0 && dp->dpTabIntervalTwips != 720 )
	{ docRtfWriteArgTag( "\\deftab", pCol, dp->dpTabIntervalTwips, sos ); }

    docRtfWriteNextLine( pCol, sos );

    switch( dp->dpFootnotePosition )
	{
	case DPftnPOS_SECT_END:
	    docRtfWriteTag( "\\endnotes", pCol, sos );
	    break;
	case DPftnPOS_DOC_END:
	    docRtfWriteTag( "\\enddoc", pCol, sos );
	    break;
	case DPftnPOS_BELOW_TEXT:
	    docRtfWriteTag( "\\ftntj", pCol, sos );
	    break;
	case DPftnPOS_PAGE_BOTTOM:
	    docRtfWriteTag( "\\ftnbj", pCol, sos );
	    break;
	default:
	    LDEB(dp->dpFootnotePosition); break;
	}

    switch( dp->dpEndnotePosition )
	{
	case DPftnPOS_SECT_END:
	    docRtfWriteTag( "\\aendnotes", pCol, sos );
	    break;
	case DPftnPOS_DOC_END:
	    docRtfWriteTag( "\\aenddoc", pCol, sos );
	    break;
	case DPftnPOS_BELOW_TEXT:
	    docRtfWriteTag( "\\aftntj", pCol, sos );
	    break;
	case DPftnPOS_PAGE_BOTTOM:
	    docRtfWriteTag( "\\aftnbj", pCol, sos );
	    break;
	default:
	    LDEB(dp->dpEndnotePosition); break;
	}

    if  ( dp->dpStartFootnoteNumber != 1 )
	{
	docRtfWriteArgTag( "\\ftnstart", pCol,
					dp->dpStartFootnoteNumber, sos );
	}
    if  ( dp->dpStartEndnoteNumber != 1 )
	{
	docRtfWriteArgTag( "\\aftnstart", pCol,
					dp->dpStartEndnoteNumber, sos );
	}

    switch( dp->dpFootnotesRestart )
	{
	case DPftnRST_CONTINUOUS:
	    docRtfWriteTag( "\\ftnrstcont", pCol, sos );
	    break;
	case DPftnRST_PER_SECTION:
	    docRtfWriteTag( "\\ftnrestart", pCol, sos );
	    break;
	case DPftnRST_PER_PAGE:
	    docRtfWriteTag( "\\ftnrstpg", pCol, sos );
	    break;
	default:
	    LDEB(dp->dpFootnotesRestart); break;
	}

    switch( dp->dpEndnotesRestart )
	{
	case DPftnRST_CONTINUOUS:
	    docRtfWriteTag( "\\aftnrstcont", pCol, sos );
	    break;
	case DPftnRST_PER_SECTION:
	    docRtfWriteTag( "\\aftnrestart", pCol, sos );
	    break;
	case DPftnRST_PER_PAGE:
	    docRtfWriteTag( "\\aftnrstpg", pCol, sos );
	    break;
	default:
	    LDEB(dp->dpEndnotesRestart); break;
	}


    switch( dp->dpFootnoteNumberStyle )
	{
	case DPftnNAR:
	    docRtfWriteTag( "\\ftnnar", pCol, sos );
	    break;
	case DPftnNALC:
	    docRtfWriteTag( "\\ftnnalc", pCol, sos );
	    break;
	case DPftnNAUC:
	    docRtfWriteTag( "\\ftnnauc", pCol, sos );
	    break;
	case DPftnNRLC:
	    docRtfWriteTag( "\\ftnnrlc", pCol, sos );
	    break;
	case DPftnNRUC:
	    docRtfWriteTag( "\\ftnnruc", pCol, sos );
	    break;
	case DPftnNCHI:
	    docRtfWriteTag( "\\ftnnchi", pCol, sos );
	    break;
	default:
	    LDEB(dp->dpFootnoteNumberStyle); break;
	}

    switch( dp->dpEndnoteNumberStyle )
	{
	case DPftnNAR:
	    docRtfWriteTag( "\\aftnnar", pCol, sos );
	    break;
	case DPftnNALC:
	    docRtfWriteTag( "\\aftnnalc", pCol, sos );
	    break;
	case DPftnNAUC:
	    docRtfWriteTag( "\\aftnnauc", pCol, sos );
	    break;
	case DPftnNRLC:
	    docRtfWriteTag( "\\aftnnrlc", pCol, sos );
	    break;
	case DPftnNRUC:
	    docRtfWriteTag( "\\aftnnruc", pCol, sos );
	    break;
	case DPftnNCHI:
	    docRtfWriteTag( "\\aftnnchi", pCol, sos );
	    break;
	default:
	    LDEB(dp->dpEndnoteNumberStyle); break;
	}

    docRtfWriteNextLine( pCol, sos );

    return 0;
    }

