/************************************************************************/
/*									*/
/*  Layout of a document.						*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>
#   define	y0	math_y0
#   define	y1	math_y1
#   include	<math.h>
#   undef	y0
#   undef	y1

#   include	"docPs.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Default leading in terms of the size of the dominant font in a	*/
/*  paragraph.								*/
/*									*/
/************************************************************************/

#   define LINEDISTFAC	5

/************************************************************************/
/*									*/
/*  Continue to lay out the text on a subsequent page.			*/
/*									*/
/************************************************************************/

void docPsStartPageLayout(	int				page,
				BufferItem *			sectBi,
				const DocumentProperties *	dp,
				AppDrawingData *		add,
				LayoutPosition *		lpTop )
    {
    const SectionProperties *	sp= &(sectBi->biSectProperties);
    const DocumentGeometry *	dg= &(sp->spDocumentGeometry);

    HeaderFooter *		hf= (HeaderFooter *)0;
    int				inHeaderFooter;

    inHeaderFooter= docWhatPageHeader( &hf, sectBi, page, dp );

    lpTop->lpPage= page;
    if  ( hf && hf->hfItem )
	{ lpTop->lpPageYTwips= hf->hfY1ReservedTwips;	}
    else{ lpTop->lpPageYTwips= dg->dgTopMarginTwips;	}

    lpTop->lpAtTopOfColumn= 1;
    }

void docPsToNextPage(		BufferItem *			bi,
				const DocumentProperties *	dp,
				AppDrawingData *		add,
				LayoutPosition *		lpTop )
    {
    while ( bi				&&
	    bi->biLevel != DOClevSECT	)
	{ bi= bi->biParent;	}

    if  ( ! bi )
	{ XDEB(bi); return;	}

    docPsStartPageLayout( lpTop->lpPage+ 1, bi, dp, add, lpTop );

    return;
    }

/************************************************************************/
/*									*/
/*  Calculate the height of a series of lines in a paragraph.		*/
/*									*/
/************************************************************************/

static void docPsAboveParagraph(	BufferItem *			bi )
    {
    int				above= 0;
    const BorderProperties *	bp= (const BorderProperties *)0;

    above= bi->biParaSpaceBeforeTwips;

    if  ( bi->biParaInTable			&&
	  bi->biNumberInParent == 0		)
	{
	const BufferItem *	rowBi= bi->biParent->biParent;
	const CellProperties *	cp;
	int			col= bi->biParent->biNumberInParent;

	if  ( col >= rowBi->biRowCellCount )
	    { LLDEB(col,rowBi->biRowCellCount);	}
	else{
	    cp= &(rowBi->biRowCells[col]);

	    if  ( cp->cpTopBorder.bpStyle != DOCbsNONE )
		{
		above += cp->cpTopBorder.bpSpacingTwips;
		/*  Word seems not to allocate this
		above += cp->cpTopBorder.bpWidthTwips;
		*/
		}
	    }

	/*  Nicer but Word does not do this.
	above += ( bi->biParaLeadingTwips+ 1 )/ 2;
	*/
	}

    if  ( bi->biParaTopBorder.bpStyle != DOCbsNONE )
	{
	/*  Word seems not to allocate this
	above += bi->biParaTopBorder.bpWidthTwips;
	*/
	above += bi->biParaTopBorder.bpSpacingTwips;
	bp= &(bi->biParaTopBorder);
	}
    else{
	if  ( bi->biParaBoxBorder.bpStyle != DOCbsNONE )
	    {
	    BufferItem *	prevBi= (BufferItem *)0;

	    if  ( bi->biNumberInParent > 0 )
		{
		prevBi= bi->biParent->biChildren[
					    bi->biNumberInParent- 1];
		}
	    if  ( ! prevBi					||
		  prevBi->biParaBoxBorder.bpStyle == DOCbsNONE	)
		{
		/*  Word seems not to allocate this
		above += bi->biParaBoxBorder.bpWidthTwips;
		*/
		above += bi->biParaBoxBorder.bpSpacingTwips;
		bp= &(bi->biParaBoxBorder);
		}
	    }
	}

    bi->biParaSpaceAboveLinesTwips= above;
    bi->biParaBorderAboveParagraph= bp;

    return;
    }

static void docPsBelowParagraph(	BufferItem *			bi )
    {
    int				below= 0;
    const BorderProperties *	bp= (const BorderProperties *)0;

    if  ( bi->biParaBottomBorder.bpStyle != DOCbsNONE )
	{
	below += bi->biParaLeadingTwips;
	below += bi->biParaBottomBorder.bpSpacingTwips;
	/*  Word seems not to allocate this
	below += bi->biParaBottomBorder.bpWidthTwips;
	*/
	bp= &(bi->biParaBottomBorder);
	}
    else{
	if  ( bi->biParaBoxBorder.bpStyle != DOCbsNONE )
	    {
	    BufferItem *	nextBi= (BufferItem *)0;

	    if  ( bi->biNumberInParent <
				bi->biParent->biChildCount- 1 )
		{
		nextBi= bi->biParent->biChildren[
					    bi->biNumberInParent+ 1];
		}

	    if  ( ! nextBi					||
		  nextBi->biParaBoxBorder.bpStyle == DOCbsNONE	)
		{
		below += bi->biParaLeadingTwips;
		below += bi->biParaBoxBorder.bpSpacingTwips;
		/*  Word seems not to allocate this
		below += bi->biParaBoxBorder.bpWidthTwips;
		*/
		bp= &(bi->biParaBoxBorder);
		}
	    }
	}

    if  ( bi->biParaInTable					&&
	  bi->biNumberInParent == bi->biParent->biChildCount- 1	)
	{
	const BufferItem *	rowBi= bi->biParent->biParent;
	const CellProperties *	cp;
	int			col= bi->biParent->biNumberInParent;

	/*  Nicer but Word does not do this.
	below += bi->biParaLeadingTwips/ 2;
	*/

	if  ( col >= rowBi->biRowCellCount )
	    { LLDEB(col,rowBi->biRowCellCount);	}
	else{
	    cp= &(rowBi->biRowCells[col]);

	    if  ( cp->cpBottomBorder.bpStyle != DOCbsNONE )
		{
		below += cp->cpBottomBorder.bpSpacingTwips;
		/*  Word seems not to allocate this
		below += cp->cpBottomBorder.bpWidthTwips;
		*/
		}
	    }
	}

    below += bi->biParaSpaceAfterTwips;

    bi->biParaSpaceBelowLinesTwips= below;
    bi->biParaBorderBelowParagraph= bp;

    return;
    }

/************************************************************************/
/*									*/
/*  Determine the 'majority' font of a paragraph, and get the font	*/
/*  extents for that font.						*/
/*									*/
/*  1)  Note that subscript/superscript is NOT taken into account.	*/
/*									*/
/************************************************************************/

int docPsParagraphLineExtents(	const AppPhysicalFontList *	apfl,
				BufferItem *			bi )
    {
    const TextParticule *	tp= bi->biParaParticules;

    int				size;
    int				paraAscent= 0;
    int				paraDescent= 0;
    int				i;

    static int *		counts;
    int *			fresh;

    int				found;
    int				foundCount;

    fresh= (int *)realloc( counts, apfl->apflCount* sizeof(int) );
    if  ( ! fresh )
	{ LXDEB(apfl->apflCount,fresh); return -1;	}
    counts= fresh;

    for ( i= 0; i < apfl->apflCount; i++ )
	{ counts[i]= 0;	}

    for ( i= 0; i < bi->biParaParticuleCount; tp++, i++ )
	{
	if  ( tp->tpKind != DOCkindTEXT		&&
	      tp->tpKind != DOCkindTAB		&&
	      tp->tpKind != DOCkindOBJECT	)
	    { continue;	}

	if  ( tp->tpPhysicalFont < 0			||
	      tp->tpPhysicalFont >= apfl->apflCount	)
	    { LLDEB(tp->tpPhysicalFont,apfl->apflCount); continue;	}

	counts[tp->tpPhysicalFont] += tp->tpStrlen+ 1;
	}

    found= -1;
    foundCount= 0;
    for ( i= 0; i < apfl->apflCount; i++ )
	{
	if  ( counts[i] > foundCount )
	    { found= i; foundCount= counts[i];	}
	}

    if  ( found >= 0 )
	{
	AfmFontInfo *	afi;

	afi= docPsPrintGetAfi( apfl, found );

	size= 10* apfl->apflFonts[found].apfAttribute.taFontSizeHalfPoints;

	paraAscent= ( size* afi->afiFontBBox.abbTop+ 500 ) / 1000;
	paraDescent= paraAscent- size;
	}
    else{ /* LDEB(found); */ size= 200;	}

    bi->biParaAscentTwips= paraAscent;
    bi->biParaDescentTwips= paraDescent;

    bi->biParaLeadingTwips= size/ LINEDISTFAC;

    docPsAboveParagraph( bi );
    docPsBelowParagraph( bi );

    return 0;
    }

/************************************************************************/
/*									*/
/*  Insert the correct page number in a page header/footer.		*/
/*									*/
/************************************************************************/

int docLayoutHeaderFooter(	HeaderFooter *			hf,
				int				page,
				BufferDocument *		bd,
				const BufferItem *		sectBi,
				AppDrawingData *		add,
				LAYOUT_EXTERNAL			layoutExternal,
				DocumentRectangle *		drChanged,
				DOC_CLOSE_OBJECT		closeObject )
    {
    if  ( page != hf->hfPageUsedFor )
	{
	int		changed= 0;

	hf->hfItem->biSectHeaderFooterUseForSectBi= sectBi;
	hf->hfItem->biSectHeaderFooterUseForPage= page;

	if  ( docRecalculateTextLevelFields( &changed, bd, hf->hfItem,
		FIELDdoDOC_FORMATTED|FIELDdoDOC_COMPLETE|FIELDdoPAGE_NUMBER,
						(void *)add, closeObject ) )
	    { LDEB(page); return -1;	}

	if  ( layoutExternal 						&&
	      (*layoutExternal)( hf, page, &(sectBi->biSectProperties),
						bd, add, drChanged )	)
	    { LDEB(1); return -1;	}

	hf->hfPageUsedFor= page;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Derive the frame for a paragraph from the page rectangle and the	*/
/*  paragraph properties.						*/
/*									*/
/*  For paragraphs inside a table cell, geometry is derived from the	*/
/*  table column.							*/
/*									*/
/************************************************************************/

void docParagraphFrameTwips(	FormattingFrame *		ff,
				int				bottom,
				int				stripHigh,
				const BufferItem *		paraBi,
				const DocumentProperties *	dp,
				int				page,
				int				column )
    {
    BufferItem *		sectBi;
    const SectionProperties *	sp;
    const DocumentGeometry *	dg;

    HeaderFooter *		hf= (HeaderFooter *)0;
    int				inHeaderFooter;

    sectBi= paraBi->biParent;
    while( sectBi				&&
	   sectBi->biLevel != DOClevSECT	)
	{ sectBi= sectBi->biParent;	}

    if  ( ! sectBi )
	{ SXDEB(docLevelStr(paraBi->biLevel),sectBi); return;	}

    sp= &(sectBi->biSectProperties);
    dg= &(sp->spDocumentGeometry);

    ff->ffX0GeometryTwips= dg->dgLeftMarginTwips;
    ff->ffX1GeometryTwips= dg->dgPageWideTwips- dg->dgRightMarginTwips;

    ff->ffPageHigh= dg->dgPageHighTwips-
			    dg->dgTopMarginTwips- dg->dgBottomMarginTwips;
    ff->ffStripHigh= stripHigh;

    switch( sectBi->biInHeaderFooter )
	{
	case DOCinBODY:
	    inHeaderFooter= docWhatPageFooter( &hf, sectBi, page, dp );

	    if  ( hf && hf->hfItem )
		{ ff->ffY1= hf->hfY0ReservedTwips;			  }
	    else{ ff->ffY1= dg->dgPageHighTwips- dg->dgBottomMarginTwips; }
	    break;

	case DOCinSECT_HEADER:
	    hf= &(sectBi->biSectHeader);
	    ff->ffY1= hf->hfY1ReservedTwips;
	    break;

	case DOCinFIRST_HEADER:
	    hf= &(sectBi->biSectFirstPageHeader);
	    ff->ffY1= hf->hfY1ReservedTwips;
	    break;

	case DOCinLEFT_HEADER:
	    hf= &(sectBi->biSectLeftPageHeader);
	    ff->ffY1= hf->hfY1ReservedTwips;
	    break;

	case DOCinRIGHT_HEADER:
	    hf= &(sectBi->biSectRightPageHeader);
	    ff->ffY1= hf->hfY1ReservedTwips;
	    break;

	case DOCinSECT_FOOTER:
	    hf= &(sectBi->biSectFooter);
	    ff->ffY1= hf->hfY1ReservedTwips;
	    break;

	case DOCinFIRST_FOOTER:
	    hf= &(sectBi->biSectFirstPageFooter);
	    ff->ffY1= hf->hfY1ReservedTwips;
	    break;

	case DOCinLEFT_FOOTER:
	    hf= &(sectBi->biSectLeftPageFooter);
	    ff->ffY1= hf->hfY1ReservedTwips;
	    break;

	case DOCinRIGHT_FOOTER:
	    hf= &(sectBi->biSectRightPageFooter);
	    ff->ffY1= hf->hfY1ReservedTwips;
	    break;

	case DOCinFOOTNOTE:
	default:
	    LDEB(sectBi->biInHeaderFooter);
	}

    if  ( bottom > 0		&&
	  bottom <= ff->ffY1	)
	{ ff->ffY1= bottom;						}

    if  ( paraBi->biParaInTable )
	{
	int			col0;
	int			col1;
	const BufferItem *	cellBi= paraBi->biParent;
	const BufferItem *	rowBi= cellBi->biParent;
	const RowProperties *	rp= &(rowBi->biRowProperties);

	col0= col1= cellBi->biNumberInParent;

	if  ( col1 >= rowBi->biRowCellCount )
	    { LLDEB(col1,rowBi->biRowCellCount);	}
	else{
	    const CellProperties *	cp1= rp->rpCells+ col1;

	    if  ( cp1->cpLeftInMergedRow )
		{
		while( col1 < rowBi->biRowCellCount- 1	&&
		       cp1[1].cpMergedWithLeft		)
		    { col1++; cp1++;	}
		}

	    ff->ffX1GeometryTwips=
			    dg->dgLeftMarginTwips+ cp1->cpRightBoundaryTwips;

	    if  ( col0 == 0 )
		{ ff->ffX0GeometryTwips += rowBi->biRowLeftIndentTwips;	}
	    else{
		CellProperties *	cpp;

		cpp= rp->rpCells+ col0- 1;
		ff->ffX0GeometryTwips += cpp->cpRightBoundaryTwips;
		}
	    }

	ff->ffX0GeometryTwips += rowBi->biRowHalfGapWidthTwips;
	ff->ffX1GeometryTwips -= rowBi->biRowHalfGapWidthTwips;
	}

    ff->ffX0TextLinesTwips= ff->ffX0GeometryTwips+
					paraBi->biParaLeftIndentTwips;
    ff->ffX1TextLinesTwips= ff->ffX1GeometryTwips-
					paraBi->biParaRightIndentTwips;

    ff->ffX0FirstLineTwips= ff->ffX0TextLinesTwips+
					paraBi->biParaFirstIndentTwips;

    return;
    }

