/************************************************************************/
/*									*/
/*  Manipulate iten properties in a document.				*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>

#   include	"docParaProperties.h"

/************************************************************************/
/*									*/
/*  Manage paragraph properties.					*/
/*									*/
/************************************************************************/

void docCleanParagraphProperties(	ParagraphProperties *	pp )
    {
    if  ( pp->ppTabStops )
	{ free( pp->ppTabStops );	}
    }

void docInitParagraphProperties(	ParagraphProperties *	pp )
    {
    pp->ppTabCount= 0;
    pp->ppTabStops= (TabStop *)0;

    pp->ppFirstIndentTwips= 0;
    pp->ppLeftIndentTwips= 0;
    pp->ppRightIndentTwips= 0;

    pp->ppSpaceBeforeTwips= 0;
    pp->ppSpaceAfterTwips= 0;
    pp->ppLineSpacingTwips= 0;

    pp->ppStyle= 0;

    docInitBorderProperties( &(pp->ppTopBorder) );
    docInitBorderProperties( &(pp->ppLeftBorder) );
    docInitBorderProperties( &(pp->ppRightBorder) );
    docInitBorderProperties( &(pp->ppBottomBorder) );
    docInitBorderProperties( &(pp->ppBoxBorder) );
    docInitBorderProperties( &(pp->ppBetweenBorder) );
    docInitBorderProperties( &(pp->ppBar) );

    pp->ppOutlineLevel= 9;

    pp->ppShadingLevel= 0;
    pp->ppShadingPattern= DOCspSOLID;

    pp->ppAlignment= DOCiaLEFT;

    pp->ppStartsOnNewPage= 0;
    pp->ppInTable= 0;
    pp->ppLineSpacingIsMultiple= 0;

    pp->ppKeepOnPage= 0;
    pp->ppKeepWithNext= 0;
    pp->ppWidowControl= 0;
    pp->ppHyphenateParagraph= 0;

    pp->ppShadingForeground= 0;
    pp->ppShadingBackground= 0;

    return;
    }

static int docParaCopyTabs(	ParagraphProperties *		to,
				const ParagraphProperties *	from )
    {
    TabStop *	tabs= (TabStop *)0;

    if  ( from->ppTabCount > 0 )
	{
	int	i;

	tabs= (TabStop *)realloc( to->ppTabStops,
					from->ppTabCount* sizeof(TabStop) );
	if  ( ! tabs )
	    { LXDEB(from->ppTabCount,tabs); return -1;	}

	for ( i= 0; i < from->ppTabCount; i++ )
	    { tabs[i]= from->ppTabStops[i];	}
	}


    to->ppTabStops= tabs;
    to->ppTabCount= from->ppTabCount;

    return 0;
    }

int docCopyParagraphProperties(	ParagraphProperties *		to,
				const ParagraphProperties *	from	)
    {
    TabStop *	tabs;

    if  ( docParaCopyTabs( to, from ) )
	{ LDEB(from->ppTabCount); return -1;	}

    tabs= to->ppTabStops;
    *to= *from;
    to->ppTabStops= tabs;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Change paragraph properties and tell what has been changed.		*/
/*									*/
/************************************************************************/

int docUpdParaProperties(	unsigned int *			pPpChgPask,
				ParagraphProperties *		pp,
				unsigned int			ppUpdMask,
				const ParagraphProperties *	ppNew )
    {
    unsigned int		ppChgMask= 0;

    if  ( PROPmaskISSET( ppUpdMask, PPpropSTYLE ) )
	{
	if  ( pp->ppStyle != ppNew->ppStyle )
	    {
	    pp->ppStyle= ppNew->ppStyle;
	    PROPmaskADD( &ppChgMask, PPpropSTYLE );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropFIRST_INDENT ) )
	{
	if  ( pp->ppFirstIndentTwips != ppNew->ppFirstIndentTwips )
	    {
	    pp->ppFirstIndentTwips= ppNew->ppFirstIndentTwips;
	    PROPmaskADD( &ppChgMask, PPpropFIRST_INDENT );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropLEFT_INDENT ) )
	{
	if  ( pp->ppLeftIndentTwips != ppNew->ppLeftIndentTwips )
	    {
	    pp->ppLeftIndentTwips= ppNew->ppLeftIndentTwips;
	    PROPmaskADD( &ppChgMask, PPpropLEFT_INDENT );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropRIGHT_INDENT ) )
	{
	if  ( pp->ppRightIndentTwips != ppNew->ppRightIndentTwips )
	    {
	    pp->ppRightIndentTwips= ppNew->ppRightIndentTwips;
	    PROPmaskADD( &ppChgMask, PPpropRIGHT_INDENT );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropALIGNMENT ) )
	{
	if  ( pp->ppAlignment != ppNew->ppAlignment )
	    {
	    pp->ppAlignment= ppNew->ppAlignment;
	    PROPmaskADD( &ppChgMask, PPpropALIGNMENT );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropTAB_STOPS ) )
	{
	if  ( pp->ppTabCount > 0 || ppNew->ppTabCount > 0 )
	    {
	    if  ( pp->ppTabCount != ppNew->ppTabCount )
		{ PROPmaskADD( &ppChgMask, PPpropTAB_STOPS );	}

	    if  ( ppNew->ppTabCount == 0 )
		{ pp->ppTabCount= 0;	}
	    else{
		TabStop *			ts;
		TabStop *			ots= pp->ppTabStops;
		TabStop *			nts= ppNew->ppTabStops;
		int				tab;

		ts= (TabStop *)malloc( ppNew->ppTabCount* sizeof(TabStop) );
		if  ( ! ts )
		    { LXDEB(ppNew->ppTabCount,ts); return -1;	}

		for ( tab= 0; tab < ppNew->ppTabCount; tab++ )
		    {
		    if  ( pp->ppTabCount == ppNew->ppTabCount )
			{
			if  ( nts[tab].tsTwips != ots[tab].tsTwips	||
			      nts[tab].tsKind != ots[tab].tsKind	||
			      nts[tab].tsLeader != ots[tab].tsLeader	)
			    {
			    PROPmaskADD( &ppChgMask, PPpropTAB_STOPS );
			    ts[tab]= nts[tab];
			    }
			else{ ts[tab]= ots[tab];	}
			}
		    else{ ts[tab]= nts[tab];		}
		    }

		pp->ppTabCount= ppNew->ppTabCount;
		if  ( pp->ppTabStops )
		    { free( pp->ppTabStops );	}

		pp->ppTabStops= ts;
		}
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropNEWPAGE ) )
	{
	if  ( pp->ppStartsOnNewPage != ppNew->ppStartsOnNewPage )
	    {
	    pp->ppStartsOnNewPage= ppNew->ppStartsOnNewPage;
	    PROPmaskADD( &ppChgMask, PPpropNEWPAGE );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropWIDCTLPAR ) )
	{
	if  ( pp->ppWidowControl != ppNew->ppWidowControl )
	    {
	    pp->ppWidowControl= ppNew->ppWidowControl;
	    PROPmaskADD( &ppChgMask, PPpropWIDCTLPAR );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropKEEPN ) )
	{
	if  ( pp->ppKeepWithNext != ppNew->ppKeepWithNext )
	    {
	    pp->ppKeepWithNext= ppNew->ppKeepWithNext;
	    PROPmaskADD( &ppChgMask, PPpropKEEPN );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropKEEP ) )
	{
	if  ( pp->ppKeepOnPage != ppNew->ppKeepOnPage )
	    {
	    pp->ppKeepOnPage= ppNew->ppKeepOnPage;
	    PROPmaskADD( &ppChgMask, PPpropKEEP );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropSPACE_BEFORE ) )
	{
	if  ( pp->ppSpaceBeforeTwips != ppNew->ppSpaceBeforeTwips )
	    {
	    pp->ppSpaceBeforeTwips= ppNew->ppSpaceBeforeTwips;
	    PROPmaskADD( &ppChgMask, PPpropSPACE_BEFORE );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropSPACE_AFTER ) )
	{
	if  ( pp->ppSpaceAfterTwips != ppNew->ppSpaceAfterTwips )
	    {
	    pp->ppSpaceAfterTwips= ppNew->ppSpaceAfterTwips;
	    PROPmaskADD( &ppChgMask, PPpropSPACE_AFTER );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropLINE_SPACING_DIST ) )
	{
	if  ( pp->ppLineSpacingTwips != ppNew->ppLineSpacingTwips )
	    {
	    pp->ppLineSpacingTwips= ppNew->ppLineSpacingTwips;
	    PROPmaskADD( &ppChgMask, PPpropLINE_SPACING_DIST );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropLINE_SPACING_MULT ) )
	{
	if  ( pp->ppLineSpacingIsMultiple != ppNew->ppLineSpacingIsMultiple )
	    {
	    pp->ppLineSpacingIsMultiple= ppNew->ppLineSpacingIsMultiple;
	    PROPmaskADD( &ppChgMask, PPpropLINE_SPACING_MULT );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropTOP_BORDER ) )
	{
	if  ( docBorderPropertyDifference( &(pp->ppTopBorder),
					&(ppNew->ppTopBorder), BRDRupdALL ) )
	    {
	    docCopyBorderProperties( &(pp->ppTopBorder),
						&(ppNew->ppTopBorder) );
	    PROPmaskADD( &ppChgMask, PPpropTOP_BORDER );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropBOTTOM_BORDER ) )
	{
	if  ( docBorderPropertyDifference( &(pp->ppBottomBorder),
				    &(ppNew->ppBottomBorder), BRDRupdALL ) )
	    {
	    docCopyBorderProperties( &(pp->ppBottomBorder),
						&(ppNew->ppBottomBorder) );
	    PROPmaskADD( &ppChgMask, PPpropBOTTOM_BORDER );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropOUTLINELEVEL ) )
	{
	if  ( pp->ppOutlineLevel != ppNew->ppOutlineLevel )
	    {
	    pp->ppOutlineLevel= ppNew->ppOutlineLevel;
	    PROPmaskADD( &ppChgMask, PPpropOUTLINELEVEL );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropHYPHPAR ) )
	{
	if  ( pp->ppHyphenateParagraph != ppNew->ppHyphenateParagraph )
	    {
	    pp->ppHyphenateParagraph= ppNew->ppHyphenateParagraph;
	    PROPmaskADD( &ppChgMask, PPpropHYPHPAR );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropSHADING_LEVEL ) )
	{
	if  ( pp->ppShadingLevel != ppNew->ppShadingLevel )
	    {
	    pp->ppShadingLevel= ppNew->ppShadingLevel;
	    PROPmaskADD( &ppChgMask, PPpropSHADING_LEVEL );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropSHADING_PATTERN ) )
	{
	if  ( pp->ppShadingPattern != ppNew->ppShadingPattern )
	    {
	    pp->ppShadingPattern= ppNew->ppShadingPattern;
	    PROPmaskADD( &ppChgMask, PPpropSHADING_PATTERN );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropSHADING_FOREGROUND ) )
	{
	if  ( pp->ppShadingForeground != ppNew->ppShadingForeground )
	    {
	    pp->ppShadingForeground= ppNew->ppShadingForeground;
	    PROPmaskADD( &ppChgMask, PPpropSHADING_FOREGROUND );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropSHADING_BACKGROUND ) )
	{
	if  ( pp->ppShadingBackground != ppNew->ppShadingBackground )
	    {
	    pp->ppShadingBackground= ppNew->ppShadingBackground;
	    PROPmaskADD( &ppChgMask, PPpropSHADING_BACKGROUND );
	    }
	}

    *pPpChgPask= ppChgMask; return 0;
    }

/************************************************************************/
/*									*/
/*  Compare paragraph properties.					*/
/*									*/
/************************************************************************/

unsigned int docParaPropertyDifference(	const ParagraphProperties *	pp1,
					const ParagraphProperties *	pp2,
					unsigned int			updMask)
    {
    unsigned int		changedMask= 0;

    if  ( PROPmaskISSET( updMask, PPpropSTYLE ) )
	{
	if  ( pp1->ppStyle != pp2->ppStyle )
	    { PROPmaskADD( &changedMask, PPpropSTYLE ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropFIRST_INDENT ) )
	{
	if  ( pp1->ppFirstIndentTwips != pp2->ppFirstIndentTwips )
	    { PROPmaskADD( &changedMask, PPpropFIRST_INDENT ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropLEFT_INDENT ) )
	{
	if  ( pp1->ppLeftIndentTwips != pp2->ppLeftIndentTwips )
	    { PROPmaskADD( &changedMask, PPpropLEFT_INDENT ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropRIGHT_INDENT ) )
	{
	if  ( pp1->ppRightIndentTwips != pp2->ppRightIndentTwips )
	    { PROPmaskADD( &changedMask, PPpropRIGHT_INDENT ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropALIGNMENT ) )
	{
	if  ( pp1->ppAlignment != pp2->ppAlignment )
	    { PROPmaskADD( &changedMask, PPpropALIGNMENT ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropTAB_STOPS ) )
	{
	if  ( pp1->ppTabCount > 0 || pp2->ppTabCount > 0 )
	    {
	    if  ( pp1->ppTabCount != pp2->ppTabCount )
		{ PROPmaskADD( &changedMask, PPpropTAB_STOPS );	}
	    else{
		TabStop *			ts1= pp1->ppTabStops;
		TabStop *			ts2= pp2->ppTabStops;
		int				tab;

		for ( tab= 0; tab < pp2->ppTabCount; tab++ )
		    {
		    if  ( ts1[tab].tsTwips != ts2[tab].tsTwips		||
			  ts1[tab].tsKind != ts2[tab].tsKind		||
			  ts1[tab].tsLeader != ts2[tab].tsLeader	)
			{ PROPmaskADD( &changedMask, PPpropTAB_STOPS ); }
		    }
		}
	    }
	}

    if  ( PROPmaskISSET( updMask, PPpropNEWPAGE ) )
	{
	if  ( pp1->ppStartsOnNewPage != pp2->ppStartsOnNewPage )
	    { PROPmaskADD( &changedMask, PPpropNEWPAGE ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropWIDCTLPAR ) )
	{
	if  ( pp1->ppWidowControl != pp2->ppWidowControl )
	    { PROPmaskADD( &changedMask, PPpropWIDCTLPAR ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropKEEPN ) )
	{
	if  ( pp1->ppKeepWithNext != pp2->ppKeepWithNext )
	    { PROPmaskADD( &changedMask, PPpropKEEPN ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropKEEP ) )
	{
	if  ( pp1->ppKeepOnPage != pp2->ppKeepOnPage )
	    { PROPmaskADD( &changedMask, PPpropKEEP ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropSPACE_BEFORE ) )
	{
	if  ( pp1->ppSpaceBeforeTwips != pp2->ppSpaceBeforeTwips )
	    { PROPmaskADD( &changedMask, PPpropSPACE_BEFORE ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropSPACE_AFTER ) )
	{
	if  ( pp1->ppSpaceAfterTwips != pp2->ppSpaceAfterTwips )
	    { PROPmaskADD( &changedMask, PPpropSPACE_AFTER ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropLINE_SPACING_DIST ) )
	{
	if  ( pp1->ppLineSpacingTwips != pp2->ppLineSpacingTwips )
	    { PROPmaskADD( &changedMask, PPpropLINE_SPACING_DIST ); }
	}
    if  ( PROPmaskISSET( updMask, PPpropLINE_SPACING_MULT ) )
	{
	if  ( pp1->ppLineSpacingIsMultiple != pp2->ppLineSpacingIsMultiple )
	    { PROPmaskADD( &changedMask, PPpropLINE_SPACING_MULT ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropTOP_BORDER ) )
	{
	if  ( docBorderPropertyDifference( &(pp1->ppTopBorder),
					&(pp2->ppTopBorder ), BRDRupdALL ) )
	    { PROPmaskADD( &changedMask, PPpropTOP_BORDER ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropBOTTOM_BORDER ) )
	{
	if  ( docBorderPropertyDifference( &(pp1->ppBottomBorder),
					&(pp2->ppBottomBorder ), BRDRupdALL ) )
	    { PROPmaskADD( &changedMask, PPpropBOTTOM_BORDER ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropOUTLINELEVEL ) )
	{
	if  ( pp1->ppOutlineLevel != pp2->ppOutlineLevel )
	    { PROPmaskADD( &changedMask, PPpropOUTLINELEVEL );	}
	}

    if  ( PROPmaskISSET( updMask, PPpropHYPHPAR ) )
	{
	if  ( pp1->ppHyphenateParagraph != pp2->ppHyphenateParagraph )
	    { PROPmaskADD( &changedMask, PPpropHYPHPAR ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropSHADING_LEVEL ) )
	{
	if  ( pp1->ppShadingLevel != pp2->ppShadingLevel )
	    { PROPmaskADD( &changedMask, PPpropSHADING_LEVEL ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropSHADING_PATTERN ) )
	{
	if  ( pp1->ppShadingPattern != pp2->ppShadingPattern )
	    { PROPmaskADD( &changedMask, PPpropSHADING_PATTERN ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropSHADING_FOREGROUND ) )
	{
	if  ( pp1->ppShadingForeground != pp2->ppShadingForeground )
	    { PROPmaskADD( &changedMask, PPpropSHADING_FOREGROUND ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropSHADING_BACKGROUND ) )
	{
	if  ( pp1->ppShadingBackground != pp2->ppShadingBackground )
	    { PROPmaskADD( &changedMask, PPpropSHADING_BACKGROUND ); }
	}

    return changedMask;
    }

