/************************************************************************/
/*									*/
/*  Evaluate an 'IncludePicture' field.					*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<sioStdio.h>
#   include	<sioMemory.h>
#   include	<sioHex.h>

#   include	<appUnit.h>
#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  Save an included file to a memory buffer and determine its type and	*/
/*  bounding box on the fly.						*/
/*									*/
/*  (Only EPS is supported now)						*/
/*									*/
/************************************************************************/

static int docCollectIncludedFile(	const char *		fullName,
					InsertedObject *	io )
    {
    int				gotBBox= 0;
    int				gotEpsHeader= 0;

    char			line[512+2];

    SimpleInputStream *		sisIn= (SimpleInputStream *)0;
    SimpleOutputStream *	sosBuffer= (SimpleOutputStream *)0;
    SimpleOutputStream *	sosHex= (SimpleOutputStream *)0;

    int				n;

    int				llx= 0, lly= 0, urx= 0, ury= 0;
    int				i1, i2, i3, i4;

    sisIn= sioInStdioOpen( fullName );
    if  ( ! sisIn )
	{ SXDEB(fullName,sisIn); return -1;	}

    if  ( ! sioInGetString( line, 512+1, sisIn ) )
	{ LDEB(512); sioInClose( sisIn ); return -1; }

    n= sscanf( line, "%%!PS-Adobe-%d.%d EPSF-%d.%d", &i1, &i2, &i3, &i4 );
    if  ( n == 4 )
	{ gotEpsHeader= 1;	}
    else{ SDEB(line);		}

    sosBuffer= sioOutMemoryOpen( &(io->ioResultData) );
    if  ( ! sosBuffer )
	{ XDEB(sosBuffer); sioInClose( sisIn ); return -1;	}
    sosHex= sioOutHexOpen( sosBuffer );
    if  ( ! sosHex )
	{ XDEB(sosHex); sioInClose( sisIn ); return -1;		}

    sioOutPutString( line, sosHex );

    while( ! strchr( line, '\n' ) )
	{
	if  ( ! sioInGetString( line, 512+1, sisIn ) )
	    { break;	}

	sioOutPutString( line, sosHex );
	}

    while( sioInGetString( line, 512+1, sisIn ) )
	{
	sioOutPutString( line, sosHex );

	if  ( ! gotBBox )
	    {
	    n= sscanf( line, "%%%%BoundingBox: %d %d %d %d",
							&i1, &i2, &i3, &i4 );
	    if  ( n == 4 )
		{ llx= i1; lly= i2; urx= i3; ury= i4; gotBBox= 1; }
	    }

	while( ! strchr( line, '\n' ) )
	    {
	    if  ( ! sioInGetString( line, 512+1, sisIn ) )
		{ break;	}

	    sioOutPutString( line, sosHex );
	    }
	}

    sioOutClose( sosHex );
    sioOutClose( sosBuffer );
    sioInClose( sisIn );

    if  ( gotEpsHeader && gotBBox )
	{
	io->ioResultKind= DOCokEPSF;

	if  ( llx < 0 )
	    { io->ioTwipsWide= 20* ( urx- llx );	}
	else{ io->ioTwipsWide= 20* ( urx );		}

	if  ( lly < 0 )
	    { io->ioTwipsHigh= 20* ( ury- lly );	}
	else{ io->ioTwipsHigh= 20* ( ury );		}
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Evaluate an 'INCLUDEPICTURE' field.					*/
/*									*/
/************************************************************************/

int docRecalculateIncludePictureField(
				int *				pCalculated,
				BufferDocument *		bd,
				int *				pPartShift,
				int *				pStroffShift,
				BufferItem *			bi,
				int				part,
				int				partCount,
				DocumentField *			df,
				void *				voidadd,
				DOC_CLOSE_OBJECT		closeObject )
    {
    const DocumentProperties *		dp= &(bd->bdProperties);
    int					i;

    TextParticule *			tp;

    InsertedObject *			io;
    int					objectNumber;

    int					oldPartCount= bi->biParaParticuleCount;
    int					oldStrlen= bi->biParaStrlen;
    int					stroff;

    int					stroffShift= 0;

    const char *			fileName;
    int					fileSize;
    char *				slash= (char *)0;

    char *				fullName= (char *)0;

    tp= bi->biParaParticules+ part+ 1;

    if  ( partCount == 1		&&
	  tp->tpKind == DOCkindOBJECT	)
	{
	io= bi->biParaObjects+ tp->tpObjectNumber;

	if  ( io->ioKind == DOCokINCLUDEPICTURE )
	    {
	    *pCalculated= 0;
	    *pPartShift= 0;
	    *pStroffShift= 0;
	    return 0;
	    }
	}

    if  ( docFieldGetIncludePicture( df, &fileName, &fileSize ) )
	{ LDEB(1); return -1;	}

    if  ( fileSize < 1 )
	{
	LDEB(fileSize);
	*pPartShift= 0;
	*pStroffShift= 0;
	return 0;
	}

    if  ( fileName[0] != '/' && dp->dpFilename )
	{ slash= strrchr( (char *)dp->dpFilename, '/' );	}

    if  ( fileName[0] == '/' || ! slash )
	{
	fullName= malloc( fileSize+ 1 );
	if  ( ! fullName )
	    { XDEB(fullName); return -1;	}

	strncpy( fullName, fileName, fileSize )[fileSize]= '\0';
	i= fileSize;
	}
    else{
	int		pathSize= slash- (char *)dp->dpFilename+ 1;

	i= pathSize+ fileSize;

	fullName= malloc( i+ 1 );
	if  ( ! fullName )
	    { XDEB(fullName); return -1;	}

	memcpy( fullName, dp->dpFilename, pathSize );
	memcpy( fullName+ pathSize, fileName, fileSize );
	fullName[i]= '\0';
	}

    io= docClaimObject( &objectNumber, bi );
    if  ( ! io )
	{ XDEB(io); free( fullName ); return -1;	}
    
    if  ( docObjectSetData( io, (unsigned char *)fullName, i+ 1 ) )
	{ free( fullName ); return -1;	}
    io->ioKind= DOCokINCLUDEPICTURE;

    stroff= tp->tpStroff;

    if  ( partCount > 0 )
	{
	int	stroffShift= 0;

	tp= bi->biParaParticules+ part+ 1;
	for ( i= 0; i < partCount; tp++, i++ )
	    {
	    (*closeObject)( bd, bi, tp, voidadd );
	    docCleanParticuleObject( bi, tp );
	    }

	docDeleteParticules( bi, part+ 1, partCount );

	if  ( docParaStringReplace( &stroffShift, bi, tp->tpStroff,
						tp[partCount-1].tpStroff+
						tp[partCount-1].tpStrlen,
						(unsigned char *)" ", 1 ) )
	    { LDEB(0); free( fullName ); return -1;	}
	}
    else{
	tp= bi->biParaParticules+ part;

	if  ( docParaStringReplace( &stroffShift, bi,
						tp->tpStroff+ tp->tpStrlen,
						tp->tpStroff+ tp->tpStrlen,
						(unsigned char *)" ", 1 ) )
	    { LDEB(0); free( fullName ); return -1;	}
	}

    tp= docCopyParticule( bi, part+ 1,
				tp->tpStroff+ tp->tpStrlen, 1,
				DOCkindOBJECT, bi->biParaParticules+ part );
    if  ( ! tp )
	{ XDEB(tp); free( fullName ); return -1;	}

    tp->tpObjectNumber= bi->biParaObjectCount++;

    if  ( docCollectIncludedFile( fullName, io ) )
	{ SDEB(fullName);	}

    free( fullName );

    *pCalculated= 1;
    *pPartShift= bi->biParaParticuleCount- oldPartCount;
    *pStroffShift= bi->biParaStrlen- oldStrlen;
    return 0;
    }

