/************************************************************************/
/*  Definitions for spelling checking.					*/
/************************************************************************/

#   ifndef	DOC_FIND_H
#   define	DOC_FIND_H

#   include	"docBuf.h"
#   include	<reg.h>


typedef int (*PARA_FIND_STRING)(
			    const BufferItem *		paraBi,
			    int				stroff,
			    int *			pStart,
			    int *			pLength,
			    void *			through );

/************************************************************************/
/*  Routine declarations.						*/
/************************************************************************/

extern int docFindParaFindNext(	const BufferItem *	paraBi,
				int			stroff,
				int *			pStart,
				int *			pLength,
				void *			through );

extern int docFindParaFindPrev(	const BufferItem *	paraBi,
				int			stroff,
				int *			pStart,
				int *			pLength,
				void *			through );

extern int docSpellParaFindNext( const BufferItem *	paraBi,
				int			stroff,
				int *			pStart,
				int *			pLength,
				void *			through );

extern int docFindFindNextInTree( BufferSelection *	bs,
				const BufferPosition *	bpFrom,
				BufferItem *		biRoot,
				PARA_FIND_STRING	findNext,
				void *			through );

extern int docFindFindPrevInTree( BufferSelection *	bs,
				const BufferPosition *	bpFrom,
				BufferItem *		biRoot,
				PARA_FIND_STRING	findPrev,
				void *			through );

extern int docFindFindNextInDocument(
				BufferSelection *	bs,
				SelectionScope *	ss,
				const BufferPosition *	bpFrom,
				BufferDocument *	bd,
				PARA_FIND_STRING	findNext,
				void *			through );

extern int docFindFindPrevInDocument(
				BufferSelection *	bs,
				SelectionScope *	ss,
				const BufferPosition *	bpFrom,
				BufferDocument *	bd,
				PARA_FIND_STRING	findPrev,
				void *			through );

#   endif
