#   include	"config.h"

#   include	"docBuf.h"
#   include	<stdio.h>
#   include	<appDebugon.h>

#   define	LIST_PARTICULES		0
#   define	LIST_FIRST_LINE		0
#   define	LIST_LINES		1
#   define	LIST_LINE_PARTICULES	0

static void docCheckChild(	const BufferItem *	parent,
				const BufferItem *	child,
				int			i,
				const LayoutPosition *	lpTop,
				LayoutPosition *	lpBelow )
    {
    if  ( child->biTopPosition.lpPage != lpTop->lpPage			||
	  child->biTopPosition.lpPageYTwips != lpTop->lpPageYTwips	)
	{
	appDebug( "############## %s %d in %s:\n",
				    docLevelStr(child->biLevel), i,
				    docLevelStr(parent->biLevel) );
	LLDEB(child->biTopPosition.lpPage,lpTop->lpPage);
	LLDEB(child->biTopPosition.lpPageYTwips,lpTop->lpPageYTwips);
	}

    if  ( child->biParent != parent )
	{
	appDebug( "############## %s %d in %s:\n",
				    docLevelStr(child->biLevel), i,
				    docLevelStr(parent->biLevel) );
	XXDEB(child->biParent,parent);
	}

    if  ( child->biNumberInParent != i )
	{
	appDebug( "############## %s %d in %s:\n",
				    docLevelStr(child->biLevel), i,
				    docLevelStr(parent->biLevel) );
	LLDEB(child->biNumberInParent,i);
	}

    if  ( child->biLevel != parent->biLevel+ 1 )
	{
	appDebug( "############## %s %d in %s:\n",
				    docLevelStr(child->biLevel), i,
				    docLevelStr(parent->biLevel) );
	LLDEB(child->biLevel,parent->biLevel);
	}

    *lpBelow= child->biBelowPosition;
    }

static void docListChildren(	int			indent,
				const BufferItem *	bi )
    {
    int			i;

    LayoutPosition	lp;

    lp= bi->biTopPosition;

    for ( i= 0; i < bi->biChildCount; i++ )
	{
	docCheckChild( bi, bi->biChildren[i], i, &lp, &lp );

	docListItem( indent+ 4, bi->biChildren[i] );
	}

    if  ( bi->biBelowPosition.lpPage != lp.lpPage		||
	  bi->biBelowPosition.lpPageYTwips != lp.lpPageYTwips	)
	{
	appDebug( "############## %s :\n", docLevelStr(bi->biLevel) );

	LLDEB(bi->biBelowPosition.lpPage,lp.lpPage);
	LLDEB(bi->biBelowPosition.lpPageYTwips,lp.lpPageYTwips);
	}

    }

void docListItem(	int			indent,
			const BufferItem *	bi )
    {
#   if LIST_PARTICULES || LIST_LINES
    int			i;
#   endif

#   if LIST_PARTICULES
    TextParticule *	tp;
#   endif

#   if LIST_LINES
    TextLine *		tl;
#   endif

    appDebug( "%*sITEM %4d 0x%08lx: %s\n",
			    indent, "", bi->biNumberInParent,
			    (unsigned long)bi,
			    docLevelStr( bi->biLevel ) );
    switch( bi->biLevel )
	{
	case DOClevDOC:
	case DOClevSECT:
	case DOClevCELL:
	    appDebug( "%*s{ %4d children\n", indent+ 4, "",
						bi->biChildCount );

	    docListChildren( indent, bi );

	    break;

	case DOClevROW:
	    appDebug( "%*s{ %4d children %d cells\n", indent+ 4, "",
						bi->biChildCount,
						bi->biRowCellCount );

	    docListChildren( indent, bi );

	    break;

	case DOClevPARA:
	    appDebug( "%*s{ %4d particules, %4d lines\n", indent+ 4, "",
						bi->biParaParticuleCount,
						bi->biParaLineCount );

#	    if LIST_PARTICULES
	    tp= bi->biParaParticules;
	    for ( i= 0; i < bi->biParaParticuleCount; tp++, i++ )
		{ docListParticule( indent+ 4, "PART", i, bi, tp );	}
#	    endif

#	    if LIST_LINES
	    tl= bi->biParaLines;
	    for ( i= 0; i < bi->biParaLineCount; tl++, i++ )
		{ docListTextLine( indent+ 4, "LINE", i, bi, tl );	}
#	    endif

#	    if LIST_FIRST_LINE
	    docListTextLine( indent+ 4, "LINE", 0, bi, bi->biParaLines );
#	    endif

	    break;
	case DOClevOUT:
	default:
	    break;
	}

    appDebug( "%*s}\n", indent+ 4, "" );
    
    return;
    }

const char * docKindStr( int kind )
    {
    static char	scratch[12];

    switch( kind )
	{
	case DOCkindTEXT:	return "txt";
	case DOCkindTAB:	return "TAB";
	case DOCkindOBJECT:	return "OBJ";
	case DOCkindFIELDSTART:	return "FLS";
	case DOCkindFIELDEND:	return "FLE";
	case DOCkindXE:		return "XE ";
	case DOCkindTC:		return "TC ";
	case DOCkindLINEBREAK:	return "LIN";
	case DOCkindPAGEBREAK:	return "PAG";
	default:
	    sprintf( scratch, "%03d", kind );
	    return scratch;
	}
    }

const char * docLevelStr( int level )
    {
    static char	scratch[12];

    switch( level )
	{
	case DOClevANY:		return "ANY ";
	case DOClevOUT:		return "OUT ";
	case DOClevDOC:		return "DOC ";
	case DOClevSECT:	return "SECT";
	case DOClevROW:		return "ROW ";
	case DOClevCELL:	return "CELL";
	case DOClevPARA:	return "PARA";
	case DOClevTEXT:	return "TEXT";
	default:
	    sprintf( scratch, "%04d", level );
	    return scratch;
	}
    }

const char * docExternalKindStr( int inHeaderFooter )
    {
    static char	scratch[12];

    switch( inHeaderFooter )
	{
	case DOCinBODY:			return "BODY";

	case DOCinSECT_HEADER:		return "SECT_HEADER";
	case DOCinFIRST_HEADER:		return "FIRST_HEADER";
	case DOCinLEFT_HEADER:		return "LEFT_HEADER";
	case DOCinRIGHT_HEADER:		return "RIGHT_HEADER";

	case DOCinSECT_FOOTER:		return "SECT_FOOTER";
	case DOCinFIRST_FOOTER:		return "FIRST_FOOTER";
	case DOCinLEFT_FOOTER:		return "LEFT_FOOTER";
	case DOCinRIGHT_FOOTER:		return "RIGHT_FOOTER";

	default:
	    sprintf( scratch, "%d", inHeaderFooter );
	    return scratch;
	}
    }

const char * docFieldKindStr( int kind )
    {
    static char	scratch[12];

    if  ( kind >= 0 && kind < DOC_FieldKindCount )
	{ return DOC_FieldKinds[kind].fkiLabel;	}

    sprintf( scratch, "%4d", kind );
    return scratch;
    }

const char * docAttributeStr(	TextAttribute		ta )
    {
    static char	scratch[5];
    char *	to= scratch;

    if  ( ta.taFontIsBold )
	{ *(to++)= 'B';	}
    else{ *(to++)= 'b';	}
    if  ( ta.taFontIsSlanted )
	{ *(to++)= 'I';	}
    else{ *(to++)= 'i';	}
    if  ( ta.taIsUnderlined )
	{ *(to++)= 'U';	}
    else{ *(to++)= 'u';	}
    if  ( ta.taShowAsLink )
	{ *(to++)= 'L';	}
    else{ *(to++)= 'l';	}

    *(to)= '\0';

    return scratch;
    }

void docListParticule(	int			indent,
			const char *		label,
			int			n,
			const BufferItem *	bi,
			const TextParticule *	tp )
    {
    appDebug( "%*s%s %3d: [%4d..%4d] [%3d..%3d] %s <%s> ", indent, "", label, n,
		    tp->tpStroff, tp->tpStroff+ tp->tpStrlen,
		    tp->tpX0, tp->tpX0+ tp->tpPixelsWide,
		    docKindStr( tp->tpKind ),
		    docAttributeStr( tp->tpTextAttribute ) );

    appDebug( "\"%.*s\"\n",
		    (int)tp->tpStrlen,
		    bi->biParaString+ tp->tpStroff );

    return;
    }

void docListTextLine(	int			indent,
			const char *		label,
			int			n,
			const BufferItem *	bi,
			const TextLine *	tl )
    {
#   if LIST_LINE_PARTICULES
    TextParticule *	tp;
    int			part;
#   endif

    if  ( ! tl )
	{ LDEB(tl); return;	}

    appDebug( "%*s%s %3d: PG= %3d S:[%4d..%4d] P:[%3d..%3d] ",
	    indent, "", label, n,
	    tl->tlTopPosition.lpPage,
	    tl->tlStroff, tl->tlStroff+ tl->tlStrlen,
	    tl->tlFirstParticule, tl->tlFirstParticule+ tl->tlParticuleCount );

    appDebug( "\"%.*s\"\n",
		    (int)tl->tlStrlen,
		    bi->biParaString+ tl->tlStroff );

#   if LIST_LINE_PARTICULES

    tp= bi->biParaParticules+ tl->tlFirstParticule;
    for ( part= tl->tlFirstParticule;
          part < tl->tlFirstParticule+ tl->tlParticuleCount;
	  tp++, part++ )
	{ docListParticule( indent+ 4, "PART", part, bi, tp ); }

#   endif

    return;
    }

void docLogRectangle(	const char *			label,
			const DocumentRectangle *	dr )
    {
    appDebug( "%s: [%4d+%4d]x[%4d+%4d=%4d]\n", label,
		dr->drX0, dr->drX1- dr->drX0+ 1,
		dr->drY0, dr->drY1- dr->drY0+ 1, dr->drY1 );

    return;
    }

void docLogRectangles(	const char *			label1,
			const DocumentRectangle *	dr1,
			const char *			label2,
			const DocumentRectangle *	dr2 )
    {
    appDebug( "%s: [%4d+%4d]x[%4d+%4d] %s [%4d+%4d]x[%4d+%4d]\n",
		label1,
		dr1->drX0, dr1->drX1- dr1->drX0+ 1,
		dr1->drY0, dr1->drY1- dr1->drY0+ 1,
		label2,
		dr2->drX0, dr2->drX1- dr2->drX0+ 1,
		dr2->drY0, dr2->drY1- dr2->drY0+ 1 );

    return;
    }
