/************************************************************************/
/*									*/
/*  Border properties.							*/
/*									*/
/************************************************************************/

#   ifndef	DOC_BORDER_PROP_H
#   define	DOC_BORDER_PROP_H

#   include	"utilPropMask.h"
#   include	"docPropVal.h"

/************************************************************************/
/*									*/
/*  Border Styles: How they are drawn.					*/
/*									*/
/************************************************************************/

typedef enum BorderStyle
    {
    DOCbsNONE= 0,
    DOCbsS,
    DOCbsTH,
    DOCbsSH,

    DOCbsDB,
    DOCbsHAIR,
    DOCbsDOT,
    DOCbsDASH,
    DOCbsDASHD,
    DOCbsDASHDD,
    DOCbsTRIPLE,

    DOCbsTNTHSG,
    DOCbsTHTNSG,
    DOCbsTNTHTNSG,
    DOCbsTNTHMG,
    DOCbsTHTNMG,
    DOCbsTNTHTNMG,
    DOCbsTNTHLG,
    DOCbsTHTNLG,
    DOCbsTNTHTNLG,

    DOCbsWAVY,
    DOCbsWAVYDB,
    DOCbsDASHSM,
    DOCbsDASHDOTSTR,
    DOCbsEMBOSS,
    DOCbsENGRAVE,

    DOCbs_COUNT
    } BorderStyle;

typedef struct BorderProperties
    {
    unsigned int	bpColor:8;
    unsigned int	bpSpacingTwips:16;
    unsigned int	bpPenWideTwips:8;
    unsigned int	bpStyle:5;		/*  (enum)	*/
    } BorderProperties;

typedef enum BorderProperty
    {
    BRDRprop_NONE= -1,

    BRDRpropCOLOR= 0,
    BRDRpropSPACING,
    BRDRpropPEN_WIDE,
    BRDRpropSTYLE,

    BRDRprop_COUNT
    } BorderProperty;

#   define	BRDRupdALL	((1<<BRDRpropCOLOR)	|\
				 (1<<BRDRpropSPACING)	|\
				 (1<<BRDRpropPEN_WIDE)	|\
				 (1<<BRDRpropSTYLE)	)

#   define	docCopyBorderProperties( bp1, bp2 ) *(bp1)= *(bp2)

/************************************************************************/
/*									*/
/*  Routine Declarations.						*/
/*									*/
/************************************************************************/

extern void docInitBorderProperties(	BorderProperties *	bp );

extern unsigned int docBorderPropertyDifference(
				    const BorderProperties *	bp1,
				    const BorderProperties *	bp2,
				    unsigned int		bpUpdMask );

#   endif	/*  DOC_BORDER_PROP_H  */
