/************************************************************************/
/*									*/
/*  Management of Border Properties.					*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBorderProperties.h"

/************************************************************************/
/*									*/
/*  Initialise Border Properties.					*/
/*									*/
/************************************************************************/

void docInitBorderProperties(	BorderProperties *	bp )
    {
    bp->bpColor= 0;
    bp->bpSpacingTwips= 0;
    bp->bpPenWideTwips= 15;
    bp->bpStyle= DOCbsNONE;
    }

/************************************************************************/
/*									*/
/*  1) Are the columns in two RowProperties 'the same' (Do they align?)	*/
/*  2) All column properties identical?					*/
/*									*/
/************************************************************************/

unsigned int docBorderPropertyDifference(
				    const BorderProperties *	bp1,
				    const BorderProperties *	bp2,
				    unsigned int		bpUpdMask )
    {
    unsigned int		bpChgMask;

    PROPmaskCLEAR( &bpChgMask );

    if  ( PROPmaskISSET( bpUpdMask, BRDRpropCOLOR ) )
	{
	if  ( bp1->bpColor != bp2->bpColor )
	    { PROPmaskADD( &bpChgMask, BRDRpropCOLOR ); }
	}

    if  ( PROPmaskISSET( bpUpdMask, BRDRpropSPACING ) )
	{
	if  ( bp1->bpSpacingTwips != bp2->bpSpacingTwips )
	    { PROPmaskADD( &bpChgMask, BRDRpropSPACING ); }
	}

    if  ( PROPmaskISSET( bpUpdMask, BRDRpropPEN_WIDE ) )
	{
	if  ( bp1->bpPenWideTwips != bp2->bpPenWideTwips )
	    { PROPmaskADD( &bpChgMask, BRDRpropPEN_WIDE ); }
	}

    if  ( PROPmaskISSET( bpUpdMask, BRDRpropSTYLE ) )
	{
	if  ( bp1->bpStyle != bp2->bpStyle )
	    { PROPmaskADD( &bpChgMask, BRDRpropSTYLE ); }
	}

    return bpChgMask;
    }
