/*
 * tcpreen.h - header for tcpreen.c
 */

/**********************************************************************
 *  Copyright (C) 2002 Rmi Denis-Courmont.                           *
 *  This program is free software; you can redistribute and/or modify *
 *  it under the terms of the GNU General Public License as published *
 *  by the Free Software Foundation; version 2 of the license.        *
 *                                                                    *
 *  This program is distributed in the hope that it will be useful,   *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.              *
 *  See the GNU General Public License for more details.              *
 *                                                                    *
 *  You should have received a copy of the GNU General Pulic License  *
 *  along with this program; if not, you can get it from:             *
 *  http://www.gnu.org/copyleft/gpl.html                              *
 *                                                                    *
 *  You are highly encouraged to submit your modifications to         *
 *  remi@simphalempin.com for possible inclusion in the official      *
 *  distribution. By doing so, and unless otherwise stated, you give  *
 *  Rmi Denis-Courmont an unlimited, non-exclusive right to modify,  *
 *  reuse and/or relicense the code.                                  *
 **********************************************************************/

#ifndef __RDC_TCPREEN_H

# define __RDC_TCPREEN_H
# ifdef HAVE_CONFIG_H
#  include <config.h>
# endif
# ifdef HAVE_SYS_TYPES_H
#  include <sys/types.h> /* uid_t */
# endif

# include "log.h"
# include "socketinfo.h"

enum {
	tcpreen_normal=0x00,
	tcpreen_listen_both=0x01,
	tcpreen_connect_both=0x02,
	tcpreen_reversed=0x03, /* warning */
	tcpreen_numeric=0x04,
	tcpreen_syslog=0x08
};

struct bridgeconf {
	struct sockhostinfo server, bridge;
	struct logfile *logs;
	int mode, maxclients;
	long bytelimit, totalclients;
	uid_t priv, unpriv;
};

# ifdef __cplusplus
extern "C" {
#endif

int bridge_main(const struct bridgeconf *conf);

# ifdef __cplusplus
}
# endif
#endif

