/*
 * solve.h - header for solve.c, addresses family-independant resolution
 * functions.
 */

/**********************************************************************
 *  Copyright (C) 2002 Rmi Denis-Courmont.                           *
 *  This program is free software; you can redistribute and/or modify *
 *  it under the terms of the GNU General Public License as published *
 *  by the Free Software Foundation; version 2 of the license.        *
 *                                                                    *
 *  This program is distributed in the hope that it will be useful,   *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.              *
 *  See the GNU General Public License for more details.              *
 *                                                                    *
 *  You should have received a copy of the GNU General Pulic License  *
 *  along with this program; if not, you can get it from:             *
 *  http://www.gnu.org/copyleft/gpl.html                              *
 *                                                                    *
 *  You are highly encouraged to submit your modifications to         *
 *  remi@simphalempin.com for possible inclusion in the official      *
 *  distribution. By doing so, and unless otherwise stated, you give  *
 *  Rmi Denis-Courmont an unlimited, non-exclusive right to modify,  *
 *  reuse and/or relicense the code.                                  *
 **********************************************************************/

#ifndef __RDC_SOLVE_H

# define __RDC_SOLVE_H
# ifdef HAVE_CONFIG_H
#  include <config.h>
# endif
# include <stddef.h> /* size_t */
# ifdef HAVE_SYS_TYPES_H
#  include <sys/types.h> /* might be needed for sys/socket.h */
#endif
# ifdef HAVE_SYS_SOCKET_H
#  include <sys/socket.h> /* might be needed for struct sockaddr */
# endif
# ifdef HAVE_NETDB_H
#  include <netdb.h>
# endif

# ifdef __cplusplus
extern "C" {
#endif

#define NI_MAXADDRESS NI_MAXHOST + NI_MAXSERV + 2

int secure_getnameinfo(struct sockaddr *addr, size_t addrlen,
	char *nodename, size_t nlen, char *service, size_t slen, int flags);
int getsockaddr(int fd, int flags, int peer, char *buf, size_t len);
int parse_host(const char *host, char *nodename, char *service);

# ifdef __cplusplus
}
# endif
#endif

