[comment {-*- tcl -*- doctools manpage}]
[manpage_begin tar n 0.4]
[moddesc   {Tar file handling}]
[titledesc {Tar file creation, extraction & manipulation}]
[require Tcl 8.4]
[require tar [opt 0.4]]
[description]


[para]

[list_begin definitions]

[call [cmd ::tar::contents] [arg tarball]]

Returns a list of the files contained in [arg tarball].
[para]

[call [cmd ::tar::stat] [arg tarball] [opt file]]

Returns a nested dict containing information on the named [opt file] in [arg tarball],
or all files. the top level are pairs of filename and info. The info is a dict in the form
mode uid gid size mtime type linkname uname gname devmajor devminor

[example {
% ::tar::stat tarball.tar
foo.jpg {mode 0644 uid 1000 gid 0 size 7580 mtime 811903867 type file linkname {} uname user gname wheel devmajor 0 devminor 0}
}]


[call [cmd ::tar::untar] [arg tarball] [arg args]]

Extracts [arg tarball]. [arg -file] and [arg -glob] limit the extraction
to files which exactly match or pattern match the given argument. No error is
thrown if no files match. Returns a list of filenames extracted and the file
size. The size will be null for non regular files.

[list_begin options]
[opt_def -dir dirName]
[opt_def -file fileName]
[opt_def -glob pattern]
[opt_def -nooverwrite]
[opt_def -nomtime]
[opt_def -noperms]
[list_end]
[para]

[example {
% foreach {file size} [::tar::untar tarball.tar -glob *.jpg] {
puts "Extracted $file ($size bytes)"
}
}]

[call [cmd ::tar::get] [arg tarball] [arg fileName]]

Returns the contents of [arg fileName] from the [arg tarball]
[para]

[call [cmd ::tar::create] [arg tarball] [arg files] [arg args]]

Creates a new tar file containing the [arg files]. [arg files] must be specified
as a single argument which is a proper list of filenames.

[list_begin options]
[opt_def -dereference]
[list_end]
[para]

[call [cmd ::tar::add] [arg tarball] [arg files] [arg args]]

Appends [arg files] to the end of the existing [arg tarball]. [arg files] must be specified
as a single argument which is a proper list of filenames.

[list_begin options]
[opt_def -dereference]
[list_end]
[para]

[call [cmd ::tar::remove] [arg tarball] [arg files]]

Removes [arg files] from the [arg tarball]

[list_end]


[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph tar] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.


[keywords tar {tape archive} archive]
[manpage_end]
