/***************************************************************************
                          timer.cpp  -  description
                             -------------------
    begin                : Fre Mai 17 2002
    copyright            : (C) 2002 by Thomas Friedrichsmeier
    email                : tfry@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "timer.h"

#include <qstring.h>

#include "level.h"
#include "cdp.h"
#include "state.h"
#include "taxipilot.h"

Timer::Timer(const QDomElement *description, Level *parent) : Event (description, parent) {
	tm = level->tp->tm;
	timer_id = -1;
}

Timer::~Timer(){
}

/** Reads in the description for this timer */
void Timer::read_timer (const QDomElement *description) {
       QString dummy;
	
	if ((dummy = cdp->get_string_attribute ("loop_state", *description, "NOTHING", 3)) == "NOTHING") {
		loop_state = 0;
	} else {
		loop_state = level->resolve_state (dummy);
	}

	timer_period = cdp->get_int_attribute ("period", *description, 10, 10000, 500, 1);

	trigger_resets = trigger_stops = false;
	dummy = cdp->get_multi_choice_attribute("triggered_while_active", *description, "restart;stop;ignore", "ignore", 3);
	if (dummy == "restart") {
		trigger_resets = true;
	} else if (dummy == "stop") {
		trigger_stops = true;
	}

	trigger_initially = cdp->get_bool_attribute("trigger_initially", *description, false, 3);
}

/** Sets off timer activity */
void Timer::trigger () {

	if (timer_id == -1) {
		timer_id = tm->startTimer (this, timer_period);
	} else if (trigger_resets) {
		tm->killTimer (timer_id);
		timer_id = tm->startTimer (this, timer_period);		
	} else if (trigger_stops) {
		tm->killTimer (timer_id);
		timer_id = -1;
	}

}

/** Called when the countdown is reached */
void Timer::timerTick (int id) {

	Event::trigger ();

	if (!loop_state) {               		// stop the timer if not looping
		tm->killTimer (timer_id);
		timer_id = -1;
	} else if (!loop_state->isSet ()) {
		tm->killTimer (timer_id);
		timer_id = -1;
	}

}
