/***************************************************************************
                          timedobject.h  -  description
                             -------------------
    begin                : Sun Dec 23 2001
    copyright            : (C) 2001, 2002 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TIMEDOBJECT_H
#define TIMEDOBJECT_H

#include "timemanager.h"

/**A TimedObject is an object that can be timed by the TimeManager-class.
It has a virtual function timerTick (int).
  *@author Thomas Friedrichsmeier
  */

class TimedObject {
public: 
	TimedObject();
	virtual ~TimedObject();
friend class TimeManager;
/** Should be pointed to the (global) time-manager */
	TimeManager *tm;
private: // Private methods
/** This function gets called by the TimeManager-class, whenever a timer-event occurs
for this object. The id-parameter allows a TimedObject to have several timers, that
can be identified by id. */
	virtual void timerTick (int id);
};

#endif
