/***************************************************************************
                          movingobject.h  -  description
                             -------------------
    begin                : Tue Oct 23 2001
    copyright            : (C) 2001, 2002 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MOVINGOBJECT_H
#define MOVINGOBJECT_H

#include <qcanvas.h>
#include <qobject.h>

#include "timedobject.h"

class Taxipilot;
class QDomElement;
class Cdp;
class Level;
class QString;
class Platform;
class Teleporter;
class Conditional;
class Event;

/**
  *@author Thomas Friedrichsmeier
  */

class MovingObject : public QCanvasSprite, public TimedObject  {
public:
	MovingObject(const QDomElement *description, Level *parent, QCanvas *canvas);
	~MovingObject();
/** Whether the object would currently be harmful upon collision with the taxi */
	bool harmful ();
  /** Returns the current y-Velocity of the object */
  double current_vy();
  /** Returns the current x-velocity of the platform */
  double current_vx ();
friend class Level;
friend class Taxipilot;
private:
/** The pointer to the common debugging and prefixing class */
	Cdp *cdp;
/** Pointer to the parent level */
	Level *level;
/** Whether an identification string has been given to this object */
	bool has_ident;
/** The identification string itself */
	QString ident;

/** This struct is for things like halting/freezing or jumping */
	struct Action {
	/** A pointer to the conditional that needs to be fulfilled */
		Conditional *conditional;
	/** What type of action-thing is this? */
		bool stop;
		bool freeze;
		bool trigger;
		bool jump;
		int jump_target;
		Event *event_to_trigger;
	/** Pointer to the next action thing, if there is more than one of them in a row */
		Action *next;
	};
/** Whether we're currently processing an action (i.e. waiting for it's condition to end) */
	bool processing_action;
	bool actions_done;	

/** This struct holds all we need to know about where the object is going and what it looks like */
	struct PathSegment {
	/** A pointer to the anim to be used on this segment of the path */
		QCanvasPixmapArray *anim;
	/** This is the number of frames in the animation */
		int frames;
	/** The (predetermined) number of steps in this path-segment */
		int steps;
	/** The starting-point coordinates for this segment */
		double start_x, start_y;
	/** The starting speed on this segment */
		double vx, vy;
	/** The starting acceleration on this segment */
		double ax, ay;
	/** The change of acceleration on this segment (constant) */
		double dax, day;
	/** The timer-period (msecs; inverse of framerate) on this segment of the path (for the animation only) */
		int timer_period;			
	/** The z-Position in this segment of the path */
		double z;
	/** is the object visible on this segment? */
		bool visible;
	/** a pointer to some action to be done after this segment is completed */
		Action *action;
	} *path;

/** The current frame in the current animation */
	int frame;
/** The current step in the current segment of the path */
	int step;
/** The current segment of the path */
	int current_segment;
/** The number of segments in the move-path */
	int segments;
/** is the object harmful when visible? */
	bool harmful_if_visible;
/** Whether the object is a teleporter */
	bool teleporter;
/** Pointer to that teleporter */
	Teleporter *teleporter_p;
/** Whether the object is a center of gravity */
	bool center;
/** Whether the object is a platform */
	bool platform;
/** Pointer to that platform */
	Platform *platform_p;
/** Whether the object has been visible on the last segment */
	bool last_visible;
/** Current velocity and acceleration of the object */
	double vx, vy, ax, ay;
/** timer-ids */
	int advance_timer;
	int animation_timer;

private:
/** This function reads a moving-object-description ( specs for the animations ) from a
QDomNode (of a level-description) read_object is only called by the constructor. */
	void read_object(const QDomElement *description);
/** Parses the element e for a description of font, color, text and returns a QCanvasPixmapArray
with 1 frame, containing the rendered text. */
	QCanvasPixmapArray * create_text_qcpma (const QDomElement & e);
/** Process a (chain of) actions (stop/freeze/jump) */
	void process_actions ();
	Action *current_action;
/** Does anything that needs to be done when first encountering the current_action. Returns
true, if the action is enduring until its condition fails, false, if we can proceed. */
	bool initialize_action ();

protected:					// Protected methods
/** Advancing and animating */
	void timerTick (int id);
};

#endif
