
/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Don Mai 17 20:03:43 CEST 2001
    copyright            : (C) 2001 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "defines.h"

#include KAPP
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kglobal.h>
#include KSTDDIRS

#include <qcstring.h>
#include "taxipilotapp.h"

static const char *description = I18N_NOOP("Taxipilot");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE


static KCmdLineOptions options[] = {
	{"debug-level <level>", I18N_NOOP("Verbosity of debugging messages (0-4)"), "2"},
	{"thorough_check", I18N_NOOP("Configuration files are checked thoroughly before actually needed (missions load slower)"), 0},
	{"highlight", I18N_NOOP("Useful for debugging level-development"), 0},
	{0, 0, 0}
};

int main(int argc, char *argv[])
{

	KAboutData aboutData("taxipilot", I18N_NOOP("Taxipilot"),
						 VERSION, description, KAboutData::License_GPL,
						 "(c) 2001, 2002, Thomas Friedrichsmeier", 0, 0, "Thomas.Friedrichsmeier@ruhr-uni-bochum.de");
	aboutData.addAuthor("Thomas Friedrichsmeier", 0, "Thomas.Friedrichsmeier@ruhr-uni-bochum.de");
	KCmdLineArgs::init(argc, argv, &aboutData);
	KCmdLineArgs::addCmdLineOptions(options);	// Add our own options.

	KApplication a;

	KGlobal::dirs()->addResourceType("game_data", KStandardDirs::kde_default("data") + "taxipilot/game_data/");

	TaxipilotApp *tapp = new TaxipilotApp();
	a.setMainWidget(tapp);
	tapp->show();

	return a.exec();
}
