/***************************************************************************
                          level.h  -  description
                             -------------------
    begin                : Mon May 21 2001
    copyright            : (C) 2001, 2002 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LEVEL_H
#define LEVEL_H

#include <qcanvas.h>
#include <qstring.h>
#include <qmap.h>

/**
  *@author Thomas Friedrichsmeier
  */

class Taxipilot;
class Cdp;
class MovingObject;
class CenterOfGravity;
class Platform;
class State;
class Event;
class HotArea;
class Timer;

class Level:public QCanvasSprite {
  public:
	Level(const QString & file, QCanvas * canvas, Taxipilot * parent);
	~Level();
  /** Add a directory prefix to a filename if appropriate (i.e. not an absolute path) */
	int num_platforms;
	/** The id of the most expensive fuel platform (-1 if no fuel available (should never happen!)) */
	int exp_fuel_platform;

friend class Teleporter;
friend class CenterOfGravity;
friend class Platform;
friend class Event;
friend class Timer;
friend class MovingObject;

/** The pointer to the common debugging and prefixing class */
	Cdp *cdp;

	Platform **platform;

	struct Promise {
/** identification string of the promise */
		QString ident;
/** Type of promise (0 is teleporter, 1 is platform, 2 is center of gravity) */		
		int type;
/** Pointer to teleporter (if any) */
		Teleporter *tp_point;
/** Pointer to platform (if any) */
		Platform *plat_point;		
/** Pointer to CoG (if any) */		
		CenterOfGravity *cog_point;
/** Pointer to Object */
		MovingObject *obj_point;
	} *promise_pointer;

/** Normalized base_gravity (not taking into account recalculation period) */
	double n_base_gravity;
/** Normalized horiz_gravity (not taking into account recalculation period) */
	double n_horiz_gravity;	

/** basic downwards gravity */
	double base_gravity;
/** horizontal "gravity" */
	double horiz_gravity;
/** Number of Centers of Gravity (grav_center) */
	int num_grav_centers;
/** Array of pointers to centers of gravity */
	CenterOfGravity **grav_center;

/** Number of moving objects */
	int num_objects;
/** Array of pointers to the moving objects */
	MovingObject **objects;

/** Number of teleporters. Should be at least 2, if any at all */
	int num_teleporters;
/** Array of pointers to the teleporters */
	Teleporter **teleporters;

/** Number of states */
	int num_states;
/** Number of events */
	int num_events;
/** Number of timers */
	int num_timers;
/** Number of hot-areas */
	int num_areas;
/** Array of pointers to the states */
	State **states;
/** Array of pointers to the events */
	Event **events;
/** Array of pointers to the timers */
	Timer **timers;
/** Array of pointers ot the hot-areas */
	HotArea **areas;

/** Initial position of the taxi */
	int initial_x, initial_y;
/** initial fare */
	double base_fare;
/** stepping of fare, i.e. fare per unit of consumed fuel */
	double fare_step;
/** range of initial tip, passengers will start with */
	double min_base_tip, max_base_tip;
/** Caption/Title of this level. Will be displayed in the Taxipilot-Titlebar or maybe elsewhere */
	QString caption;
/** author of this level */
	QString author;
/** Number of successful deliveries needed to complete this level (i.e. deliveries with the
tip-counter being non-negative)*/
	int deliveries_to_go;
/** Whether an extra ship will be awarded upon completion of this level */
	bool extra_life;

/** The following deal with oversize levels. */
/** visible width and height of an oversized level */
	int visible_width, visible_height;
/** margin (both x and y) before scrolling takes place */
	int margin;
/** initial offsets of an oversized level */
	int initial_offset_x, initial_offset_y;
/** maximum x and y offsets for oversized levels (these are derived from the level's size and the visible size) */
	int max_offset_x, max_offset_y;
/** Returns a pointer to the state identified with ident. Must never be called while not within read_level () ! */
  State * resolve_state (QString & ident);
/** Returns a pointer to the event identified with ident. Must never be called while not within read_level () ! */
	Event * resolve_event (QString & ident);
  /** No descriptions */
  void config_changed();
  private:						// Private methods
/** I consider this function to be mostly straight-forward. I do however know close to nothing about XML
(definitely no more than was neccessary to write up this code. Go ahead and change it to make more sense! */
	void read_level(const QString & file);
/** the background for this level */
	QCanvasPixmap *background;
/** the actual image of the level */
	QCanvasPixmapArray *image;
/** Pointer to parent */
	Taxipilot *tp;
/** Pointer to canvas */
	QCanvas *p_canvas;
/** option highlight_platforms */
	bool draw_platform_lines;
/** A map of all the States */
	QMap <QString, State*> state_map;
/** A map of all the Events */
	QMap <QString, Event*> event_map;
};

#endif
