/***************************************************************************
                          hotarea.h  -  description
                             -------------------
    begin                : Wed Feb 27 2002
    copyright            : (C) 2002 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef HOTAREA_H
#define HOTAREA_H

#include <qrect.h>

class QDomElement;
class Level;
class Cdp;
class Event;
class QCanvasRectangle;

/**This class specifies a hot area on the level(canvas), that can trigger
events when the taxi touches/enters or untouches/leaves it.
It's main purpose is to act as a switch.
  *@author Thomas Friedrichsmeier
  */

class HotArea : public QRect  {
public: 
	HotArea(const QDomElement *description, Level *parent);
	~HotArea();
/** Checks, whether the taxi (given it's bounding rectangle) is in relevant relation to this area, and performs the
action applicable */
	void check (QRect taxirect);
private:
/** The parent level */
	Level * level;
/** The cdp */
	Cdp *cdp;
/** Reads in the description for this area */
	void read_area (const QDomElement *description);
/** Whether the area has those types of events */
	bool has_touch_event;
	bool has_untouch_event;
	bool has_enter_event;
	bool has_leave_event;
/** The Events themselves */
	Event *touch_event;
	Event *untouch_event;
	Event *enter_event;
	Event *leave_event;
/** Last known relation of taxi to area */
	bool touches;
	bool inside;
/** a plot of the area's outline (usually not shown) */
	QCanvasRectangle *outline;
};

#endif
