/***************************************************************************
                          taxipilotapp.cpp  -  description
                             -------------------
    begin                : Sun Aug 12 2001
    copyright            : (C) 2001 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kstdaction.h>
#include <kkeydialog.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kmessagebox.h>

#include "taxipilotapp.h"
#include "preferences.h"

#include <qpixmapcache.h>

TaxipilotApp::TaxipilotApp(QWidget * parent, const char *name):KMainWindow(parent, name)
{
	tp = new Taxipilot(this);
	setCentralWidget(tp);

	flaps_key_pressed = false;

// create the menubar

	gameNew = KStdAction::openNew(tp, SLOT(newGame()), actionCollection(), "game_new");
	gameAbort = KStdAction::close(tp, SLOT(ask_abortGame()), actionCollection(), "game_close");
	gameAbort->setEnabled(false);
	gameAbort->setText(i18n("Stop"));
	gamePause = new KAction(i18n("&Pause"), 0, tp, SLOT(pauseGame()), actionCollection(), "game_pausex");
	gamePause->setEnabled(false);
	gameResume = new KAction(i18n("&Resume"), 0, tp, SLOT(resumeGame()), actionCollection(), "game_resume");
	gameResume->setEnabled(false);
//  (void)new KAction( i18n("Show &Highscores..."), 0, this, SLOT( slotShowHighscores() ), actionCollection(), "game_hiscores" );
	KStdAction::quit(tp, SLOT(quitGame()), actionCollection(), "game_quit");

	KStdAction::preferences(this, SLOT( changePrefs() ), actionCollection());
	(void) new KAction(i18n("Select &Mission..."), 0, tp, SLOT(selectMission()), actionCollection(), "settings_mission");


	accel = new KAccel(this);
	actions.insert("Up", Up);
	accel->insertItem(i18n("Accelerate Upwards"), "Up", Qt::Key_Up);
	actions.insert("Left", Left);
	accel->insertItem(i18n("Accelerate Leftwards"), "Left", Qt::Key_Left);
	actions.insert("Down", Down);
	accel->insertItem(i18n("Accelerate Downwards"), "Down", Qt::Key_Down);
	actions.insert("Right", Right);
	accel->insertItem(i18n("Accelerate Rightwards"), "Right", Qt::Key_Right);

	actions.insert("Flaps", Flaps);
	accel->insertItem(i18n("Toggle Flaps"), "Flaps", Qt::Key_F);

	actions.insert("Pause", Pause);
//	accel->insertItem( i18n("Pause game"), "Pause", Qt::Key_P );
	gamePause->plugAccel(accel, true);
//	accel->setDescription ( "Pause", i18n("Pause game") );

	actions.insert("Resume", Resume);
	gameResume->plugAccel(accel, true);
//	accel->insertItem( i18n("Resume paused game"), "Resume", Qt::Key_R );
	actions.insert("Acknowledge", Acknowledge);
	accel->insertItem(i18n("Acknowledge Message"), "Acknowledge", Qt::Key_Space);

	accel->readSettings();
	ack_key_name = KAccel::keyToString(accel->currentKey("Acknowledge"));

	KStdAction::keyBindings(this, SLOT(configureKeys()), actionCollection());

	createGUI("taxipilotui.rc");

	tp->init();

}

TaxipilotApp::~TaxipilotApp()
{
}

void TaxipilotApp::keyPressEvent(QKeyEvent * e)
{

	QString id = accel->findKey(e->key());

	if (id.isEmpty()) {
		e->ignore();
		return;
	}

	Action a = actions[id];

	switch (a) {
	case Left:
		tp->current_key_lr = -1;
		break;
	case Up:
		tp->current_key_ud = -1;
		break;
	case Right:
		tp->current_key_lr = 1;
		break;
	case Down:
		tp->current_key_ud = 1;
		break;
	case Acknowledge:
		emit (ack_key_pressed ());
		break;
	case Flaps:
		if (!flaps_key_pressed) {
			tp->toggle_flaps = true;
		} else {
			flaps_key_pressed = true;
		}
		break;
	default:{
			e->ignore();
		}
	}

}

/** We need this in combination with the above handler to work around slow auto-repeats:
	pressed keys are stored in (int) tp->current_key_lr (left is -1, right is 1), tp->current_key_ud (up is -1, down is 1),
	and tp->space_pressed (bool) until they get released. Current key is
	parsed by do_chores. */
void TaxipilotApp::keyReleaseEvent(QKeyEvent * e)
{

	QString id = accel->findKey(e->key());

	if (id.isEmpty()) {
		e->ignore();
		return;
	}

	Action a = actions[id];

	switch (a) {
	case Left:
		if (tp->current_key_lr == -1) {
			tp->current_key_lr = 0;
		}
		break;
	case Up:
		if (tp->current_key_ud == -1) {
			tp->current_key_ud = 0;
		}
		break;
	case Right:
		if (tp->current_key_lr == 1) {
			tp->current_key_lr = 0;
		}
		break;
	case Down:
		if (tp->current_key_ud == 1) {
			tp->current_key_ud = 0;
		}
		break;
	case Flaps:
		tp->toggle_flaps = flaps_key_pressed = false;
		break;
	default:{
			e->ignore();
		}
	}

}

/** Calls up the key-Bindings-Dialog and sanity-checks
the settings */
void TaxipilotApp::configureKeys()
{

	bool ok;

	do {
		ok = true;
		KKeyDialog::configureKeys(accel, true, this);
		if ((!accel->currentKey("Up")) || (!accel->currentKey("Down")) || (!accel->currentKey("Left"))
			|| (!accel->currentKey("Right")) || (!accel->currentKey("Acknowledge"))) {
			ok = false;
			KMessageBox::sorry(this, i18n("The acceleration and acknowledge-keys must be defined!"));
		}
	} while (!ok);
	ack_key_name = KAccel::keyToString(accel->currentKey("Acknowledge"));

}

/** No descriptions */
void TaxipilotApp::changePrefs(){
	Preferences *prefs = new Preferences ( tp );
	if ( prefs->exec() )
		// update everything
	delete prefs;
}
