/***************************************************************************
                          taxipilot.h  -  description
                             -------------------
    begin                : Don Mai 17 20:03:43 CEST 2001
    copyright            : (C) 2001 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TAXIPILOT_H
#define TAXIPILOT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qlabel.h>
#include <qlcdnumber.h>
#include <qdial.h>
#include <qfileinfo.h>
#include <qcanvas.h>
#include <qwidget.h>
#include <qstring.h>
#include <qlist.h>

#include <klocale.h>

#include "eqdial.h"

class TaxipilotApp;
class Passenger;
class Cdp;
class Taxi;
class Level;
class Message;

/** Taxipilot is the base class of the project */
class Taxipilot:public QWidget {
  Q_OBJECT public:
  /** construtor */
	 Taxipilot(TaxipilotApp * parent = 0, const char *name = 0);
  /** destructor */
	~Taxipilot();
	bool onActivePlatform();
  /** This function really would be part of the constructor. It initializes Taxipilot by reading
the default mission, displaying the start-screen, and setting a few variables.
The thing is though, that it may also set the KAction gameNew to enabled or
disabled, which rests on this Action having been created in TaxiPIlotApp, which
in turn depends on having an instance of Taxipilot.
If you can think of something more elegant, please don't hesitate to tell me. */
	void init();
  /** Takes care of any scrolling necessary (for oversized levels) */
	void do_scroll();
/** A public reference to the common debugging and prefixing class */
	Cdp *cdp;
/** our parent app. level needs to be able to access this */
	TaxipilotApp *app;
  /** Should flaps be toggled in the next chores? */
	bool toggle_flaps;

	friend class TaxipilotApp;	/* Our beloved parent */
	friend class Platform;

  private:
	 QCanvas * canvas;			// Basic Widgets/Objects
	Taxi *taxi;
	Level *level;
	Passenger *passenger;
	Message *message_handler;

/** False if the game has not started yet. So we don't accidentally mess with undefinded variables */
	bool game_running;
/** This is not an opponent to game_running! A running game can be paused. */
	bool game_paused;

/** Whether the passengers have been created (needed in the destructor) */
	bool passengers_created;
/** Array of pointers to all passengers */
	Passenger **all_passengers;

	QCanvasView *view;
	int base_timer, passenger_timer, scroll_timer, credits_timer;
	void do_chores();
  /** Computes the gravity acting on the taxi and sets it. Also updates the speedDial */
	void do_gravity();
	int check_landed();			// returns platform landed on or -1
	void landing_func();		// this function is responsible for everything involved when landed
	void crash(int how);		// handle the crash         
  /** Reads in a mission-description file. */
	void readMission(const QString & file);
	QString *level_files, *passenger_files;
/** An array for those passengers that will appear on the startscreen **/
	struct Passengers_on_Startscreen {
		/** The id of the passenger **/
		int id;
		/** The x_position of the passenger on the Startscreen */
		int x;
		/** The x_position of the passenger on the Startscreen */
		int y;
		/** Pointer to the passenger (so we can delete it) */
		Passenger *pointer;
	} *passengers_on_start_screen;
	int taxi_start_screen_x, taxi_start_screen_y;
	bool taxi_on_start_screen;
/** How many passengers are to appear on the startscreen? */
	int num_passengers_on_start_screen;
/** The filename of the startscreen itself */
	QString startscreen_file;
	QCanvasPixmap *start_screen;
	int num_level_files, num_passenger_files;
/** number of current level (internal, i.e. starting with 0) */
	int current_level;
	QString taxi_file;
	QLCDNumber *shipsLCD, *scoreLCD, *fareLCD, *tipLCD;	// Display stuff
	EQDial *fuelDial, *speedDial;
	QLabel *statusLabel, *destinationLabel;
	double fare, tip;			// coming to be gaming stuff
	double tip_step;			// depends on passenger->impatience (avoids recalculation)
	double score;
	int ships, initial_ships;
/** This is needed, so a teleporter we land on does not beam us right away again */
	bool on_teleporter;
	int on_platform;			// which platform are we on, then?
	bool fueling;
	bool passenger_exists;
	bool passenger_onboard, passenger_waiting;	// internal gaming variables
	int active_platform;		// the platform_number of the next task (-1 if no task pending)
	QString string;				// just a universal string
  /**  Saves the content of the status label when game gets paused */
	QString lastStatus;
  /** Generates and displays the current mission's startscreen */
	void display_start_screen();
  /** Delete (the passengers on) the Startscreen */
	void delete_start_screen();
  /** Displays a message as QCanvasText on the Canvas (scrolling it into view). */
	void display_message(int message_id);
  /** Generates the credits text and graphics */
	void generate_credits();
  /** Free all the memory occupied by the credits */
	void delete_credits();
/** used for fading the current level */
	QCanvasRectangle *fader;
/** for do_event_after_message */
	int event_after_message;
/** current offsets */
	int current_offset_x, current_offset_y;
/* BEGIN These needed for the credits */
	struct Credit_item {
		int width;
		int y;
		int space_to_next;
		QCanvasItem *item;
	};
	 QList < Credit_item > credits;
	int first_visible_credit;
	int last_visible_credit;
	QString mission_author, mission_title;
/** This function is only ever needed by generate_credits */
	void append_credit(Credit_item * item, int space_after);
/* END These needed for the credits */
/** Is there an active start-screen? (Needed in case of errors) */
	bool start_screen_active;
/** see TaxipilotApp->keyReleaseEvent () for documentation */
	int current_key_lr, current_key_ud;
/** An acceleration constant, that may abstract from refresh and recalculation rate */
	double acceleration;
  protected:					// Protected methods
	void timerEvent(QTimerEvent * e);
  /** Pause the game when focus gets lost. */
  void focusOutEvent (QFocusEvent *e);
	public slots:				// Public slots
	void picked_up();			// signal that passenger has successfully boarded
  /** No descriptions */
	void passenger_abandoned();
  /** No descriptions */
	void delivery_complete();
	/* passenger is now ready for pick-up */
	void passenger_ready();
  /** I really hate doing this, but I need to have a function that is called after a text
message was displayed, which will do, whatever needs to be done next.
Unfortunately, what needs to be done may vary. */
	void do_event_after_message();
/** This function aborts the current game. Usually called by ask_abortGame, which
first asks, then calls this function */
	void abortGame();
  /** Receives a signal that the config changed. */
  void config_changed();
	 signals:					// Signals
/** signal the passenger he can come aboard at taxi_x */
	void start_boarding(int taxi_x);
  /** Signal to any class that might need to know, that the
game has been resumed. */
	void gameResumed();
  /** Signal to any classes that might need to know, that the game is paused */
	void gamePaused();
  /** signal the passenger may leave now */
	void delivered_passenger(int base_x, int base_y, int dest_x);
  /** Tells the taxi, it crashed. */
	void taxiCrashed();
  /** No descriptions */
	void gameOver();
	private slots:				// Private slots
  /** Starts the game */
	void newGame();
  /** Guess what! */
	void quitGame();
  /** Resumes a paused game */
	void resumeGame();
  /** Pauses the game. This might mess up the timers and stuff.
Also any class having timers will have to have an eye on this.
Therefore gamePaused() will be emitted. */
	void pauseGame();
  /** Selects a new Mission (i.e. a list of level- and
passenger-description-files) */
	void selectMission();
  /** Asks whether game should really be aborted, then calls abortGame () */
	void ask_abortGame();
};

#endif
