/***************************************************************************
                          state.h  -  description
                             -------------------
    begin                : Thu Nov 22 2001
    copyright            : (C) 2001 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef STATE_H
#define STATE_H


/**An abstract state, i.e. mostly a boolean-variable that may be a conditional for certain actions, with some
member-functions to set and read the current state. A truly simple class.
  *@author Thomas Friedrichsmeier
  */

#include <qstring.h>

class QDomElement;
class Cdp;

class State {
public: 
	State(const QDomElement *description, Cdp *cdpp);
	~State();
  /** Returns, whether the state is currently set */
  bool isSet ();
  /** Sets the state to new_state */
  void set (bool new_state);
  /** Toggles the state */
  void toggle ();
  /** Returns the identification string for this state */
  QString get_ident ();
private:
/** The actual state */
	bool state;
/** The ident-string for this state */
	QString ident;
private: // Private methods
/** Parses the description for this state */
	void read_state (const QDomElement *description);
/** Pointer to the cdp */
	Cdp *cdp;
};

#endif
