/***************************************************************************
                          preferences.cpp  -  description
                             -------------------
    begin                : Tue Nov 27 2001
    copyright            : (C) 2001 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "preferences.h"

#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qslider.h>
#include <qlcdnumber.h>
#include <qstring.h>
#include <qlineedit.h>
#include <qfileinfo.h>

#include <kfiledialog.h>
#include <klocale.h>

#include "taxipilot.h"
#include "cdp.h"

Preferences::Preferences(Taxipilot *parent) : Preferences_gui (parent, 0, true) {
	connect ( ok_button, SIGNAL (clicked ()), SLOT (ok ()) );
	connect ( cancel_button, SIGNAL (clicked ()), SLOT (cancel ()) );
	connect ( base_rate, SIGNAL (valueChanged (int)), SLOT (base_rate_change (int)) );
	connect ( fps, SIGNAL (valueChanged (int)), SLOT (fps_change (int)) );
	connect ( sel_def_m_dir, SIGNAL (clicked ()), SLOT (select_mission_path ()) );
	connect ( sel_def_m, SIGNAL (clicked ()), SLOT (select_default_mission ()) );
	connect ( def_m, SIGNAL (textChanged (const QString &)), SLOT (mission_selected ()) );

// somehow, I have to do this manually.
	mission_bg->insert (def_mission);
	mission_bg->insert (last_mission);
	mission_bg->insert (sel_mission);

// get initial values:
	cdp = parent->cdp;
	fps->setValue (cdp->pref_fps);
	base_rate->setValue (cdp->pref_cps);
	def_m_path->setText (cdp->data_prefix);
	def_m->setText (cdp->pref_SelectedMission);
	def_mission->setChecked (cdp->pref_useDefaultMission);	
	last_mission->setChecked (cdp->pref_useLastMission);
	def_m_text->setText (cdp->pref_DefaultMission);
	last_m_text->setText (cdp->pref_LastMission);
}
Preferences::~Preferences(){
}

/** Ok-Button pressed. Save changes */
void Preferences::ok(){

	cdp->alt_data_prefix = cdp->data_prefix = def_m_path->text ();
	cdp->alt_image_prefix = cdp->image_prefix = cdp->data_prefix + "/images/";
	cdp->pref_useDefaultMission = def_mission->isChecked ();
	cdp->pref_useSelectedMission = sel_mission->isChecked ();
	cdp->pref_useLastMission = last_mission->isChecked ();
	cdp->pref_SelectedMission = def_m->text ();

	cdp->pref_fps = fps->value ();
	cdp->pref_cps = base_rate->value ();

	cdp->set_new_config ();

	accept ();
}

/** Cancel-Button pressed. Exit */
void Preferences::cancel(){
	reject ();
}

/** fps-slider got changed. Update displays */
void Preferences::fps_change(int new_val){
	fpsLCD->display (new_val);
	base_rate->setMaxValue ( new_val );
}

/** main_ratio-slider changed. Update displays. */
void Preferences::base_rate_change(int new_val){
	base_rateLCD->display ( new_val );
}

/** Select the default mission path */
void Preferences::select_mission_path(){
	QString dummy = (KFileDialog::getExistingDirectory (def_m_path->text (), this, i18n ( "Select default mission-path" )));
	if (!dummy.isEmpty ()) {
		def_m_path->setText (dummy);
	}
}

/** Select the default mission */
void Preferences::select_default_mission(){
	QString dummy = (KFileDialog::getOpenFileName (QFileInfo::QFileInfo (def_m->text ()).dirPath (true), "*.mission", this, i18n ( "Select default mission-path" )));
	if (!dummy.isEmpty ()) {
		def_m->setText (dummy);
	}
}

/** No descriptions */
void Preferences::mission_selected(){
	sel_mission->setChecked (true);
}
