/***************************************************************************
                          message.h  -  description
                             -------------------
    begin                : Wed Nov 28 2001
    copyright            : (C) 2001 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MESSAGE_H
#define MESSAGE_H

#include <qobject.h>

/**Container for two QCanvasText-Objects, that are used to display
a message (like "you crashed").
  *@author Thomas Friedrichsmeier
  */

class QCanvasView;
class QString;
class QCanvasText;
class Taxipilot;
class Cdp;

class Message : public QObject  {
	Q_OBJECT
public:
	Message(Taxipilot * parent, QCanvasView *p_view);
	~Message();
	void display_message (QString & message, QString & ack_key, QString & done_slot);
private:
	QCanvasText * message_sprite;
	QCanvasText * ack_sprite;
/** Phase of message-display: 0: Messages coming up; 1: Message in place, Acknowledge-Text coming up;
	2: Both texts in place; 3: Message acknowledged, coth texts scrolling out of view */
	int phase;
	QCanvasView *view;
	Taxipilot *tp;
	int text_dest_mid, text_dest_top;
	int old_chunk_size;
	Cdp *cdp;
protected:
	void timerEvent(QTimerEvent * e);
signals: // Signals
/** Message is done */
	void done();
public slots: // Public slots
  /** Message was acknowledged */
  void acknowledged();
};

#endif
