/***************************************************************************
                          message.cpp  -  description
                             -------------------
    begin                : Wed Nov 28 2001
    copyright            : (C) 2001 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "message.h"

#include <qcanvas.h>
#include <qstring.h>
#include <qfont.h>
#include <qfontinfo.h>
#include <qrect.h>

#include <klocale.h>

#include "taxipilot.h"
#include "taxipilotapp.h"
#include "cdp.h"

#include "defines.h"

Message::Message(Taxipilot * parent, QCanvasView *p_view) : QObject (parent) {
	view = p_view;	
	tp = parent;
	cdp = tp->cdp;
	phase = 3;			// which is the phase, in which the two text-sprites are not existent. See destructor
}

Message::~Message(){
	if (phase != 3) {
		delete ack_sprite;
		delete message_sprite;
	}
}

void Message::display_message (QString & message, QString & ack_key, QString & done_slot) {
	phase = 0;

	connect (tp->app, SIGNAL (ack_key_pressed ()), SLOT (acknowledged ()));
	connect (this, SIGNAL (done ()), tp, done_slot);

	QFont ack_font(SPACE_TEXT_FONT, SPACE_TEXT_FONT_SIZE);
	ack_sprite = new QCanvasText ( i18n ( "Press '" ) + ack_key + "'...", ack_font, view->canvas ());
	ack_sprite->setColor(SPACE_TEXT_COLOR);
	ack_sprite->setTextFlags(AlignHCenter | AlignTop);
	ack_sprite->setZ(MESSAGE_Z);

	QFont message_font(MESSAGE_FONT);
	message_sprite = new QCanvasText (message, message_font, view->canvas ());
	message_sprite->setColor(MESSAGE_COLOR);
	message_sprite->setTextFlags(AlignHCenter | AlignBottom);
	message_sprite->setZ(MESSAGE_Z);

// Calculate message_font-size
	int i = 0;					// determine max text-size
	QRect bound;
	do {

		do {					// get next font-size that can be displayed reasonably
			message_font.setPointSize(MESSAGE_FONT_SIZE - i);
			i += 1;
		} while ((i < (MESSAGE_FONT_SIZE - 6)) && (!QFontInfo::QFontInfo(message_font).exactMatch()));

		message_sprite->setFont(message_font);
		bound = message_sprite->boundingRect();	// and check, whether message fits with this font-size.
	} while ((i < (MESSAGE_FONT_SIZE - 6))
			 && ((bound.width() > view->width()) || (bound.height() > (view->height() / 2))));

// Optimize Canvas-Chunksize
	old_chunk_size = view->canvas()->chunkSize ();
	view->canvas()->retune ( 16 + ((int) ((bound.width () + 4* bound.height()) / 5) / 16) * 16 );

// Move the texts to bottom center of view
	message_sprite->move((view->width() / 2) + view->contentsX (), (view->height() + (bound.height() / 2)) + view->contentsY ());
	text_dest_mid = (view->height() / 2) + view->contentsY ();
	text_dest_top = view->contentsY () - (bound.height() / 2);
	message_sprite->show();

	bound = ack_sprite->boundingRect();
	ack_sprite->move((view->width() / 2) + view->contentsX (), (view->height() + (bound.height() / 2)) + view->contentsY ());

	message_sprite->setYVelocity (- TEXT_SPEED/cdp->fps () );

	startTimer (cdp->cps ());
}

void Message::timerEvent(QTimerEvent * e) {

	if (message_sprite->y() > text_dest_mid) {
	} else {
		if (!phase) {
			message_sprite->setYVelocity(0);
			phase = 1;
			ack_sprite->setYVelocity (- 2 * TEXT_SPEED/cdp->fps () );
			ack_sprite->show ();
		} else if (phase == 1) {
			if (ack_sprite->y() < (text_dest_mid + 20)) {
				ack_sprite->setYVelocity(0);
				phase = 2;
			}
		} else if (phase == 3) {
			if ((ack_sprite->y() < -20) && (message_sprite->y() < text_dest_top)) {
				ack_sprite->hide();
				message_sprite->hide();
				delete ack_sprite;
				delete message_sprite;
				killTimers ();
				emit (done ());
				disconnect ();
				view->canvas ()->retune (old_chunk_size);
			}
		}
	}

}

/** Message was acknowledged */
void Message::acknowledged(){
	if (phase != 3) {
		phase = 3;

		message_sprite->setYVelocity (- TEXT_SPEED/cdp->fps () );
		ack_sprite->show ();	// might not have been shown yet
		ack_sprite->setYVelocity (- 2 * TEXT_SPEED/cdp->fps () );
	}
}
