/***************************************************************************
                          event.cpp  -  description
                             -------------------
    begin                : Fri Nov 23 2001
    copyright            : (C) 2001 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "event.h"

#include <qdom.h>

#include "level.h"
#include "cdp.h"
#include "state.h"
#include "conditional.h"

Event::Event(const QDomElement *description, Level *parent) {
	level = parent;
	cdp = level->cdp;

	read_event (description);
}

Event::~Event(){
	if (num_changes) {delete [] changes;}
	if (has_conditional) {delete conditional;}
	if (num_child_events) {delete [] child_events;}
}

/** Reads in the description for this event */
void Event::read_event (const QDomElement *description){
}

/** Triggers this event */
void Event::trigger(){
	if (has_conditional) {
		if (!conditional->fulfilled ()) {
			return;
		}
	}
	int i;
	for (i=0; i < num_changes; i++) {
		if (!changes[i].change_type) {
			changes[i].state->toggle ();
		} else {
			changes[i].state->set (changes[i].change_type > 0);
		}
	}
	for (i=0; i < num_child_events; i++) {
		child_events[i]->trigger ();
	}
}
