/***************************************************************************
                          eqdial.h  -  description
                             -------------------
    begin                : Thu Oct 18 2001
    copyright            : (C) 2001 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EQDIAL_H
#define EQDIAL_H

#include <qwidget.h>
#include <qdial.h>

class QColor;

/**provides a qdial extended by a litte
LED-like spot that may signal exeeding or
dropping below a certain value on
the dial
  *@author Thomas Friedrichsmeier
  */

class EQDial:public QDial {
  Q_OBJECT public:
	EQDial(int min, int max, int step, int val, QWidget * parent = 0, const char *name = 0);
	~EQDial();
  /** No descriptions */
	void setColors(QColor & cnormal, QColor & cwarning);
  /** Sets the lower and upper warning limits. Negative values imply no limit set. */
	void setLimits(int lower, int upper);
  private:
	 QColor normal, warning;
	int upper_limit, lower_limit;
	bool check_upper, check_lower;
  protected:
	void paintEvent(QPaintEvent * e);
	void valueChange();
  private:						// Private methods
  /** Paints the warning LED */
	void paintWarning();
};

#endif
