/***************************************************************************
                          centerofgravity.h  -  description
                             -------------------
    begin                : Sun Nov 4 2001
    copyright            : (C) 2001 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CENTEROFGRAVITY_H
#define CENTEROFGRAVITY_H


/**A generalized class for centers of gravity, that may
either be traditional static centers or moving objects.
  *@author Thomas Friedrichsmeier
  */

#include <qstring.h>

class Level;
class QDomElement;
class MovingObject;
class Cdp;

class CenterOfGravity {
public: 
	CenterOfGravity(const QDomElement *description, Level *parent);
	~CenterOfGravity();
/** Fulfills the promise (assigns the promised object to this center) */
	void promise_fulfilled(MovingObject * obj);
/** Reads in the description for this center of gravity */
	void read_center (const QDomElement *description);
/** Takes the current position and speed of the taxi as arguments, changes the
velocity (vx, vy) - vars to the new value (which will be set by Taxipilot, when
all Centers have been calculated). */
	void calculate_gravity (int const taxi_pos_x, int const taxi_pos_y, double *vx, double *vy);
  /** No descriptions */
  void config_changed ();
friend class Level;
private:
/** Whether this center has been defined as an object, which will have to be connected */
	bool object_promised;
/** (redundant:) Whether the center has a moving object */
	bool has_object;
/** The identification-string of the promised object */
	QString object_ident;

/** position if static*/
	int static_x, static_y;
/** constant of gravity (call it mass of the center) */
	double gravity;
/** same without taking into account the cdp->cps () */
	double n_gravity;
/** potential: Three values are permitted:
		
		0: force does not depend on distance ( but direction of force depends on direction )
		1: force depends on plain distance
		2: "phsical gravity" - force is reverse of distance squared
		4: "dangerous spot" - force is reverse of distance to the fourth power
*/
	int potential;

/** The cdp */
	Cdp *cdp;

/** Pointer to the underlying object, if any */
	MovingObject *object;
/** The offset of the center's center to the top left of the sprite (if not static) */
	int center_off_x, center_off_y;

/** The maximum force (cut-off) */
	double force_limit;
};

#endif
