## system-config-printer

## Copyright (C) 2006, 2007, 2008 Red Hat, Inc.
## Copyright (C) 2006, 2007 Florian Festi <ffesti@redhat.com>
## Copyright (C) 2006, 2007, 2008 Tim Waugh <twaugh@redhat.com>

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

prefix="/usr/local"
datadir="${prefix}/share"
pkgdatadir="${datadir}/${PACKAGE}"
VERSION="1.0.3"
PACKAGE="system-config-printer"
DOWNLOADABLE_DRIVER_SUPPORT=False

import os
class Paths:
      def __init__ (self):
            vars = ['prefix', 'datadir', 'pkgdatadir', 'VERSION', 'PACKAGE']
            for var in vars:
                  os.environ[var] = eval (var)
            self.paths = {}
            changed = True
            while changed:
                  changed = False
                  for var in vars:
                        old = self.paths.get (var, None)
                        self.paths[var] = os.path.expandvars (os.environ[var])
                        os.environ[var] = self.paths[var]
                        if old != self.paths[var]:
                              changed = True

      def get_path (self, var):
            return self.paths[var]
