/*******************************************************************************
 * Simplified Wrapper and Interface Generator  (SWIG)
 * 
 * Author : David Beazley
 *
 * Department of Computer Science        
 * University of Chicago
 * 1100 E 58th Street
 * Chicago, IL  60637
 * beazley@cs.uchicago.edu
 *
 * Please read the file LICENSE for the copyright and terms by which SWIG
 * can be used and distributed.
 *******************************************************************************/

static char cvsroot[] = "$Header: /cvsroot/SWIG/Source/Modules1.1/pycpp.cxx,v 1.14 2000/03/01 20:20:22 beazley Exp $";

/**********************************************************************
 * $Header: /cvsroot/SWIG/Source/Modules1.1/pycpp.cxx,v 1.14 2000/03/01 20:20:22 beazley Exp $
 *
 * pycpp.cxx
 *
 * This module contains code to generate Python shadow classes of C/C++
 * objects.  
 **************************************************************************/


#include "mod11.h"
#include "python.h"

static  String   *setattr;
static  String   *getattr;
static  String   *csetattr;
static  String   *cgetattr;
static  String   *pyclass;
static  String   *imethod;
static  String   *construct;
static  String   *cinit;
static  String   *additional;
static  int       have_constructor;
static  int       have_destructor;
static  int       have_getattr;
static  int       have_setattr;
static  int       have_repr;
//static  char     *class_name;
static  char     *class_type;
static  char     *real_classname;
static  String   *base_class;
static  String   base_getattr;
static  String   base_setattr;
static  int      class_renamed = 0;

// --------------------------------------------------------------------------
// PYTHON::cpp_open_class(char *classname, char *rname, char *ctype, int strip)
//
// Opens a new C++ class or structure.
// --------------------------------------------------------------------------

void PYTHON::cpp_open_class(char *classname, char *rname, char *ctype, int strip) {

  char  temp[256];

  this->Language::cpp_open_class(classname, rname, ctype, strip);
  
  if (shadow) {
    /* Create new strings for building up a wrapper function */
    
    setattr   = new String();
    getattr   = new String();
    csetattr  = new String();
    cgetattr  = new String();
    pyclass   = new String();
    imethod   = new String();
    construct = new String();
    cinit     = new String();
    additional= new String();
    base_class = 0;
    base_getattr = "";
    base_setattr = "";

    
    //  *pyclass << "class " << rname << ":\n";

    have_constructor = 0;
    have_destructor = 0;
    have_getattr = 0;
    have_setattr = 0;
    have_repr = 0;
    if (rname) {
      class_name = copy_string(rname);
      class_renamed = 1;
    } else {
      class_name = copy_string(classname);
      class_renamed = 0;
    }
  }

  real_classname = copy_string(classname);
  class_type = copy_string(ctype);

  // Build up the hash table
  Setattr(hash,real_classname,class_name);

  sprintf(temp,"%s %s", class_type, real_classname);
  Setattr(hash,temp,class_name);

  if (shadow) {
    *setattr << tab4 << "def __setattr__(self,name,value):\n"
	     << tab8 << "if (name == \"this\") or (name == \"thisown\"): self.__dict__[name] = value; return\n"
    	     << tab8 << "method = " << class_name << ".__setmethods__.get(name,None)\n"
	     << tab8 << "if method: return method(self,value)\n";
    
    *getattr << tab4 << "def __getattr__(self,name):\n";

    *csetattr << tab4 << "__setmethods__ = {\n";
    *cgetattr << tab4 << "__getmethods__ = {\n";
  }

}

// --------------------------------------------------------------------------
// PYTHON::cpp_member_func(char *name, char *iname, DataType *t, ParmList *l)
//
// Creates a C++ member function
// --------------------------------------------------------------------------

void PYTHON::cpp_member_func(char *name, char *iname, DataType *t, ParmList *l) {

  Parm *p;
  int   i;
  char *realname;
  int   oldshadow;
  int   pcount;
  int   numopt;
  int   have_optional;

  String cname = "python:";
  String translate = "";

  // Create the default member function
  
  oldshadow = shadow;    // Disable shadowing when wrapping member functions
  if (shadow) shadow = shadow | PYSHADOW_MEMBER;
  this->Language::cpp_member_func(name,iname,t,l);
  shadow = oldshadow;
  if (shadow) {
    if (!iname)
      realname = name;
    else
      realname = iname;
    
    // Check to see if we've already seen this
    cname << class_name << "::" << realname;
    if (Getattr(symbols,cname.get())) {
      return;   // Forget it, already saw it
    }
    Setattr(symbols,cname.get(),cname.get());
    
    if (strcmp(realname,"__repr__") == 0) 
      have_repr = 1;


    if (!((Getattr(hash,t->name)) && (t->is_pointer <=1)) && !noopt) {
      *imethod << class_name << "."  << realname << " = new.instancemethod(" << module << "." << name_member(realname,class_name) << ", None, " << class_name << ")\n";
      /*       *pyclass << tab4 << realname << " = " << module << ".__shadow__." << name_member(realname,class_name) << "\n"; */
    } else {

      // Now add it to the class
    
      if (use_kw)
	*pyclass << tab4 << "def " << realname << "(*args, **kwargs):\n";
      else
	*pyclass << tab4 << "def " << realname << "(*args):\n";
      
      if (use_kw)
	*pyclass << tab8 << "val = apply(" << module << "." << name_member(realname,class_name) << ",args, kwargs)\n";
      else
	*pyclass << tab8 << "val = apply(" << module << "." << name_member(realname,class_name) << ",args)\n";
      
      // Check to see if the return type is an object
      if ((Getattr(hash,t->name)) && (t->is_pointer <= 1)) {
	if (!typemap_check("out",typemap_lang,t,name_member(realname,class_name))) {
	  if (!have_output) {
	    *pyclass << tab8 << "if val: val = " << GetChar(hash,t->name) << "Ptr(val) ";
	    if (((Getattr(hash,t->name)) && (t->is_pointer < 1)) ||
		((Getattr(hash,t->name)) && (t->is_pointer == 1) && NewObject))
	      *pyclass << "; val.thisown = 1\n";
	    else 
	      *pyclass << "\n";
	  } else {
	    // Do nothing!
	  }
	}
      }
      *pyclass << tab8 << "return val\n";
    }
    //    emitAddPragmas(*pyclass, realname, tab8);
    //    *pyclass << tab8 << "return val\n";
  }
}

// -----------------------------------------------------------------------------
// void PYTHON::cpp_constructor(char *name, char *iname, ParmList *l)
//
// Make a constructor for our class
// -----------------------------------------------------------------------------

void PYTHON::cpp_constructor(char *name, char *iname, ParmList *l) {
  char *realname;
  Parm *p;
  int   i;
  int   oldshadow = shadow;
  String cname = "python:constructor:";
  String translate = "";
  int pcount, numopt;
  int have_optional;

  if (shadow) shadow = shadow | PYSHADOW_MEMBER;
  this->Language::cpp_constructor(name,iname,l);
  shadow = oldshadow;

  if (shadow) {
    if (iname)
      realname = iname;
    else {
      if (class_renamed) realname = class_name;
      else realname = class_name;
    }
    
    // Check to see if we've already seen this
    cname << class_name << "::" << realname;
    if (Getattr(symbols,cname.get())) {
      return;   // Forget it, already seen it
    }
    Setattr(symbols,cname.get(),cname.get());

    if (!have_constructor) { 

      // Create a new constructor 

      if (use_kw)
	*construct << tab4 << "def __init__(self,*args,**kwargs):\n";
      else
	*construct << tab4 << "def __init__(self,*args):\n";

      if (use_kw)
	*construct << tab8 << "self.this = apply(" << module << "." << name_construct(realname) << ",args,kwargs)\n";
      else
	*construct << tab8 << "self.this = apply(" << module << "." << name_construct(realname) << ",args)\n";
      *construct << tab8 << "self.thisown = 1\n";
      emitAddPragmas(*construct,"__init__",tab8);
      have_constructor = 1;
    } else {

      // Hmmm. We seem to be creating a different constructor.  We're just going to create a
      // function for it.

      if (use_kw)
	*additional << "def " << realname << "(*args,**kwargs):\n";
      else
	*additional << "def " << realname << "(*args):\n";

      *additional << tab4 << "val = " << class_name << "Ptr(apply(";
      if (use_kw)
	*additional << module << "." << name_construct(realname) << ",args,kwargs))\n";
      else
	*additional << module << "." << name_construct(realname) << ",args))\n";
      *additional << tab4 << "val.thisown = 1\n"
		  << tab4 << "return val\n\n";
    }
  }
}

// ------------------------------------------------------------------------------
// void PYTHON::cpp_destructor(char *name, char *newname)
//
// Creates a destructor for this object
// ------------------------------------------------------------------------------

void PYTHON::cpp_destructor(char *name, char *newname) {
  char *realname;
  int oldshadow = shadow;

  if (shadow) shadow = shadow | PYSHADOW_MEMBER;
  this->Language::cpp_destructor(name,newname);
  shadow = oldshadow;
  if (shadow) {
    if (newname) realname = newname;
    else {
      if (class_renamed) realname = class_name;
      else realname = name;
    }
    
    *pyclass << tab4 << "def __del__(self," << module << "=" << module << "):\n";
    emitAddPragmas(*pyclass,"__del__",tab8);
    *pyclass << tab8 << "if self.thisown == 1 :\n"
	     << tab8 << tab4 << module << "." << name_destroy(realname) << "(self)\n";
    
    have_destructor = 1;
  }
}

// -------------------------------------------------------------------------------
// PYTHON::cpp_close_class()
//
// Closes a Python class and writes out a wrapper
// -------------------------------------------------------------------------------
    
void PYTHON::cpp_close_class() {
  String    ptrclass;
  String    repr;

  if (shadow) {

    if (!have_constructor) {
      // Build a constructor that takes a pointer to this kind of object
      *construct << tab4 << "def __init__(self,this):\n";
      *construct << tab8 << "self.this = this\n";
    }

    // First, build the pointer base class
    if (base_class) {
      ptrclass << "class " << class_name << "(" << *base_class << "):\n";
    } else {
    ptrclass << "class " << class_name << ":\n";
    }

    //    *getattr << tab8 << "return self.__dict__[name]\n";

    *getattr << tab8 << "method = " << class_name << ".__getmethods__.get(name,None)\n"
	     << tab8 << "if method: return method(self)\n";
    *getattr << tab8 << "raise AttributeError,name\n";
    *setattr << tab8 << "self.__dict__[name] = value\n";
    *cgetattr << tab4 << "}\n";
    *csetattr << tab4 << "}\n";
    ptrclass << *cinit 
	     << *construct << "\n";

    classes << ptrclass
	    << *pyclass;

    if (have_setattr) {
      classes << *csetattr;
      classes << *setattr;
    }
    if (have_getattr) {
      classes << *cgetattr;
      classes << *getattr;
    }
    
    if (!have_repr) {
      // Supply a repr method for this class 
      repr << tab4 << "def __repr__(self):\n"
	   << tab8 << "return \"<C " << class_name <<" instance at %s>\" % (self.this,)\n";

      classes << repr;
      emitAddPragmas(classes,"__class__",tab4);
    }

    // Now build the real class with a normal constructor

    classes << "class " << class_name << "Ptr(" << class_name << "):\n";

    classes << tab4 << "def __init__(self,this):\n"
	    << tab8 << "self.this = this\n"
	    << tab8 << "self.thisown = 0\n"
	    << tab8 << "self.__class__ = " << class_name << "\n"
	    << "\n" << *additional << "\n";

    classes << *imethod << "\n";
    delete pyclass;
    delete imethod;
    delete setattr;
    delete getattr;
    delete additional;
  }
}

void PYTHON::cpp_cleanup() { };

void PYTHON::cpp_inherit(char **baseclass,int) {

  char *bc;
  int   i = 0, first_base = 0;

  if (!shadow) {
    this->Language::cpp_inherit(baseclass);
    return;
  }

  // We'll inherit variables and constants, but not methods

  this->Language::cpp_inherit(baseclass, INHERIT_VAR);

  if (!baseclass) return;
  base_class = new String;

  // Now tell the Python module that we're inheriting from a base class

  while (baseclass[i]) {
    bc = GetChar(hash,baseclass[i]);
    if (bc) {
      if (first_base) *base_class << ",";
      *base_class << bc;
      first_base = 1;
    }
    i++;
  }
  if (!first_base) {
    delete base_class;
    base_class = 0;
  }
}

// --------------------------------------------------------------------------------
// PYTHON::cpp_variable(char *name, char *iname, DataType *t)
//
// Adds an instance member.
// --------------------------------------------------------------------------------

void PYTHON::cpp_variable(char *name, char *iname, DataType *t) {
  char *realname;
  int   inhash = 0;
  int   oldshadow = shadow;
  String cname = "python:";

  if (shadow) shadow = shadow | PYSHADOW_MEMBER;
  this->Language::cpp_variable(name,iname,t);
  shadow = oldshadow;

  if (shadow) {
    have_getattr = 1;
    have_setattr = 1;
    if (!iname)
      realname = name;
    else
      realname = iname;

    // Check to see if we've already seen this

    cname << class_name << "::" << realname;
    if (Getattr(symbols,cname.get())) {
      return;   // Forget it, already seen it
    }
    Setattr(symbols,cname.get(),cname.get());
    
    // Figure out if we've seen this datatype before
    
    if ((Getattr(hash,t->name)) && (t->is_pointer <= 1)) inhash = 1;
    
    // Now write some code to set the variable
    if (Status & STAT_READONLY) {
      //      *setattr << tab8 << tab4 << "raise RuntimeError, \'Member is read-only\'\n";
    } else {
      *csetattr << tab8 << "\"" << realname << "\" : " << module << "." << name_set(name_member(realname,class_name)) << ",\n";
    }
    // Write some code to get the variable
    if (inhash) {
      *cgetattr << tab8 << "\"" << realname << "\" : lambda x : " << GetChar(hash,t->name) << "Ptr(" << module << "." << name_get(name_member(realname,class_name)) << "(x)),\n";

    } else {
      *cgetattr << tab8 << "\"" << realname << "\" : " << module << "." << name_get(name_member(realname,class_name)) << ",\n";
    }
  }
}

// --------------------------------------------------------------------------------
// PYTHON::cpp_declare_const(char *name, char *iname, DataType *type, char *value)
//
// Add access to a C++ constant
// --------------------------------------------------------------------------------

void PYTHON::cpp_declare_const(char *name, char *iname, DataType *type, char *value) {
  char *realname;
  int   oldshadow = shadow;
  String cname = "python:";

  if (shadow) shadow = shadow | PYSHADOW_MEMBER;
  this->Language::cpp_declare_const(name,iname,type,value);
  shadow = oldshadow;

  if (shadow) {
    if (!iname)
      realname = name;
    else
      realname = iname;

    // Check to see if we've already seen this

    cname << class_name << "::" << realname;
    if (Getattr(symbols,cname.get())) {
      return;   // Forget it, already seen it
    }
    Setattr(symbols,cname.get(),cname.get());
    
    *cinit << tab4 << realname << " = " << module << "." << name_member(realname,class_name) << "\n";
  }
}
 
// --------------------------------------------------------------------------------
// PYTHON::add_typedef(DataType *t, char *name)
//
// This is called whenever a typedef is encountered.   When shadow classes are
// used, this function lets us discovered hidden uses of a class.  For example :
//
//     struct FooBar {
//            ...
//     }
//
// typedef FooBar *FooBarPtr;
//
// --------------------------------------------------------------------------------

void PYTHON::add_typedef(DataType *t, char *name) {

  if (!shadow) return;

  // First check to see if there aren't too many pointers

  if (t->is_pointer > 1) return;

  if (Getattr(hash,name)) return;      // Already added


  // Now look up the datatype in our shadow class hash table

  if (Getattr(hash,t->name)) {

    // Yep.   This datatype is in the hash
    
    // Put this types 'new' name into the hash

    Setattr(hash,name, GetChar(hash,t->name));
  }
}
