#include "doh.h"

/* Special Web-object method */

typedef struct {
    DOHCOMMON;
    DOH     *data;
    DOH     *headers;
} WebObject;

/* Sequence methods : Operating on strings */

DOH *WebObject_getitem(DOH *o, int i) {
  WebObject *w = (WebObject *) o;
  return Getitem(w->data,i);
}

int WebObject_setitem(DOH *o, int i, DOH *value) {
  WebObject *w = (WebObject *) o;
  Setitem(w->data,i,value);
}

int WebObject_delitem(DOH *o, int i) {
  WebObject *w = (WebObject *) o;
  Delitem(w->data,i);
}

int WebObject_insert(DOH *o, int i, DOH *value) {
  WebObject *w = (WebObject *) o;
  Insert(w->data,i,value);
}

DohSequenceMethods WebObjectSequence = {
    WebObject_getitem,
    WebObject_setitem,
    WebObject_delitem,
    WebObject_insert,
    0,
    0,
};

DOH *WebObject_getattr(DOH *obj, DOH *name) {
  WebObject *w = (WebObject *) obj;
  return Getattr(w->headers,name);
}

int WebObject_setattr(DOH *obj, DOH *name, DOH *value) {
  WebObject *w = (WebObject *) obj;
  return Setattr(w->headers,name,value);
}

int WebObject_delattr(DOH *obj, DOH *name) {
  WebObject *w = (WebObject *) obj;
  Delattr(w->headers,name);
}

DOH *WebObject_firstkey(DOH *obj) {
  WebObject *w = (WebObject *) obj;
  return Firstkey(w->headers);
}

DOH *WebObject_nextkey(DOH *obj) {
  WebObject *w = (WebObject *) obj;
  return Nextkey(w->headers);
}

DohMappingMethods WebObjectMapping = {
    WebObject_getattr,
    WebObject_setattr,
    WebObject_delattr,
    WebObject_firstkey,
    WebObject_nextkey,
};


int WebObject_read(DOH *o, void *ptr, int len) {
  WebObject *w = (WebObject *) o;
  return Read(w->data,ptr,len);
}

int WebObject_write(DOH *o, void *ptr, int len) {
  WebObject *w = (WebObject *) o;
  return Write(w->data,ptr,len);
}

int WebObject_seek(DOH *o, long offset, int whence) {
  WebObject *w = (WebObject *) o;
  return Seek(w->data,offset,whence);
}

long WebObject_tell(DOH *o) {
  WebObject *w = (WebObject *) o;
  return Tell(w->data);
}

DohFileMethods WebObjectFile = {
    WebObject_read,
    WebObject_write,
    0,                
    0,
    0,
    WebObject_seek,
    WebObject_tell,
    0,
};


/* -----------------------------------------------------------------------------
 * Miscellaneous functions 
 * ----------------------------------------------------------------------------- */

void DelWebObject(DOH *so) {
  WebObject *w = (WebObject *) so;
  Delete(w->data);
  Delete(w->headers);
  free(w);
}

void WebObject_clear(DOH *so) {
  WebObject *w = (WebObject *) so;
  Clear(w->data);
  Clear(w->headers);
}

DOH *WebObject_str(DOH *so) {
  WebObject *w = (WebObject *) so;
  DOH *str, *key;

  str = NewString("");
  key = Firstkey(w->headers);
  while (key) {
    Printf(str,"%s: %s\n", key, Getattr(w->headers,key));
    key = Nextkey(w->headers);
  }
  Printf(str,"Content-length: %d\n",Len(w->data));
  Printf(str,"\n");
  Printf(str,"%b",w->data);
  return str;
}

int WebObject_dump(DOH *so, DOH *out) {
  WebObject *w = (WebObject *) so;
  DOH *str, *key;
  int  nbytes = 0;

  str = NewString("");
  key = Firstkey(w->headers);
  while (key) {
    Printf(str,"%s: %s\n", key, Getattr(w->headers,key));
    key = Nextkey(w->headers);
  }
  Printf(str,"Content-length: %d\n",Len(w->data));
  Printf(str,"\n");
  nbytes = Dump(str,out);
  nbytes += Dump(w->data,out);
  Delete(str);
  return nbytes;
}

int WebObject_len(DOH *so) {
  WebObject *w = (WebObject *) so;
  return Len(w->data);
}

DohObjInfo WebObjectType = {
    "WebObject",     /* objname */
    sizeof(WebObject),
    DelWebObject,         /* sm_del   */
    0,                    /* Copy     */
    WebObject_clear,      /* sm_clear */
    WebObject_str,        /* sm_str */
    0,                    /* doh_data */
    WebObject_dump,       /* doh_dump */
    WebObject_len,        /* sm_len */
    0,                    /* sm_hash    */
    0,                    /* doh_cmp */
    &WebObjectMapping,    /* doh_mapping */
    &WebObjectSequence,   /* doh_sequence */
    &WebObjectFile,       /* doh_file */
    0,
    0,
    0,
    0,
};

DOH *NewWebObject() {
  WebObject *w;
  w = (WebObject *) DohMalloc(sizeof(WebObject));
  DohInit(w);
  w->objinfo = &WebObjectType;
  w->data = NewString("");
  w->headers = NewHash();
  return (DOH *) w;
}
