//
// SWIG Typemap library
// Dave Beazley
// May 5, 1997
//
// Perl5 implementation
//
// This library provides standard typemaps for modifying SWIG's behavior.
// With enough entries in this file, I hope that very few people actually
// ever need to write a typemap.
//

// ------------------------------------------------------------------------
// Pointer handling
//
// These mappings provide support for input/output arguments and common
// uses for C/C++ pointers.
// ------------------------------------------------------------------------

// INPUT typemaps.
// These remap a C pointer to be an "INPUT" value which is passed by value
// instead of reference.


%typemap(perl5,in) double *INPUT(double temp)
{
  temp = (double) SvNV($source);
  $target = &temp;
}

%typemap(perl5,in) float  *INPUT(float temp)
{
  temp = (float) SvNV($source);
  $target = &temp;
}

%typemap(perl5,in) int            *INPUT(int temp)
{
  temp = (int) SvIV($source);
  $target = &temp;
}

%typemap(perl5,in) short          *INPUT(short temp)
{
  temp = (short) SvIV($source);
  $target = &temp;
}

%typemap(perl5,in) long           *INPUT(long temp)
{
  temp = (long) SvIV($source);
  $target = &temp;
}
%typemap(perl5,in) unsigned int   *INPUT(unsigned int temp)
{
  temp = (unsigned int) SvIV($source);
  $target = &temp;
}
%typemap(perl5,in) unsigned short *INPUT(unsigned short temp)
{
  temp = (unsigned short) SvIV($source);
  $target = &temp;
}
%typemap(perl5,in) unsigned long  *INPUT(unsigned long temp)
{
  temp = (unsigned long) SvIV($source);
  $target = &temp;
}
%typemap(perl5,in) unsigned char  *INPUT(unsigned char temp)
{
  temp = (unsigned char) SvIV($source);
  $target = &temp;
}
                 
// OUTPUT typemaps.   These typemaps are used for parameters that
// are output only.   The output value is appended to the result as
// a list element.

// Force the argument to be ignored.

%typemap(perl5,ignore) int            *OUTPUT(int temp),
                       short          *OUTPUT(short temp),
                       long           *OUTPUT(long temp),
                       unsigned int   *OUTPUT(unsigned int temp),
                       unsigned short *OUTPUT(unsigned short temp),
                       unsigned long  *OUTPUT(unsigned long temp),
                       unsigned char  *OUTPUT(unsigned char temp),
                       float          *OUTPUT(float temp),
                       double         *OUTPUT(double temp)
{
  $target = &temp;
}

%typemap(perl5,argout) int            *OUTPUT,
                       short          *OUTPUT,
                       long           *OUTPUT,
                       unsigned int   *OUTPUT,
                       unsigned short *OUTPUT,
                       unsigned long  *OUTPUT,
                       unsigned char  *OUTPUT
{
  if (argvi >= items) {
    EXTEND(sp,1);
  }
  $target = sv_newmortal();
  sv_setiv($target,(IV) *($source));
  argvi++;
}

%typemap(perl5,argout) float    *OUTPUT,
                       double   *OUTPUT
{
  if (argvi >= items) {
    EXTEND(sp,1);
  }
  $target = sv_newmortal();
  sv_setnv($target,(double) *($source));
  argvi++;
}

// BOTH
// Mappings for an argument that is both an input and output
// parameter

%typemap(perl5,in) int *BOTH = int *INPUT;
%typemap(perl5,in) short *BOTH = short *INPUT;
%typemap(perl5,in) long *BOTH = long *INPUT;
%typemap(perl5,in) unsigned *BOTH = unsigned *INPUT;
%typemap(perl5,in) unsigned short *BOTH = unsigned short *INPUT;
%typemap(perl5,in) unsigned long *BOTH = unsigned long *INPUT;
%typemap(perl5,in) unsigned char *BOTH = unsigned char *INPUT;
%typemap(perl5,in) float *BOTH = float *INPUT;
%typemap(perl5,in) double *BOTH = double *INPUT;

%typemap(perl5,argout) int *BOTH = int *OUTPUT;
%typemap(perl5,argout) short *BOTH = short *OUTPUT;
%typemap(perl5,argout) long *BOTH = long *OUTPUT;
%typemap(perl5,argout) unsigned *BOTH = unsigned *OUTPUT;
%typemap(perl5,argout) unsigned short *BOTH = unsigned short *OUTPUT;
%typemap(perl5,argout) unsigned long *BOTH = unsigned long *OUTPUT;
%typemap(perl5,argout) unsigned char *BOTH = unsigned char *OUTPUT;
%typemap(perl5,argout) float *BOTH = float *OUTPUT;
%typemap(perl5,argout) double *BOTH = double *OUTPUT;

// REFERENCE
// Accept Perl references as pointers

%typemap(perl5,in) double *REFERENCE (double dvalue)
{
  SV *tempsv;
  if (!SvROK($source)) {
    croak("expected a reference");
  }
  tempsv = SvRV($source);
  if ((!SvNOK(tempsv)) && (!SvIOK(tempsv))) {
	printf("Received %d\n", SvTYPE(tempsv));
	croak("Expected a double reference.");
  }
  dvalue = SvNV(tempsv);
  $target = &dvalue;
}

%typemap(perl5,in) float *REFERENCE (float dvalue)
{
  SV *tempsv;
  if (!SvROK($source)) {
    croak("expected a reference");
  }
  tempsv = SvRV($source);
  if ((!SvNOK(tempsv)) && (!SvIOK(tempsv))) {
    croak("expected a double reference");
  }
  dvalue = (float) SvNV(tempsv);
  $target = &dvalue;
}

%typemap(perl5,in) int *REFERENCE (int dvalue)
{
  SV *tempsv;
  if (!SvROK($source)) {
    croak("expected a reference");
  }
  tempsv = SvRV($source);
  if (!SvIOK(tempsv)) {
    croak("expected a integer reference");
  }
  dvalue = SvIV(tempsv);
  $target = &dvalue;
}

%typemap(perl5,in) short *REFERENCE (short dvalue)
{
  SV *tempsv;
  if (!SvROK($source)) {
    croak("expected a reference");
  }
  tempsv = SvRV($source);
  if (!SvIOK(tempsv)) {
    croak("expected a integer reference");
  }
  dvalue = (short) SvIV(tempsv);
  $target = &dvalue;
}
%typemap(perl5,in) long *REFERENCE (long dvalue)
{
  SV *tempsv;
  if (!SvROK($source)) {
    croak("expected a reference");
  }
  tempsv = SvRV($source);
  if (!SvIOK(tempsv)) {
    croak("expected a integer reference");
  }
  dvalue = (long) SvIV(tempsv);
  $target = &dvalue;
}
%typemap(perl5,in) unsigned int *REFERENCE (unsigned int dvalue)
{
  SV *tempsv;
  if (!SvROK($source)) {
    croak("expected a reference");
  }
  tempsv = SvRV($source);
  if (!SvIOK(tempsv)) {
    croak("expected a integer reference");
  }
  dvalue = (unsigned int) SvIV(tempsv);
  $target = &dvalue;
}
%typemap(perl5,in) unsigned short *REFERENCE (unsigned short dvalue)
{
  SV *tempsv;
  if (!SvROK($source)) {
    croak("expected a reference");
  }
  tempsv = SvRV($source);
  if (!SvIOK(tempsv)) {
    croak("expected a integer reference");
  }
  dvalue = (unsigned short) SvIV(tempsv);
  $target = &dvalue;
}
%typemap(perl5,in) unsigned long *REFERENCE (unsigned long dvalue)
{
  SV *tempsv;
  if (!SvROK($source)) {
    croak("expected a reference");
  }
  tempsv = SvRV($source);
  if (!SvIOK(tempsv)) {
    croak("expected a integer reference");
  }
  dvalue = (unsigned long) SvIV(tempsv);
  $target = &dvalue;
}

%typemap(perl5,argout) double *REFERENCE,
                       float  *REFERENCE
{
  SV *tempsv;
  tempsv = SvRV($arg);
  sv_setnv(tempsv, (double) *$source);
}

%typemap(perl5,argout) int            *REFERENCE,
                       short          *REFERENCE,
                       long           *REFERENCE,
                       unsigned int   *REFERENCE,
                       unsigned short *REFERENCE,
                       unsigned long  *REFERENCE
{
  SV *tempsv;
  tempsv = SvRV($arg);
  sv_setiv(tempsv, (int) *$source);
}

// --------------------------------------------------------------------
// Special types
//
// --------------------------------------------------------------------


