.\" @(#) swatch.5 1.1 92/04/02 Stanford University
.TH SWATCH 5 "13 December 1995"
.SH NAME
swatchrc \- configuration file for the simple watcher swatch(8)
.SH SYNOPSIS
.B ~/.swatchrc
.SH DESCRIPTION
This configuration file is used by the 
.B swatch(8)
program to determine
what types of expression patterns to look for and what type
of action(s) should be taken when a pattern is matched.
.PP
The file contains four TAB separated fields:
.IP
/pattern/[,/pattern/,...]	action[,action,...]	[[HH:]MM:]SS	start:length
.PP
A pattern must be a regular expression which
.B perl(1)
will accept,
which is very similar to the regular expressions which
.B egrep(1)
accepts.
.PP
The following actions are acceptable:
.TP 20
.B echo[=mode]
Echo the matched line.
The text mode may be
.I normal,
.I bold,
.I underscore, blink,
.I inverse.
Some modes may not work on some terminals.
.B Normal
is the default. 
.TP
.B bell[=N]
Echo the matched line, and send a bell
.I N
times (default = 1).
.TP
.B exec=command
Execute
.IR command "."
The
.I command
may contain variables which are substituted with fields from the matched 
line. A
.I $N
will be replaced by the
.IR Nth " field in the line. A"
.IR $0 " or"
.I $*
will be replaced by the entire line.
.TP
.B ignore
Ignore the matched line.
.TP
.B mail[=address:address:...]
Send
.IR mail " to"
.I address(es)
containing the matched lines as they appear (default
address is the user who is running the program).
.TP
.B pipe=command
Pipe matched lines into
.IR command "."
.TP
.B write[=user:user:...]
Use
.B write(1)
to send matched lines to
.IR user(s) "."
.PP
The
.B third
field (which is optional) can contain a time interval.
The time should be in one of three formats:
.TP 15
.B SS
.I -- Just seconds
.TP
.B MM:SS
.I -- Minutes and seconds
.TP
.B HH:MM:SS
.I -- Hours minutes and seconds
.PP
If an interval
is specified and more than one identical line is received,
.B swatch
will not do the actions specified until the specified time has elapsed.
If the action that is performed uses the input line then the number of
lines will be included in the line.
.PP
The
.B fourth
field is also optional and must only exist if the the third field
exists.  This field is used to specify the location of the time stamp in the 
log message as well as the length of the time stamp.  It should be specified
in the form start:length.
.SH EXAMPLE
.IP
.B /file system full/              echo,bell	01:00	0:16
.PP
This example a line which contains the string "file system full" will
be echoed and the screen bell will sound.  Also, multiple instances of
the message will not be echoed if they appear within a minute of the 
first one.  Instead the following message will be acted upon after 
the time interval has expired.  This is what may appear if a the message
appeared 20 times.
.IP
** 20 seen in 00:01:00 ==> somehost: /var: file system full
.SH SEE ALSO
.BR swatch (8),
.BR perl (1),
.BR egrep (1),
.SH AUTHOR
.nf
.IR "E. Todd Atkins"  " (Todd.Atkins@CAST.Stanford.EDU)"
Computer Administration Support Team
Distributed Computing Group
Stanford University
.fi
