#
# Created on Tue Nov  9 19:14:12 PST 1993 by Todd_Atkins@CAST.Stanford.EDU
#
# Copyright (1995) The Board of Trustees of the Leland Stanford Junior
# Univeristy.  Except for commercial resale, lease, license or other commercial
# transactions, permission is hereby given to use, copy, modify, and distribute
# this software -- by exercising this permission you agree that this Notice
# shall accompany this software at all times. 
# 
# STANFORD MAKES NO REPRESENTATIONS OR WARRANTIES OF ANY KIND CONCERNING
# THIS SOFTWARE.

# usage: install.pl [full_path_to_perl]
#
$ENV{'PATH'} = '/usr/ucb:/usr/bin:/bin:/usr/local/bin' ;
$ENV{'IFS'} = '' if $ENV{'IFS'} ne '' ;


##
## Default values
##
       $PERL_LIB_DIR = "/usr/local/lib/perl" ;
       $PERL_BIN_DIR = "/usr/local/bin" ;
     $SWATCH_BIN_DIR = "/usr/local/etc" ;
     $SWATCH_MAN_DIR = "/usr/local/man" ;
$SWATCH_PROG_MAN_EXT = "8" ;
$SWATCH_CONF_MAN_EXT = "5" ;
   $SWATCH_DATA_MODE = 444 ;
 $SWATCH_SCRIPT_MODE = 755 ;
              $OWNER = "root" ;
              $GROUP = "wheel" ;
   $SWATCH_PROG_NAME = "swatch" ;
    $SWATCH_PROG_MAN = "swatch.prog.man" ;
    $SWATCH_CONF_MAN = "swatch.conf.man" ;
  $SWATCH_ACTION_LIB = "sw_actions.pl" ;
    $SWATCH_HIST_LIB = "sw_history.pl" ;

                $SED = "/usr/bin/sed" ; 
               $COPY = "/usr/bin/cp" ;
	      $CHMOD = "/usr/bin/chmod" ;

if ( ! -f $SED ) {
    $SED = `which sed` ;
    chop $SED ;
}
if ( ! -f $COPY ) {
    $COPY = `which cp` ;
    chop $COPY ;
}
if ( ! -f $CHMOD ) {
    $CHMOD = `which chmod` ;
    chop $CHMOD ;
}

if ($#ARGV == -1) {
    $PERL_BIN_DIR = `which perl` ;
    chop $PERL_BIN_DIR ;
} else {
    $PERL_BIN_DIR = $ARGV[0] ;
}
$PERL_BIN_DIR = substr($PERL_BIN_DIR, 0, rindex($PERL_BIN_DIR, '/')) ;

$ready = 0 ;
while (!$ready) {
    &get_some_answers() ;
    &print_values() ;
    print "Are these values okay (y or n)? " ;
    $ans = <STDIN> ; chop $ans ;
    $ready = 1 if ($ans eq 'y' || $ans eq 'Y') ;
}

print "\nAre you ready for me to start the installation (y or n)? " ;
$ans = <STDIN> ; chop $ans ;
&do_the_install() if ($ans eq 'y' || $ans eq 'Y') ;


##
##
##
sub get_some_answers {
    local($question) ;

    $question = "\nEnter the directory where $SWATCH_PROG_NAME\n" ;
    $question .= "is to be installed" ;
    $SWATCH_BIN_DIR = &get_answer($question, $SWATCH_BIN_DIR) ;

    $question = "\nWhat user should own the " ;
    $question .= "installed $SWATCH_PROG_NAME files?\n" ;
    $OWNER = &get_answer($question, $OWNER) ;

    $question = "\nWhat group should own the installed " ;
    $question .= "$SWATCH_PROG_NAME files?\n" ;
    $GROUP = &get_answer($question, $GROUP) ;

    $question = "\nWhat should the permissions be for the " ;
    $question .= "installed $SWATCH_PROG_NAME script?\n" ;
    $SWATCH_SCRIPT_MODE = &get_answer($question, $SWATCH_SCRIPT_MODE) ;

    $question = "\nWhat should the permissions be for the " ;
    $question .= "installed $SWATCH_PROG_NAME libraries and man pages?\n" ;
    $SWATCH_DATA_MODE = &get_answer($question, $SWATCH_DATA_MODE) ;

    $question = "\nEnter the name of the directory where the\n" ;
    $question .= "perl library files are located" ;
    $PERL_LIB_DIR = &get_answer($question, $PERL_LIB_DIR) ;

    $question = "\nEnter the name of the directory where you wish to\n" ;
    $question .= "install the $SWATCH_PROG_NAME library files" ;
    $SWATCH_LIB_DIR = &get_answer($question, $PERL_LIB_DIR) ;

    $question = "\nWhat directory should the $SWATCH_PROG_NAME " ;
    $question .= "man pages be installed" ;
    $SWATCH_MAN_DIR = &get_answer($question, $SWATCH_MAN_DIR) ;

    $question = "\nWhat should the extension be for the $SWATCH_PROG_NAME " ;
    $question .= "program manual page?" ;
    $SWATCH_PROG_MAN_EXT = &get_answer($question, $SWATCH_PROG_MAN_EXT) ;

    $question = "\nWhat should the extension be for the $SWATCH_PROG_NAME " ;
    $question .= "configuration file manual page?" ;
    $SWATCH_CONF_MAN_EXT = &get_answer($question, $SWATCH_CONF_MAN_EXT) ;
}


##
##
##
sub do_the_install {
    system ("$SED -e \"s?PERL_LIB_DIR?$PERL_LIB_DIR?g\" -e \"s?SWATCH_LIB_DIR?$SWATCH_LIB_DIR?g\" -e \"s?PERL_BIN_DIR?$PERL_BIN_DIR?g\" $SWATCH_PROG_NAME.pl > $SWATCH_PROG_NAME" ) ;

    &install_it($swatch_uid, $swatch_gid, $SWATCH_SCRIPT_MODE,
		$SWATCH_PROG_NAME, "$SWATCH_BIN_DIR/$SWATCH_PROG_NAME") ;

    &install_it($swatch_uid, $swatch_gid, $SWATCH_DATA_MODE,
		$SWATCH_ACTION_LIB, "$SWATCH_LIB_DIR/$SWATCH_ACTION_LIB") ;
    &install_it($swatch_uid, $swatch_gid, $SWATCH_DATA_MODE,
		$SWATCH_HIST_LIB, "$SWATCH_LIB_DIR/$SWATCH_HIST_LIB") ;

    &install_it($swatch_uid, $swatch_gid, $SWATCH_DATA_MODE,
		$SWATCH_PROG_MAN, "$SWATCH_MAN_DIR/man$SWATCH_PROG_MAN_EXT/$SWATCH_PROG_NAME.$SWATCH_PROG_MAN_EXT") ;
    &install_it($swatch_uid, $swatch_gid, $SWATCH_DATA_MODE,
		$SWATCH_CONF_MAN, "$SWATCH_MAN_DIR/man$SWATCH_CONF_MAN_EXT/$SWATCH_PROG_NAME.$SWATCH_CONF_MAN_EXT") ;
}


sub install_it {
    local($uid, $gid, $mode, $src_file, $dest_file) = @_ ;

    print "Installing $src_file..." ;
    system("$COPY $src_file $dest_file") ;
    chown($uid, $gid, $dest_file) ;
    system("$CHMOD $mode $dest_file") ;
    print "done.\n" ;
}


##
##
##
sub get_answer {
    local($msg, $dflt) = @_ ;
    local($done) = 0 ;
    local($ans) ;

    while (!$done) {
        print "$msg" ;
        if ($dflt) {
    	    print " (default '$dflt') " ;
        }
        $ans = <STDIN> ;
	chop $ans ;
        if ($ans eq '') {
	    if ($dflt) {
	        $ans = $dflt ;
	        $done = 1 ;
	    }
        } else {
	    $done = 1 ;
        }
    }
    return $ans ;
}


sub print_values {
  print "\nHere is what I have...\n" ;
  print "\tPerl library: $PERL_LIB_DIR\n" ;
  print "\tSwatch binary location: $SWATCH_BIN_DIR\n" ;
  print "\tSwatch manual page location: $SWATCH_MAN_DIR\n" ;
  print "\tSwatch program manual page extention: $SWATCH_PROG_MAN_EXT\n" ;
  print "\tSwatch configuration file  manual page extention: $SWATCH_CONF_MAN_EXT\n" ;
  print "\tSwatch data file permissions: 0$SWATCH_DATA_MODE\n" ;
  print "\tSwatch program permissions: 0$SWATCH_SCRIPT_MODE\n" ;
  print "\tSwatch owner: $OWNER\n" ;
  print "\tSwatch group: $GROUP\n\n" ;
}
