/*	$Id: sudoku.c,v 1.12 2007/05/07 16:19:42 mbalmer Exp $ */

/*
 * Copyright (c) 2006, 2007 Marc Balmer <mbalmer@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <ctype.h>
#include <err.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "sudoku.h"

int verbose;

void
show(char f[10][9][9], int num)
{
	int x, y;

	for (y = 0; y < 9; y++) {
		if (y && y % 3 == 0) {
			if (num)
				printf("---+---+---  ");
			printf("---+---+---\n");
		}
		for (x = 0; x < 9; x++) {
			if (x && x % 3 == 0)
				printf("|");
			printf("%c", f[0][x][y] ? '0' + f[0][x][y] : ' ');
		}
		if (num) {
			printf("  ");
			for (x = 0; x < 9; x++) {
				if (x && x % 3 == 0)
					printf("|");
				printf("%c", f[num][x][y] ? 'X' : ' ');
			}
		}
		printf("\n");
	}
}

int
main(int argc, char *argv[])
{
	char f[10][9][9];
	FILE *fp;
	char line[128];
	char *s;
	char num = 0;
	int x, y, n, ch;

	bzero(f, sizeof(f));

	while ((ch = getopt(argc, argv, "v")) != -1) {
		switch (ch) {
		case 'v':
			++verbose;
			break;
		}
	}
	argc -= optind;
	argv += optind;

	if (argc == 1 && ((fp = fopen(argv[0], "r")) !=NULL)) {
		x = y = 0;
		while (fgets(line, sizeof(line), fp) != NULL) {
			if (line[0] == '#')
				continue;
			for (x = 0; x < 9 && line[x] != '\0' &&
			    line[x] != '\n'; x++) {
				if (!isdigit(line[x]) && line[x] != ' ')
					errx(1, "illegal symbol in %s: %c",
					    argv[0], line[x]);
				if (line[x] == ' ')
					continue;
				if (set(f, x, y, line[x] - '0'))
					errx(1, "error in %s: %c can not be "
					    "set at %d %d", argv[0], line[x],
					    x + 1, y + 1);
			}
			++y;
		}
		fclose(fp);
	}
	show(f, 0);
	printf("\n");

	while (find(f))
		++num;
	if (num)
		show(f, 0);

	if (!complete(f)) {
		guess(f);
		printf("\n");
		show(f, 0);
	}

	if (complete(f)) {
		if (verbose)
			printf("complete\n");
		exit(0);
	}

	if (verbose)
		printf("could not solve puzzle, not even by guessing\n");

	do {
		printf("enter x y num\n");

		if ((s = fgets(line, sizeof(line), stdin)) != NULL) {
			if (line[0] == 'g') {
				if ((num = findnum(f, &x, &y)) != 0) {
					printf("set guessed %d at %d %d\n",
					    num, x + 1, y + 1);
					if (set(f, x, y, num))
						printf("illegal position\n");
					else {
						while (find(f))
							;
						show(f, 0);
					}
				} else {
					if (!complete(f))
						printf("unsolved\n");
				}
			} else { 
				x = y = num = 0;
				sscanf(line, "%d %d %d", &x, &y, &n);
				num = n;
				if (x > 0 && x < 10 && y == 0)
					show(f, x);
				else if (x > 0 && x < 10 && y > 0 && y < 10
				    && num > 0 && num < 10) {
					--x;
					--y;
					if (set(f, x, y, num))
						printf("illegal position for "
						    "%d\n", num);
					else {
						show(f, num);
						while (find(f))
							;
						show(f, 0);
					}
				} else
					printf("illegal values: %d %d %d\n", x,
					    y, num);
			}
		}
	} while (s != NULL && !complete(f));
	return 0;
}
