/*	$Id: main.c,v 1.1 2007/07/22 15:59:41 mbalmer Exp $ */

/*
 * Copyright (c) 2007 Marc Balmer <marc@msys.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdio.h>
#include <stdlib.h>

#include <Xm/MainW.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/MessageB.h>
#include <Xm/PushB.h>
#include <Xm/FileSB.h>
#include <Xm/TextF.h>
#include <Xm/PanedW.h>
#include <Xm/DialogS.h>

#include "sudoku.h"

int verbose = 0;
Widget toplevel;

void file_cb(Widget widget, XtPointer client_data, XtPointer call_data);
void help_cb(Widget widget, XtPointer client_data, XtPointer call_data);
void numsel_help_cb(Widget widget, XtPointer client_data, XtPointer call_data);

void add_fields(Widget parent, int x, int y);
void field_pushed(Widget pb, XtPointer client_data, XtPointer call_data);
void number_pushed(Widget pb, XtPointer client_data, XtPointer call_data);
void clear_pushed(Widget pb, XtPointer client_data, XtPointer call_data);
void load_file_cb(Widget pb, XtPointer client_data, XtPointer call_data);

Widget *buttons[9][9];
char f[10][9][9];

struct user_data {
	int x;
	int y;
	int n;
};

void
show(char f[10][9][9], int num)
{
	int x, y;

	for (y = 0; y < 9; y++) {
		if (y && y % 3 == 0) {
			if (num)
				printf("---+---+---  ");
			printf("---+---+---\n");
		}
		for (x = 0; x < 9; x++) {
			if (x && x % 3 == 0)
				printf("|");
			printf("%c", f[0][x][y] ? '0' + f[0][x][y] : ' ');
		}
		if (num) {
			printf("  ");
			for (x = 0; x < 9; x++) {
				if (x && x % 3 == 0)
					printf("|");
				printf("%c", f[num][x][y] ? 'X' : ' ');
			}
		}
		printf("\n");
	}
}

void
clear(void)
{
	XmString label;
	struct user_data *d;
	int x, y;

	label = XmStringCreateLocalized("");

	bzero(f, sizeof(f));
	for (x = 0; x < 9; x++) {
		for (y = 0; y < 9; y++) {
			XtVaGetValues(buttons[x][y],
			    XmNuserData,	&d,
			    NULL);
			d->n = 0;
			XtVaSetValues(buttons[x][y],
			    XmNlabelString,	label,
			    XmNuserData,	d,
			    NULL);
		}
	}
}

void
read_file(char *path)
{
	FILE *fp;
	char line[128], name[3];
	int x, y;
	XmString label;
	struct user_data *d;

	if ((fp = fopen(path, "r")) != NULL) {
		x = y = 0;
		while (fgets(line, sizeof(line), fp) != NULL) {
			if (line[0] == '#')
				continue;
			for (x = 0; x < 9 && line[x] != '\0' &&
			    line[x] != '\n'; x++) {
				if (!isdigit(line[x]) && line[x] != ' ')
					errx(1, "illegal symbol in %s: %c",
					    path, line[x]);
				if (line[x] == ' ')
					continue;
				if (set(f, x, y, line[x] - '0'))
					errx(1, "error in %s: %c can not be "
					    "set at %d %d", path, line[x],
					    x + 1, y + 1);
				else {
					snprintf(name, sizeof(name), "%d",
					    line[x] - '0');
					label = XmStringCreateLocalized(name);
					printf("%d/%d: %d\n", x, y,
					    line[x] - '0');
					XtVaGetValues(buttons[x][y],
					    XmNuserData,	&d,
					    NULL);
					d->n = line[x] - '0';
					XtVaSetValues(buttons[x][y],
					    XmNlabelString,	label,
					    XmNuserData,	d,
					    NULL);
					XmStringFree(label);
				}
			}
			++y;
		}
		fclose(fp);
	}
}

int
main(int argc, char *argv[])
{
	XtAppContext app;
	Widget main_w, menubar, widget, form, subform, frame;
	XmString file, help, about, open, solve, clear, quit;
	int x, y;
	char name[16];

	bzero(f, sizeof(f));
	XtSetLanguageProc(NULL, NULL, NULL);


	toplevel = XtVaAppInitialize(&app, "XSudoku", NULL, 0, &argc, argv,
	    NULL, NULL);

	main_w = XtVaCreateManagedWidget("main_window",
	    xmMainWindowWidgetClass,	toplevel,
	    /*XmNscrollBarDisplayPolicy,	XmAS_NEEDED,
	    XmNscrollingPolicy,		XmAUTOMATIC,*/
	    NULL);

	/* Construct the menubar */
	file = XmStringCreateLocalized("File");
	help = XmStringCreateLocalized("Help");
	menubar = XmVaCreateSimpleMenuBar(main_w, "menubar",
	    XmVaCASCADEBUTTON,	file,	'F',
	    XmVaCASCADEBUTTON,	help,	'H',
	    NULL);
	XmStringFree(file);

	if (widget = XtNameToWidget(menubar, "button_1"))
		XtVaSetValues(menubar, XmNmenuHelpWidget, widget, NULL);

	open = XmStringCreateLocalized("Open...");
	solve = XmStringCreateLocalized("Solve puzzle");
	clear = XmStringCreateLocalized("Clear board");
	quit = XmStringCreateLocalized("Quit");
	XmVaCreateSimplePulldownMenu(menubar, "file_menu", 0, file_cb,
	    XmVaPUSHBUTTON, open, 'O', NULL, NULL,
	    XmVaPUSHBUTTON, solve, 'P', NULL, NULL,
	    XmVaPUSHBUTTON, clear, 'C', NULL, NULL,
	    XmVaSEPARATOR,
	    XmVaPUSHBUTTON, quit, 'Q', NULL, NULL,
	    NULL);
	XmStringFree(open);
	XmStringFree(solve);
	XmStringFree(clear);
	XmStringFree(quit);

	about = XmStringCreateLocalized("About");
	XmVaCreateSimplePulldownMenu(menubar, "help_menu", 1, help_cb,
	    XmVaPUSHBUTTON, help,  'H', NULL, NULL,
	    XmVaSEPARATOR,
	    XmVaPUSHBUTTON, about, 'A', NULL, NULL,
	    NULL);
	XmStringFree(help);
	XmStringFree(about);

	XtManageChild(menubar);

	/* construct the main area */
	form = XtVaCreateManagedWidget("main_form",
	    xmFormWidgetClass,	main_w,
	    XmNfractionBase,	3,
	    NULL);

	for (y = 0; y < 3; y++) {
		for (x = 0; x < 3; x++) {
			snprintf(name, sizeof(name), "frame_%d_%d", x, y);

			/* frame */
			frame = XtVaCreateWidget(name,
			    xmFrameWidgetClass,		form,
			    XmNshadowType,		XmSHADOW_ETCHED_IN,
			    XmNtopAttachment,		XmATTACH_POSITION,
			    XmNtopPosition,		y,
			    XmNleftAttachment,		XmATTACH_POSITION,
			    XmNleftPosition,		x,
			    XmNrightAttachment,		XmATTACH_POSITION,
			    XmNrightPosition,		x + 1,
			    XmNbottomAttachment,	XmATTACH_POSITION,
			    XmNbottomPosition,		y + 1,
			    NULL);
			snprintf(name, sizeof(name), "form_%d_%d", x, y);
			subform = XtVaCreateManagedWidget(name,
			    xmFormWidgetClass,		frame,
			    XmNfractionBase,		3,
			    NULL);
			add_fields(subform, x, y);
			XtManageChild(frame);
		}
	}
	
	XtVaSetValues(main_w,
	    XmNmenuBar,		menubar,
	    XmNworkWindow,	form,
	    NULL);

	if (argc == 2)
		read_file(argv[1]);

	XtRealizeWidget(toplevel);
	XtAppMainLoop(app);

	return 0;
}

void
add_fields(Widget parent, int x, int y)
{
	int xb, yb;
	char name[16];
	Widget pb;
	XmString label;
	struct user_data *d;

	label = XmStringCreateLocalized("");

	for (yb = 0; yb < 3; yb++) {
		for (xb = 0; xb < 3; xb++) {
			d = malloc(sizeof(struct user_data));
			if (d == NULL)
				err(1, "memory error");
			d->x = (x * 3) + xb;
			d->y = (y * 3) + yb;
			d->n = 0;
			snprintf(name, sizeof(name), "button_%d_%d", x + xb,
			    y + yb);
			pb = XtVaCreateManagedWidget(name,
			    xmPushButtonWidgetClass, parent,
			    XmNnumColumns,		1,
			    XmNtopAttachment,		XmATTACH_POSITION,
			    XmNtopPosition,		yb,
			    XmNleftAttachment,		XmATTACH_POSITION,
			    XmNleftPosition,		xb,
			    XmNrightAttachment,		XmATTACH_POSITION,
			    XmNrightPosition,		xb + 1,
			    XmNbottomAttachment,	XmATTACH_POSITION,
			    XmNbottomPosition,		yb + 1,
			    XmNlabelString,		label,
			    XmNuserData,		d,
			    XmNwidth,			32,
			    XmNheight,			32,
			    NULL);
			XtAddCallback(pb, XmNactivateCallback, field_pushed,
			    NULL);
			buttons[(x * 3) + xb][(y * 3) + yb] = pb;
		}
	}
}

Widget
GetTopShell(Widget w)
{
	while (w && !XtIsWMShell(w))
		w = XtParent(w);
	return w;
}

void
DestroyShell(Widget widget, XtPointer client_data, XtPointer call_data)
{
	Widget shell = (Widget)client_data;

	XtDestroyWidget(shell);
}

void
field_pushed(Widget pb, XtPointer client_data, XtPointer call_data)
{
	Widget widget, dialog, pane, form;
	String label;
	int x, y;
	char name[16];

	dialog = XtVaCreatePopupShell("number_selection",
	    xmDialogShellWidgetClass,	GetTopShell(pb),
	    XmNdeleteResponse,	XmDESTROY,
	    NULL);

	pane = XtVaCreateWidget("pane", xmPanedWindowWidgetClass, dialog,
	    XmNsashWidth,	1,
	    XmNsashHeight,	1,
	    NULL);

	form = XtVaCreateWidget("numsel_form",
	    xmFormWidgetClass,	pane,
	    XmNfractionBase,	3,
	    NULL);

	for (y = 0; y < 3; y++) {
		for (x = 0; x < 3; x++) {
			snprintf(name, sizeof(name), "%d", 7 - (y * 3) +  x);
			widget = XtVaCreateManagedWidget(name,
			    xmPushButtonWidgetClass,	form,
			    XmNnumColumns,		1,
			    XmNtopAttachment,		XmATTACH_POSITION,
			    XmNtopPosition,		y,
			    XmNleftAttachment,		XmATTACH_POSITION,
			    XmNleftPosition,		x,
			    XmNrightAttachment,		XmATTACH_POSITION,
			    XmNrightPosition,		x + 1,
			    XmNbottomAttachment,	XmATTACH_POSITION,
			    XmNbottomPosition,		y + 1,
			    XmNwidth,			32,
			    XmNheight,			32,
			    XmNuserData,		7 - (y * 3) + x,
			    NULL);
			
			XtAddCallback(widget, XmNactivateCallback,
			    number_pushed, pb);
		}
	}

	XtManageChild(form);

	form = XtVaCreateWidget("form2", xmFormWidgetClass, pane,
	    XmNfractionBase,	3,
	    NULL);

#if 0
	widget = XtVaCreateManagedWidget("Clear",
	    xmPushButtonWidgetClass,	form,
	    XmNtopAttachment,		XmATTACH_FORM,
	    XmNbottomAttachment,	XmATTACH_FORM,
	    XmNleftAttachment,		XmATTACH_POSITION,
	    XmNleftPosition,		1,
	    XmNrightAttachment,		XmATTACH_POSITION,
	    XmNrightPosition,		2,
	    XmNshowAsDefault,		False,
	    NULL);
	XtAddCallback(widget, XmNactivateCallback, clear_pushed, pb);
#endif

	widget = XtVaCreateManagedWidget("Cancel",
	    xmPushButtonWidgetClass,	form,
	    XmNtopAttachment,		XmATTACH_FORM,
	    XmNbottomAttachment,	XmATTACH_FORM,
	    XmNleftAttachment,		XmATTACH_POSITION,
	    XmNleftPosition,		1,
	    XmNrightAttachment,		XmATTACH_POSITION,
	    XmNrightPosition,		2,
	    XmNshowAsDefault,		True,
	    XmNdefaultButtonShadowThickness,	1,
	    NULL);
	XtAddCallback(widget, XmNactivateCallback, DestroyShell, dialog);
	XtManageChild(form);
	XtManageChild(pane);
	XtPopup(dialog, XtGrabNone);
}

void
number_pushed(Widget widget, XtPointer client_data, XtPointer call_data)
{
	Widget pb = (Widget)client_data;
	XmString *label;
	int number;
	struct user_data *d;
	
	XtVaGetValues(widget,
	    XmNlabelString,	&label,
	    XmNuserData,	&number,
	    NULL);

	XtVaGetValues(pb,
	    XmNuserData,	&d,
	    NULL);

	if (!set(f, d->x, d->y, number)) {
		printf("set %d at %d/%d\n", number, d->x, d->y);
		d->n = number;
		XtVaSetValues(pb,
		    XmNlabelString,	label,
		    XmNuserData,	d,
		    NULL);
	} else
		printf("can not set %d at %d/%d\n", number, d->x, d->y);
	XtPopdown(XtParent(XtParent(XtParent(widget))));
}

void
clear_pushed(Widget widget, XtPointer client_data, XtPointer call_data)
{
	Widget pb = (Widget)client_data;
	XmString label;
	
	label = XmStringCreateLocalized("");
	XtVaSetValues(pb,
	    XmNlabelString,	label,
	    XmNuserData,	0,
	    NULL);
	XtPopdown(XtParent(XtParent(XtParent(widget))));
}

void
file_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
	static Widget dialog;
	int item_no = (int)client_data;

	if (item_no == 1) {
		show(f, 0);
		while (find(f))
			;
		if (!(complete(f)))
			guess(f);
		if (complete(f)) {
			int x, y;
			char num[3];
			XmString label;

			for (x = 0; x < 9; x++) {
				for (y = 0; y < 9; y++) {
					snprintf(num, sizeof(num), "%d",
					    f[0][x][y]);
					label = XmStringCreateLocalized(num);
					XtVaSetValues(buttons[x][y],
					    XmNlabelString,	label,
					    NULL);
					XmStringFree(label);
				}
			}
		}
		printf("\n");
		show(f, 0);
	}

	if (item_no == 2)
		clear();

	if (item_no == 3)
		exit(0);

	if (item_no == 0) {
		if (!dialog) {
			dialog = XmCreateFileSelectionDialog(toplevel,
			    "file_sel", NULL, 0);
			XtAddCallback(dialog, XmNokCallback, load_file_cb,
			    NULL);
			XtAddCallback(dialog, XmNcancelCallback,
			    XtUnmanageChild, NULL);
		}
		XtManageChild(dialog);
		XtPopup(XtParent(dialog), XtGrabNone);
	}
}

void
help_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
	static Widget help, about;
	Widget *dialog;
	int item_no = (int)client_data;

	if (item_no == 0 && !help) {
		Arg args[5];
		int n = 0;
		XmString msg = XmStringCreateLtoR(
		    "Enter the known values to the field by clicking with\n"
		    "the mouse on field.  Solve the puzzle by selecting\n"
		    "\"Solve puzzle\" from the \"File\" menu.\n",
		    XmFONTLIST_DEFAULT_TAG);
		XtSetArg(args[n], XmNmessageString, msg);
		n++;
		help = XmCreateInformationDialog(toplevel, "help_dialog",
		    args, n);
		XtUnmanageChild(XmMessageBoxGetChild(help,
		    XmDIALOG_HELP_BUTTON));
		XtUnmanageChild(XmMessageBoxGetChild(help,
		    XmDIALOG_CANCEL_BUTTON));
	}

	if (item_no == 1 && !about) {
		Arg args[5];
		int n = 0;
		XmString msg = XmStringCreateLtoR(
		    "XSudoku Copyright (C) 2007 by Marc Balmer <marc@msys.ch>",
		    XmFONTLIST_DEFAULT_TAG);
		XtSetArg(args[n], XmNmessageString, msg);
		n++;
		about = XmCreateInformationDialog(toplevel, "about_dialog",
		    args, n);
		XtUnmanageChild(XmMessageBoxGetChild(about,
		    XmDIALOG_HELP_BUTTON));
		XtUnmanageChild(XmMessageBoxGetChild(about,
		    XmDIALOG_CANCEL_BUTTON));

	}

	if (item_no == 0)
		dialog = &help;
	else
		dialog = &about;

	XtManageChild(*dialog);
	XtPopup(XtParent(*dialog), XtGrabNone);
}

void
numsel_help_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
	static Widget help;
	Widget *dialog;
	Arg args[5];
	int n = 0;

	XmString msg = XmStringCreateLtoR(
	    "Select a number by pushing a button.",
	    XmFONTLIST_DEFAULT_TAG);
	XtSetArg(args[n], XmNmessageString, msg);
	n++;
	help = XmCreateInformationDialog(toplevel, "numsel_help_dialog",
	    args, n);
	XtUnmanageChild(XmMessageBoxGetChild(help,
	    XmDIALOG_HELP_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(help,
	    XmDIALOG_CANCEL_BUTTON));

	XtManageChild(help);
	XtPopup(XtParent(help), XtGrabNone);
}

void
load_file_cb(Widget widget, XtPointer client_data, XtPointer call_data)
{
	char *file;
	XmFileSelectionBoxCallbackStruct *cbs =
	    (XmFileSelectionBoxCallbackStruct *)call_data;

	if (!XmStringGetLtoR(cbs->value, XmFONTLIST_DEFAULT_TAG, &file))
		return;
	if (*file != '/') {
		char *dir, *newfile;
		if (XmStringGetLtoR(cbs->dir, XmFONTLIST_DEFAULT_TAG, &dir)) {
			newfile = XtMalloc(strlen(dir) + 1 + strlen(file) + 1);
			sprintf(newfile, "%s/%s", dir, file);
			XtFree(file);
			XtFree(dir);
			file = newfile;
		}
	}
	XtPopdown(XtParent(widget));
	clear();
	read_file(file);
	XtFree(file);
}
