/*
 * This file is part of sudognu.
 *
 * Copyright (C) 2007 Jens Baaran, Germany.
 ******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "sudoku.h"

/*
 ******************************************************************************/
int canoni(t_sudoku sudoku, t_sudoku *canon) {
	
	int h, i, j, k, l, m, n, tup, ntup, nminmap, maxnminmap, cmp;
	int ***grid, ***br, ***brmin, *tup0, **permut, ***minmap, *minh;
	
	// alloc & init
	grid = (int ***) malloc(sizeof(int**) * 8);
	for (i = 0; i < 8; i++) {
		grid[i] = (int **) malloc(sizeof(int*) * SIZE2);
		for (j = 0; j < SIZE2; j++) {
			grid[i][j] = (int *) malloc(sizeof(int) * SIZE2);
		}
	}
	for (i = 0; i < SIZE2; i++) {
		for (j = 0; j < SIZE2; j++) {
			grid[0][i][j] = sudoku.grid[i][j].value;
			grid[1][i][j] = sudoku.grid[j][i].value;
		}
	}
	br = (int ***) malloc(sizeof(int**) * 7);
	for (i = 0; i < 7; i++) {
		br[i] = (int **) malloc(sizeof(int*) * SIZE);
		for (j = 0; j < SIZE; j++) {
			br[i][j] = (int *) malloc(sizeof(int) * SIZE2);
		}
	}
	brmin    = (int ***) malloc(sizeof(int**) * 1);
	brmin[0] = (int **)  malloc(sizeof(int*)  * SIZE);
	for (i = 0; i < SIZE; i++) {
		brmin[0][i] = (int *) malloc(sizeof(int) * SIZE2);
	}
	minmap    = (int ***) malloc(sizeof(int**) * 1);
	minmap[0] = (int **)  malloc(sizeof(int*)  * 5);
	minh = (int *) malloc(sizeof(int)  * 1);
	
	// generate tuples
	tup = SIZE;
	tup0 = (int *) malloc(sizeof(int) * tup);
	for (i = 0; i < tup; i++) {
		tup0[i] = i;
	}
	for (i=ntup=2; i<tup; i++) ntup *= (i+1);
	permut = (int **) malloc(sizeof(int*) * ntup);
	for (i = 0; i < ntup; i++) {
		permut[i] = (int *) malloc(sizeof(int) * tup);
	}
	i = 0;
	init_permuts(tup0, permut, tup, tup, &i, ntup);
	
	// transform block rows & columns
	brmin[0][0][0] = SIZE2;
	nminmap = 0;
	maxnminmap = 1;
	for (h = 0; h < 6; h++) {
		get_block_row(grid[h/SIZE], br[0], SIZE2, SIZE, SIZE2, SIZE, h%SIZE);
		for (i=0; i<ntup; i++) {
			exchange_block_col(br[0], br[1], SIZE, SIZE, SIZE2, SIZE, permut[i]);
			for (j=0; j<ntup; j++) {
				exchange_row_in_b(br[1], br[2], SIZE, SIZE, SIZE2, SIZE, 0, permut[j]);
				for (k=0; k<ntup; k++) {
					exchange_col_in_b(br[2], br[3], SIZE, SIZE, SIZE2, SIZE, 0, permut[k]);
					for (l=0; l<ntup; l++) {
						exchange_col_in_b(br[SIZE], br[4], SIZE, SIZE, SIZE2, SIZE, 1, permut[l]);
						for (m=0; m<ntup; m++) {
							exchange_col_in_b(br[4], br[5], SIZE, SIZE, SIZE2, SIZE, 2, permut[m]);

							// renumber and check for minimum grid
							renumber_min(br[5], br[6], SIZE, SIZE2, SIZE2);
							cmp = compare_grids(brmin[0], br[6], SIZE, SIZE2);
							if (cmp <= 0) {
								if (cmp == 0) {
									nminmap++;
									if (nminmap > maxnminmap) {
										brmin = (int ***) realloc(brmin,sizeof(int**) * nminmap);
										brmin[nminmap-1] = (int **) malloc(sizeof(int*) * SIZE);
										for(n = 0; n < SIZE; n++)
											brmin[nminmap-1][n] = (int *) malloc(sizeof(int) * SIZE2);
										minmap = (int ***) realloc(minmap,sizeof(int**) * nminmap);
										minmap[nminmap-1] = (int **) malloc(sizeof(int*) * 5);
										minh = (int *) realloc(minh,sizeof(int*) * nminmap);
									}
									if (nminmap > maxnminmap) maxnminmap = nminmap;
								} else {
									nminmap = 1;
								}
								copy_grid(br[6], brmin[nminmap-1], SIZE, SIZE2);
								minh[nminmap-1] = h;
								minmap[nminmap-1][0] = permut[i];
								minmap[nminmap-1][1] = permut[j];
								minmap[nminmap-1][2] = permut[k];
								minmap[nminmap-1][3] = permut[l];
								minmap[nminmap-1][4] = permut[m];
							}
						}
					}
				}
			}
		}
	}

	// continue to find minimum sudoku
	grid[7][0][0] = SIZE2;
	for (i = 0; i < nminmap; i++) {
		for (j=0; j<ntup; j++) {
			if (permut[j][0] == minh[i]%SIZE) {
				exchange_block_row(grid[minh[i]/SIZE], grid[2], SIZE2, SIZE, SIZE2, SIZE, permut[j]);
				exchange_block_col(grid[2], grid[3], SIZE2, SIZE, SIZE2, SIZE, minmap[i][0]);
				exchange_row_in_b(grid[3], grid[2], SIZE2, SIZE, SIZE2, SIZE, 0, minmap[i][1]);
				exchange_col_in_b(grid[2], grid[3], SIZE2, SIZE, SIZE2, SIZE, 0, minmap[i][2]);
				exchange_col_in_b(grid[3], grid[2], SIZE2, SIZE, SIZE2, SIZE, 1, minmap[i][3]);
				exchange_col_in_b(grid[2], grid[3], SIZE2, SIZE, SIZE2, SIZE, 2, minmap[i][4]);
				for (k=0; k<ntup; k++) {
					exchange_row_in_b(grid[3], grid[4], SIZE2, SIZE, SIZE2, SIZE, 1, permut[k]);
					for (l=0; l<ntup; l++) {
						exchange_row_in_b(grid[4], grid[5], SIZE2, SIZE, SIZE2, SIZE, 2, permut[l]);
						renumber_min(grid[5], grid[6], SIZE2, SIZE2, SIZE2);
						if (compare_grids(grid[7], grid[6], SIZE2, SIZE2) < 0) {
							copy_grid(grid[6], grid[7], SIZE2, SIZE2);
						}
					}
				}
			}			
		}
	}

	// print result
	if (DEBUG) {
		print_grid(stdout, grid[0], SIZE2, SIZE, SIZE2, SIZE);
		fprintf(stdout,"grid above: original grid\n\n");
		print_grid(stdout, grid[7], SIZE2, SIZE, SIZE2, SIZE);
		fprintf(stdout,"grid above: minimum grid\n\n");
	}
	
	// copy result to sudoku
	reset_sudoku(canon);
	for (i = 0; i < SIZE2; i++) {
		for (j = 0; j < SIZE2; j++) {
			canon->grid[i][j].value = grid[7][i][j];
		}
	}
	get_candidates(canon);
	
	// free
	free(tup0);
	for (i = 0; i > ntup; i++) free(permut[i]);
	free(permut);
	for (i=0; i<8; i++) {
		for (j=0; j<SIZE2; j++) {
			free(grid[i][j]);
		}
		free(grid[i]);
	}
	free(grid);
	for (i=0; i<7; i++) {
		for (j=0; j<SIZE; j++) {
			free(br[i][j]);
		}
		free(br[i]);
	}
	free(br);
	for (i=0; i<maxnminmap; i++) {
		for (j=0; j<SIZE; j++) free(brmin[i][j]);
		free(brmin[i]);
		free(minmap[i]);
	}
	free(brmin);
	free(minmap);
	free(minh);

	// done
	return(0);
}

/*
 ******************************************************************************/
void renumber_min(int **grid0, int **grid1, int rows, int cols, int vals) {

	int r, c, i;
	int *valmap = (int *) malloc(sizeof(int) * vals);
	int *avvals = (int *) malloc(sizeof(int) * vals);

	for (r=0; r<vals; r++) {
		valmap[r] = 0;
		avvals[r] = r+1;
	}
	
	for (r = 0; r < rows; r++) {
		for (c = 0; c < cols; c++) {
			if (grid0[r][c] != 0) {
				if (valmap[grid0[r][c]-1] == 0) {
					i = 0;
					while(avvals[i] == 0) i++;
					valmap[grid0[r][c]-1] = avvals[i];
					avvals[i] = 0;
				}
				grid1[r][c] = valmap[grid0[r][c]-1];
			} else {
				grid1[r][c] = 0;
			}
		}
	}
	free(valmap);
	free(avvals);
}

/*
 ******************************************************************************/
void init_permuts(int *t0, int **t1, int size, int tupSize, int *itup, int ntup) {
	
	int i, j, k, *t2;
	
	if (size > 1) t2 = (int *) malloc(sizeof(int) * (size-1));
	for (i = 0; i < size; i++) {
		t1[*itup][tupSize - size] = t0[i];
		if (size == 1) {
			(*itup)++;
			if (*itup < ntup) {
				for (j = 0; j < tupSize; j++) t1[*itup][j] = t1[(*itup)-1][j];
			}
			return;
		} else {
			for (j = k = 0; j < size; j++) if (i != j) t2[k++] = t0[j];
			init_permuts(t2, t1, size-1, tupSize, itup, ntup);
		}
	}
	if (size > 1) free(t2);
}

/*
 ******************************************************************************/
void print_grid(FILE *f, int **grid,
		int rows,   // number of rows
		int rowbs,  // number of cells in block row
		int cols,   // number of columns
		int colbs)  // number of cells in block column
{
	int r, c;

	for (r=0; r<rows; r++) {
		if ((r != 0) && ((r % rowbs) == 0)) fprintf(f,"\n");
		for (c=0; c<cols; c++) {
			fprintf(f,"%d ",grid[r][c]);
			if ((c+1) % colbs == 0) fprintf(f,"  ");
		}
		fprintf(f, "\n");
	}
}

/*
 ******************************************************************************/
void get_block_row(int **srcgrid, int **destgrid,
		int rows,   // number of rows
		int rowbs,  // number of cells in block row
		int cols,   // number of columns
		int colbs,  // number of cells in block column
		int blk)    // block row to copy
{
	int r, c, row;

	for (r = 0; r < rowbs; r++) {
		row = r + blk*rowbs;
		for (c = 0; c < cols; c++) {
			destgrid[r][c] = srcgrid[row][c];
		}
	}
}

/*
 ******************************************************************************/
void set_1st_block_row(int **srcgrid, int **destgrid,
		int rows,   // number of rows
		int rowbs,  // number of cells in block row
		int cols,   // number of columns
		int colbs,  // number of cells in block column
		int blk)    // block row to put in 1st position
{
	int r, c, row;

	for (r = 0; r < rowbs; r++) {
		row = r + blk*rowbs;
		for (c = 0; c < cols; c++) {
			destgrid[r][c] = srcgrid[row][c];
		}
	}
}

/*
 ******************************************************************************/
void exchange_block_row(int **srcgrid, int **destgrid,
		int rows,   // number of rows
		int rowbs,  // number of cells in block row
		int cols,   // number of columns
		int colbs,  // number of cells in block column
		int *brMap) // mapping for block columns
{
	int br, bc, r, c, rNew, rOld, col;
	int brows = rows/rowbs; // number of blocks in row
	int bcols = cols/colbs; // number of blocks in column

	for (br = 0; br < brows; br++) {
		for (r = 0; r < rowbs; r++) {
			rOld = brMap[br] * rowbs + r;
			rNew = br        * rowbs + r;
			for (bc = 0; bc < bcols; bc++) {
				for (c = 0; c < colbs; c++) {
					col = bc * colbs + c;
					destgrid[rNew][col] = srcgrid[rOld][col];
				}
			}
		}
	}
}

/*
 ******************************************************************************/
void exchange_block_col(int **srcgrid, int **destgrid,
		int rows,   // number of rows
		int rowbs,  // number of cells in block row
		int cols,   // number of columns
		int colbs,  // number of cells in block column
		int *bcMap) // mapping for block columns
{
	int br, bc, r, c, cNew, cOld, row;
	int brows = rows/rowbs; // number of blocks in row
	int bcols = cols/colbs; // number of blocks in column

	for (bc = 0; bc < bcols; bc++) {
		for (c = 0; c < colbs; c++) {
			cOld = bcMap[bc] * colbs + c;
			cNew = bc        * colbs + c;
			for (br = 0; br < brows; br++) {
				for (r = 0; r < rowbs; r++) {
					row = br * rowbs + r;
					destgrid[row][cNew] = srcgrid[row][cOld];
				}
			}
		}
	}
}

/*
 ******************************************************************************/
void exchange_col_in_b(int **srcgrid, int **destgrid,
		int rows,   // number of rows
		int rowbs,  // number of cells in block row
		int cols,   // number of columns
		int colbs,  // number of cells in block column
		int blk,    // block in which to exchange columns
		int *cMap)  // mapping for columns
{
	int row, scol, dcol, c;

	copy_grid(srcgrid,destgrid,rows,cols);
	for (c = 0; c < colbs; c++) {
		dcol = blk * colbs + c;
		scol = blk * colbs + cMap[c];
		for (row = 0; row < rows; row++) {
			destgrid[row][dcol] = srcgrid[row][scol];
		}
	}
}

/*
 ******************************************************************************/
void exchange_row_in_b(int **srcgrid, int **destgrid,
		int rows,   // number of rows
		int rowbs,  // number of cells in block row
		int cols,   // number of columns
		int colbs,  // number of cells in block column
		int blk,    // block in which to exchange columns
		int *rMap)  // mapping for columns
{
	int srow, drow, col, r;

	copy_grid(srcgrid,destgrid,rows,cols);
	for (r = 0; r < rowbs; r++) {
		drow = blk * rowbs + r;
		srow = blk * rowbs + rMap[r];
		for (col = 0; col < cols; col++) {
			destgrid[drow][col] = srcgrid[srow][col];
		}
	}
}

/*
 ******************************************************************************/
void exchange_value(int **srcgrid, int **destgrid,
		int rows,    // number of rows
		int cols,    // number of columns
		int *valMap) // mapping for values
{
	int r, c;
	
	reset_grid(destgrid,rows,cols);
	for (r = 0; r < rows; r++) {
		for (c = 0; c < cols; c++) {
			if (srcgrid[r][c] > 0) destgrid[r][c] = valMap[srcgrid[r][c] - 1];
		}
	}
}

/*
 ******************************************************************************/
void copy_grid(int **gridsrc, int **griddest, int rows, int cols) {
	
	int r, c;
	
	for (r=0; r<rows; r++) {
		for (c=0; c<cols; c++) {
			griddest[r][c] = gridsrc[r][c];
		}
	}
}

/*
 ******************************************************************************/
void transpose_grid(int **gridsrc, int **griddest, int rows, int cols) {
	
	int r, c;
	
	for (r=0; r<rows; r++) {
		for (c=0; c<cols; c++) {
			griddest[r][c] = gridsrc[r][c];
		}
	}
}

/* sets values to zero, candidates all != 0
 ******************************************************************************/
void reset_grid(int **grid, int rows, int cols) {

	int r, c;
	
	for (r=0; r<rows; r++) {
		for (c=0; c<cols; c++) {
			grid[r][c] = 0;
		}
	}
}

/*
 ******************************************************************************/
int compare_grids(int **grid0, int **grid1, int rows, int cols) {

	int r, c, ret = 0;
	
	for (r = 0; r < rows; r++) {
		for (c = 0; (c < cols) && (ret == 0); c++) {
			if (grid0[r][c] < grid1[r][c]) {
				ret = 1;
			} else if (grid0[r][c] > grid1[r][c]) {
				ret = -1;
			}
		}
	}
	return(ret);
}
