#!/bin/sh
#
# This file is part of sudognu.
#
# Copyright (C) 2007 Jens Baaran, Germany.
#
# THERE IS NO WARRANTY FOR THIS PROGRAM, TO THE EXTENT PERMITTED
# BY APPLICABLE LAW.
#
# See the GPL Version 2 (http://www.gnu.org/licenses/gpl.html)
# or the file COPYING for details
# ******************************************************************************
set -f
CGISUDOKU=/usr/local/bin/sudognu

cat <<- END
	Content-type: text/html
	
	<html>
	<head>
	  <title>Explaining sudoku ...</title>
	  <style type="text/css">
		body      { background-color:white; color:black; }
		td        { text-align:left; padding:2px 1ex 2px 1ex; }
		table     { text-align:center; }
		.ctr      { text-align:center; }
		.lft      { text-align:left; }
	  </style>
	</head>
	<body>
END

PARAM_STRING_SUDOKU=`echo $QUERY_STRING | egrep -o 'sudoku=[[:digit:]]+'`
SUDOKU=`echo $PARAM_STRING_SUDOKU | egrep -o '=[[:digit:]]+' | cut -b 2-`

echo "The solution of your sudoku is explained step by step.<br>"
echo "<hr><pre>"
echo $SUDOKU | $CGISUDOKU -s -v 11 -f ./wsudognu.cgi 2>&1
echo "</pre><hr>"

echo "</body>"
echo "</html>"

