#include "SubtitleTime.h"
#include <cppunit/extensions/HelperMacros.h>

class testSubtitleTime : public CppUnit::TestFixture
{
	CPPUNIT_TEST_SUITE( testSubtitleTime );
	CPPUNIT_TEST( testConstructor );
	CPPUNIT_TEST( testOperator );
	CPPUNIT_TEST( testOther );
	CPPUNIT_TEST_SUITE_END();
public:

	void setUp()
	{
	}

	void tearDown()
	{
	}


	/*
	 *
	 */
	void testConstructor()
	{
		int hours = 1;
		int mins = 26;
		int secs = 59;
		int msecs = 326;
		long int totalmsecs = 3600000 * hours + 60000 * mins + 1000 * secs + msecs;

#define check(time) \
		CPPUNIT_ASSERT_EQUAL(hours, time.hours); \
		CPPUNIT_ASSERT_EQUAL(mins, time.mins); \
		CPPUNIT_ASSERT_EQUAL(secs, time.secs); \
		CPPUNIT_ASSERT_EQUAL(msecs, time.msecs); \
		CPPUNIT_ASSERT_EQUAL(totalmsecs, time.totalmsecs);

		SubtitleTime a(hours, mins, secs, msecs);
		check(a);

		CPPUNIT_ASSERT(SubtitleTime(totalmsecs) == SubtitleTime("1:26:59.326"));
		CPPUNIT_ASSERT(a == SubtitleTime("1:26:59.326"));
		CPPUNIT_ASSERT(a == SubtitleTime(std::string("1:26:59.326")));
		CPPUNIT_ASSERT(a.str() == "1:26:59.326");

		SubtitleTime b("1:26:59.326");
		check(b);
#undef check

	}

	/*
	 *
	 */
	void testOperator()
	{
		SubtitleTime a(1,10,50,600);
		SubtitleTime b(2,55,10,655);
		SubtitleTime res(4,6,1,255);

		// ==
		CPPUNIT_ASSERT(SubtitleTime("1:50:30.654") == SubtitleTime(1,50,30,654));
		// !=
		CPPUNIT_ASSERT(SubtitleTime("1:50:30.650") != SubtitleTime(1,50,30,654));
		// +
		CPPUNIT_ASSERT(SubtitleTime(4,6,1,255) == SubtitleTime(1,10,50,600) + SubtitleTime(2,55,10,655));
		CPPUNIT_ASSERT(SubtitleTime(0,6,1,0) != SubtitleTime(1,10,50,600) + SubtitleTime(2,55,10,655));
		// -
		CPPUNIT_ASSERT(SubtitleTime(0,50,0,0) == SubtitleTime(1,0,0,600) - SubtitleTime(0,10,0,600));
		// *
		
		// /
		
		// >
		CPPUNIT_ASSERT(SubtitleTime(1,2,3,400) > SubtitleTime(1,0,50,600));
		// <
		CPPUNIT_ASSERT(SubtitleTime(0,2,3,400) < SubtitleTime(1,0,50,600));
		// >=
		CPPUNIT_ASSERT(SubtitleTime(1,2,3,400) >= SubtitleTime(1,2,3,400));
		CPPUNIT_ASSERT(SubtitleTime(1,2,3,400) >= SubtitleTime(1,2,3,300));
		// <=
		CPPUNIT_ASSERT(SubtitleTime(1,2,3,400) <= SubtitleTime(1,2,6,400));
		CPPUNIT_ASSERT(SubtitleTime(1,2,3,300) <= SubtitleTime(1,2,3,400));
	}

	/*
	 *
	 */
	void testOther()
	{
		CPPUNIT_ASSERT(SubtitleTime(0,0,0,0) == SubtitleTime::null());
		CPPUNIT_ASSERT(SubtitleTime("0:00:00.000") == SubtitleTime::null());
		CPPUNIT_ASSERT(SubtitleTime::validate("1:00:50.500"));
		CPPUNIT_ASSERT(SubtitleTime::validate("1:00:50,500") == false);
		CPPUNIT_ASSERT(SubtitleTime::validate("1:00:50") == false);
		CPPUNIT_ASSERT(SubtitleTime::validate("") == false);
		CPPUNIT_ASSERT(SubtitleTime::validate("hello") == false);
	}
};

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION(testSubtitleTime);

