#ifndef _Waveform_h
#define _Waveform_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <glibmm.h>
#include <vector>


class Waveform
{
public:
	Waveform();

	/*
	 *
	 */
	guint get_size();

	/*
	 *
	 */
	gint64 get_len();

	/*
	 *
	 */
	double get_channel(unsigned int ch, guint64 pos);

	/*
	 *
	 */
	bool open(const Glib::ustring &uri);
	bool save(const Glib::ustring &uri);
public:
	Glib::ustring uri;
	guint n_channels;
	std::vector<double> channels[2];
	gint64 len;
};



#endif//_Waveform_h

