
#ifndef lint
static char *rcsid = "$Header: $";
#endif lint

/*
 *	Stat.c		Dump out inode info in nice form.
 *			Original version by someone at Purdue in the days of v6;
 *			this one by Rsk for modern times.
 *
 *			Various enhancements and bugs fixes to this version
 *			by Bill Stoll, Stan Barber, William J. Bogstad,
 *			Michael MacKenzie.
 *
 */

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <ctype.h>
#include <sys/stat.h>
#include <pwd.h>
#include <grp.h>

#define	FAIL	-1		/* Failure return code from call */	
#define OKAY	0		/* Success return code from call */

struct 	stat	Sbuf;		/* for return values from stat() call */
char	*ctime();		/* Time conversion	*/
struct	passwd	*getpwuid();	/* User entry */
struct	passwd	*pwent;		/* User structure */
struct	group	*getgrgid();	/* Group entry */
struct	group	*grent;		/* Group structure */

char	Mode[10];	/* File protection mode */

#define	LBUFSIZ	256	/* Length for symbolic link translation buffer */
char	Lbuf[LBUFSIZ];	/* Symbolic link translation buffer */

int
main(argc, argv)
int argc;
char *argv[];
{
	register int i;

	i = 1;

	if(argc == 1) {
		(void) fprintf(stderr,"Usage: stat file1 [file2 ...]\n");
		exit(1);
	}

	do {
		(void) stat_it(argv[i]);

		if(  (argc > 1) && (i < (argc-1)) )
			(void) printf("\n");
	}
	while(++i < argc);

	exit(0);
}

/*
 * stat_it() - Actually stat and format results from file.
 *		exit -    OKAY if no problems encountered
 *			  FAIL if couldn't open or other nastiness
 *
 */
stat_it(filename)
char	*filename;
{
	register int count;

#ifdef S_IFLNK
	if( lstat(filename,&Sbuf) == FAIL) {
		(void) fprintf(stderr,"Can't lstat %s\n",filename); 
		return(FAIL);
	}
#else S_IFLNK
	if( stat(filename,&Sbuf) == FAIL) {
		(void) fprintf(stderr,"Can't stat %s\n",filename); 
		return(FAIL);
	}
#endif S_IFLNK

#ifdef S_IFLNK
	if( (Sbuf.st_mode & S_IFMT) == S_IFLNK) {
		if( (count = readlink(filename,Lbuf,LBUFSIZ)) == FAIL) {
			(void) fprintf(stderr,"Can't readlink %s\n", filename);
			return(FAIL);
		}
		if( count < LBUFSIZ)
			Lbuf[count] = '\0';
		(void) printf("    Name: \"%s\" -> \"%s\"\n",filename,Lbuf);
	} else {
#endif S_IFLNK
		(void) printf("     Name: \"%s\"\n", filename);

		(void) printf("     Size: %-10ld\n", Sbuf.st_size);

#ifdef S_IFLNK
		(void) printf("   Blocks: %-10ld\n", Sbuf.st_blocks);
#endif S_IFLNK
	}

	print_type();

	print_mode();

	print_ug();


	(void) printf("Major/Minor   Device: %2d,%-2d\n", major(Sbuf.st_dev), minor(Sbuf.st_dev));
	(void) printf("    Inode: %-10d\n", Sbuf.st_ino);
	(void) printf("    Links: %-5d", Sbuf.st_nlink);

	/* Only meaningful if file is device */

	if(  ( (Sbuf.st_mode & S_IFMT) == S_IFCHR)
	    || ( (Sbuf.st_mode & S_IFMT) == S_IFBLK) ) {
		(void) printf("\nDevice Type/Number: %2d,%-2d\n",
			major(Sbuf.st_rdev), minor(Sbuf.st_rdev));
	} else {
		(void) printf("\n");
	}
/*
 	printf("Optimal Blocksize: %ld\n", Sbuf.st_blksize);
*/

	/* The %.24s strips the newline from the ctime() string */

	(void) printf("   Access: %s",ctime(&Sbuf.st_atime));
	(void) printf("   Modify: %s",ctime(&Sbuf.st_mtime));
	(void) printf("   Change: %s",ctime(&Sbuf.st_ctime));

	return(OKAY);
}

print_type()
{
	(void) printf("     Type: ");

	switch( Sbuf.st_mode & S_IFMT) {
	case	S_IFREG:	
		(void) printf("Regular File\n");
		break;
	case	S_IFDIR:	
		(void) printf("Directory\n");
		break;
	case	S_IFCHR:	
		(void) printf("Character Device\n");
		break;
	case	S_IFBLK:	
		(void) printf("Block Device\n");
		break;
#ifdef S_IFLNK
	case	S_IFLNK:	
		(void) printf("Symbolic Link\n");
		break;
#endif S_IFLNK
#ifdef S_IFSOCK
	case	S_IFSOCK:	
		(void) printf("Socket\n");
		break;
#endif S_IFSOCK
#if (S_IFIFO | S_IFPORT)
	case	S_IFIFO:	
		(void) printf("Fifo (Named Pipe) File\n");
		break;
#endif (S_IFIFO | S_IFPORT)
#ifdef S_IFCTG
	case	S_IFCTG:	
		(void) printf("Contiguous File\n");
		break;
#endif S_IFCTG
#ifdef S_IFMPC
	case	S_IFMPC:
		(void) printf("Multiplexed Character Special\n");
		break;
#endif S_IFMPC
#ifdef S_IFMPB
	case	S_IFMPB:
		(void) printf("Multiplexed Block Special\n");
		break;
#endif S_IFMPB
	default		:	
		(void) printf("Unknown\n");
	}
}

print_mode()
{
	(void) strcpy(Mode,"----------");
	if(Sbuf.st_mode & (S_IEXEC>>6))		/* Other execute */
		Mode[9] = 'x';
	if(Sbuf.st_mode & (S_IWRITE>>6))	/* Other write */
		Mode[8] = 'w';
	if(Sbuf.st_mode & (S_IREAD>>6))		/* Other read */
		Mode[7] = 'r';
	if(Sbuf.st_mode & (S_IEXEC>>3))		/* Group execute */
		Mode[6] = 'x';
	if(Sbuf.st_mode & (S_IWRITE>>3))	/* Group write */
		Mode[5] = 'w';
	if(Sbuf.st_mode & (S_IREAD>>3))		/* Group read */
		Mode[4] = 'r';
	if(Sbuf.st_mode & S_IEXEC)		/* User execute */
		Mode[3] = 'x';
	if(Sbuf.st_mode & S_IWRITE)		/* User write */
		Mode[2] = 'w';
	if(Sbuf.st_mode & S_IREAD)		/* User read */
		Mode[1] = 'r';
	if(Sbuf.st_mode & S_ISVTX)		/* Sticky bit */
		Mode[9] = 't';
	if(Sbuf.st_mode & S_ISGID)		/* Set group id */
		Mode[6] = 's';
	if(Sbuf.st_mode & S_ISUID)		/* Set user id */
		Mode[3] = 's';
	switch( Sbuf.st_mode & S_IFMT) {
	case	S_IFDIR:	
		Mode[0] = 'd';
		break;
	case	S_IFCHR:	
		Mode[0] = 'c';
		break;
	case	S_IFBLK:	
		Mode[0] = 'b';
		break;
	case	S_IFREG:	
		Mode[0] = '-';
		break;
#ifdef S_IFLNK
	case	S_IFLNK:	
		Mode[0] = 'l';
		break;
#endif S_IFLNK
#ifdef S_IFSOCK
	case	S_IFSOCK:	
		Mode[0] = 's';
		break;
#endif S_IFSOCK
#ifdef S_IFIFO
	case	S_IFIFO:	
#ifdef SYSV
		Mode[0] = 'f';
#else SYSV
		Mode[0] = 'p';
		break;
#endif SYSV
#endif S_IFIFO
#ifdef S_IFCTG
	case	S_IFCTG:	
		Mode[0] = 'C';
		break;
#endif S_IFCTG
	default		:	
		Mode[0] = '?';
	}

	(void) printf("     Mode: %s (%04o) %s \n", Mode,Sbuf.st_mode&07777);
}

print_ug()
{
	(void) setpwent();
	if( (pwent = getpwuid(Sbuf.st_uid)) == NULL) {
		(void) fprintf(stderr,"getpwuid() failed\n");
		exit(1);
	}
	(void) printf("    Owner: %s (%d)\n", pwent->pw_name,Sbuf.st_uid);

	(void) setgrent();
	if( (grent = getgrgid(Sbuf.st_gid)) == NULL) {
		(void) fprintf(stderr,"getgrgid() failed\n");
		exit(1);
	}
	(void) printf("    Group: %s (%d)\n", grent->gr_name,Sbuf.st_gid);
}
