'\" t
.\" ** The above line should force tbl to be a preprocessor **
.\" Man page for X vncviewer
.\"
.\" Copyright (C) 1998 Marcus.Brinkmann@ruhr-uni-bochum.de
.\" Copyright (C) 2000,2001 Red Hat, Inc.
.\" Copyright (C) 2001-2003 Constantin Kaplinsky <const@ce.cctpu.edu.ru>
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the file LICENCE.TXT that comes with the
.\" TightVNC distribution.
.\"
.TH vncviewer 1 "January 2003" "" "TightVNC"
.SH NAME
vncviewer \- an X viewer client for VNC
.SH SYNOPSIS
.B vncviewer
.RI [\| options \|]
.RI [\| host \|][\| :display \|]
.br
.B vncviewer
.RI [\| options \|]
.RI [\| host \|][\| ::port \|]
.br
.B vncviewer
.RI [\| options \|]
.IR \-listen
.RI [\| display \|]
.br
.B vncviewer
.IR \-help
.br
.SH DESCRIPTION
.B vncviewer
is an Xt\-based client application for the VNC (Virtual Network
Computing) system. It can connect to any VNC\-compatible server such
as \fBXvnc\fR or WinVNC, allowing you to control desktop environment
of a different machine.

You can use F8 to display a pop\-up utility menu. Press F8 twice to
pass single F8 to the remote side.
.SH OPTIONS
.TP
\fB\-help\fR
Prints a short usage notice to stderr.
.TP
\fB\-listen\fR
Make the viewer listen on port 5500+\fIdisplay\fR for reverse
connections from a server. WinVNC supports reverse connections using
the "Add New Client" menu option, or the \-connect command line
option. \fBXvnc\fR requires the use of the helper program
\fBvncconnect\fR.
.TP
\fB\-via\fR \fIgateway\fR
Automatically create encrypted TCP tunnel to the \fIgateway\fR machine
before connection, connect to the \fIhost\fR through that tunnel
(TightVNC\-specific). By default, this option invokes SSH local port
forwarding, assuming that SSH client binary can be accessed as
/usr/bin/ssh. Note that when using the \fB\-via\fR option, the host
machine name should be specified as known to the gateway machine, e.g. 
"localhost" denotes the \fIgateway\fR, not the machine where vncviewer
was launched. See the ENVIRONMENT section below for the information on
configuring the \fB\-via\fR option.
.TP
\fB\-shared\fR
When connecting, specify that a shared connection is requested. In
TightVNC, this is the default mode, allowing you to share the desktop
with other clients already using it.
.TP
\fB\-noshared\fR
When connecting, specify that the session may not be shared. This
would either disconnect other connected clients or refuse your
connection, depending on the server configuration.
.TP
\fB\-viewonly\fR
Disable transfer of mouse and keyboard events from the client to the
server.
.TP
\fB\-fullscreen\fR
Start in full\-screen mode. Please be aware that operating in
full\-screen mode may confuse X window managers. Typically, such
conflicts cause incorrect handling of input focus or make the viewer
window disappear mysteriously. See the grabKeyboard setting in the
RESOURCES section below for a method to solve input focus problem.
.TP
\fB\-noraiseonbeep\fR
By default, the viewer shows and raises its window on remote beep
(bell) event. This option disables such behaviour
(TightVNC\-specific).
.TP
\fB\-user\fR \fIusername\fR
User name for Unix login authentication. Default is to use current
Unix user name. If this option was given, the viewer will prefer Unix
login authentication over the standard VNC authentication.
.TP
\fB\-passwd\fR \fIpasswd\-file\fR
File from which to get the password (as generated by the
\fBvncpasswd\fR(1) program). This option affects only the standard VNC
authentication.
.TP
\fB\-encodings\fR \fIencoding\-list\fR
TightVNC supports several different compression methods to encode
screen updates; this option specifies a set of them to use in order of
preference. Encodings are specified separated with spaces, and must
thus be enclosed in quotes if more than one is specified. Available
encodings, in default order for a remote connection, are "copyrect
tight hextile zlib corre rre raw". For a local connection (to the same
machine), the default order to try is "raw copyrect tight hextile zlib
corre rre". Raw encoding is always assumed as a last option if no
other encoding can be used for some reason. For more information on
encodings, see the section ENCODINGS below.
.TP
\fB\-bgr233\fR
Always use the BGR233 format to encode pixel data. This reduces
network traffic, but colors may be represented inaccurately. The
bgr233 format is an 8\-bit "true color" format, with 2 bits blue, 3
bits green, and 3 bits red.
.TP
\fB\-owncmap\fR
Try to use a PseudoColor visual and a private colormap. This allows
the VNC server to control the colormap.
.TP
\fB\-truecolour\fR, \fB\-truecolor\fR
Try to use a TrueColor visual.
.TP
\fB\-depth\fR \fIdepth\fR
On an X server which supports multiple TrueColor visuals of different
depths, attempt to use the specified one (in bits per pixel); if
successful, this depth will be requested from the VNC server.
.TP
\fB\-compresslevel \fIlevel\fR
Use specified compression \fIlevel\fR (0..9) for "tight" and "zlib"
encodings (TightVNC\-specific). Level 1 uses minimum of CPU time and
achieves weak compression ratios, while level 9 offers best
compression but is slow in terms of CPU time consumption on the server
side. Use high levels with very slow network connections, and low
levels when working over high\-speed LANs. It's not recommended to use
compression level 0, reasonable choices start from the level 1.
.TP
\fB\-quality \fIlevel\fR
Use the specified JPEG quality \fIlevel\fR (0..9) for the "tight"
encoding (TightVNC\-specific). Quality level 0 denotes bad image
quality but very impressive compression ratios, while level 9 offers
very good image quality at lower compression ratios. Note that the
"tight" encoder uses JPEG to encode only those screen areas that look
suitable for lossy compression, so quality level 0 does not always
mean unacceptable image quality.
.TP
\fB\-nojpeg\fR
Disable lossy JPEG compression in Tight encoding (TightVNC\-specific). 
Disabling JPEG compression is not a good idea in typical cases, as
that makes the Tight encoder less efficient. You might want to use
this option if it's absolutely necessary to achieve perfect image
quality (see also the \fB\-quality\fR option).
.TP
\fB\-nocursorshape\fR
Disable cursor shape updates, protocol extensions used to handle
remote cursor movements locally on the client side
(TightVNC\-specific). Using cursor shape updates decreases delays with
remote cursor movements, and can improve bandwidth usage dramatically. 
.TP
\fB\-x11cursor\fR
Use a real X11 cursor with X-style cursor shape updates, instead of
drawing the remote cursor on the framebuffer. This option also
disables the dot cursor, and disables cursor position updates in
non-fullscreen mode.
.TP
\fB\-autopass\fR
Read a plain-text password from stdin. This option affects only the
standard VNC authentication.

.SH Enhanced TightVNC Viewer (SSVNC) OPTIONS
.TP
Enhanced TightVNC Viewer (SSVNC) web page is located at:
.TP
http://www.karlrunge.com/x11vnc/ssvnc.html
.TP
Note: ZRLE and ZYWRLE encodings are now supported.
.TP
Note: F9 is shortcut to Toggle FullScreen mode.
.TP
\fB\-use64\fR
In \fB\-bgr233\fR mode, use 64 colors instead of 256.
.TP
\fB\-bgr222\fR
Same as \fB\-use64\fR.
.TP
\fB\-use8\fR
In \fB\-bgr233\fR mode, use 8 colors instead of 256.
.TP
\fB\-bgr111\fR
Same as \fB\-use8\fR.
.TP
\fB\-16bpp\fR
If the vnc viewer X display is depth 24 at 32bpp
request a 16bpp format from the VNC server to cut
network traffic by up to 2X, then tranlate the
pixels to 32bpp locally.
.TP
\fB\-bgr565\fR
Same as \fB\-16bpp\fR.
.TP
\fB\-grey\fR
Use a grey scale for the 16- and 8\fB\-bpp\fR modes.
.TP
\fB\-alpha\fR
Use alphablending transparency for local cursors
requires: x11vnc server, both client and server
must be 32bpp and same endianness.
.TP
\fB\-ycrop\fR n
Only show the top n rows of the framebuffer.  For
use with x11vnc \fB\-ncache\fR client caching option
to help "hide" the pixel cache region.
Use a negative value (e.g. \fB\-1\fR) for autodetection.
Autodetection will always take place if the remote
fb height is more than 2 times the width.
.TP
\fB\-sbwidth\fR n
Scrollbar width for x11vnc \fB\-ncache\fR mode (\fB\-ycrop\fR),
default is very narrow: 2 pixels, it is narrow to
avoid distraction in \fB\-ycrop\fR mode.
.TP
\fB\-nobell\fR
Disable bell.
.TP
\fB\-rawlocal\fR
Prefer raw encoding for localhost, default is
no, i.e. assumes you have a SSH tunnel instead.
.TP
\fB\-graball\fR
Grab the entire X server when in fullscreen mode,
needed by some old window managers like fvwm2.
.TP
\fB\-popupfix\fR
Warp the popup back to the pointer position,
needed by some old window managers like fvwm2.
.TP
\fB\-grabkbd\fR
Grab the X keyboard when in fullscreen mode,
needed by some window managers. Same as \fB\-grabkeyboard\fR.
\fB\-grabkbd\fR is the default, use \fB\-nograbkbd\fR to disable.
.TP
\fB\-bs\fR, \fB\-nobs\fR
Whether or not to use X server Backingstore for the
main viewer window.  The default is to not, mainly
because most Linux, etc, systems X servers disable
*all* Backingstore by default.  To re\fB\-enable\fR it put
Option "Backingstore"
in the Device section of /etc/X11/xorg.conf.
In \fB\-bs\fR mode with no X server backingstore, whenever an
area of the screen is re\fB\-exposed\fR it must go out to the
VNC server to retrieve the pixels. This is too slow.
In \fB\-nobs\fR mode, memory is allocated by the viewer to
provide its own backing of the main viewer window. This
actually makes some activities faster (changes in large
regions) but can appear to "flash" too much.
.TP
\fB\-noshm\fR
Disable use of MIT shared memory extension (not recommended)
.TP
\fB\-termchat\fR
Do the UltraVNC chat in the terminal vncviewer is in
instead of in an independent window.
.TP
\fB\-unixpw\fR
str Useful for logging into x11vnc in \fB\-unixpw\fR mode. "str" is a
string that allows many ways to enter the Unix Username
and Unix Password.  These characters: username, newline,
password, newline are sent to the VNC server after any VNC
authentication has taken place.  Under x11vnc they are
used for the \fB\-unixpw\fR login.  Other VNC servers could do
something similar.
You can also indicate "str" via the environment
variable SSVNC_UNIXPW.
Note that the Escape key is actually sent first to tell
x11vnc to not echo the Unix Username back to the VNC
viewer. Set SSVNC_UNIXPW_NOESC=1 to override this.
If str is ".", then you are prompted at the command line
for the username and password in the normal way.  If str is
"-" the stdin is read via getpass(3) for username@password.
Otherwise if str is a file, it is opened and the first line
read is taken as the Unix username and the 2nd as the
password. If str prefixed by "rm:" the file is removed
after reading. Otherwise, if str has a "@" character,
it is taken as username@password. Otherwise, the program
exits with an error. Got all that?
.TP
\fB New Popup actions:\fR

        ViewOnly:                ~ -viewonly
        Disable Bell:            ~ -nobell
        Cursor Shape:            ~ -nocursorshape
        X11 Cursor:              ~ -x11cursor
        Cursor Alphablend:       ~ -alpha
        Toggle Tight/ZRLE:       ~ -encodings ...
        Toggle ZRLE/ZYWRLE:      ~ -encodings zywrle...
        Quality Level            ~ -quality (both Tight and ZYWRLE)
        Compress Level           ~ -compresslevel
        Disable JPEG:            ~ -nojpeg  (Tight)
        Full Color                 as many colors as local screen allows.
        Grey scale (16 & 8-bpp)  ~ -grey, for low colors 16/8bpp modes only.
        16 bit color (BGR565)    ~ -16bpp / -bgr565
        8  bit color (BGR233)    ~ -bgr233
        256 colors               ~ -bgr233 default # of colors.
         64 colors               ~ -bgr222 / -use64
          8 colors               ~ -bgr111 / -use8
        Set Y Crop (y-max)       ~ -ycrop
        Set Scrollbar Width      ~ -sbwidth

        UltraVNC Extensions:

          Set 1/n Server Scale     Ultravnc ext. Scale desktop by 1/n.
          Text Chat                Ultravnc ext. Do Text Chat.
          File Transfer            Ultravnc ext. File xfer via Java helper.
          Single Window            Ultravnc ext. Grab and view a single window.
                                   (select then click on the window you want).
          Disable Remote Input     Ultravnc ext. Try to prevent input and
                                   viewing of monitor at physical display.

        Note: the Ultravnc extensions only apply to servers that support
              them.  x11vnc/libvncserver supports some of them.

.SH ENCODINGS
The server supplies information in whatever format is desired by the
client, in order to make the client as easy as possible to implement. 
If the client represents itself as able to use multiple formats, the
server will choose one.

.I Pixel format
refers to the representation of an individual pixel. The most common
formats are 24 and 16 bit "true\-color" values, and 8\-bit "color map"
representations, where an arbitrary map converts the color number to
RGB values.

.I Encoding
refers to how a rectangle of pixels are sent (all pixel information in
VNC is sent as rectangles). All rectangles come with a header giving
the location and size of the rectangle and an encoding type used by
the data which follows. These types are listed below.
.TP
.B Raw
The raw encoding simply sends width*height pixel values. All clients
are required to support this encoding type. Raw is also the fastest
when the server and viewer are on the same machine, as the connection
speed is essentially infinite and raw encoding minimizes processing
time.
.TP
.B CopyRect
The Copy Rectangle encoding is efficient when something is being
moved; the only data sent is the location of a rectangle from which
data should be copied to the current location. Copyrect could also be
used to efficiently transmit a repeated pattern.
.TP
.B RRE
The Rise\-and\-Run\-length\-Encoding is basically a 2D version of
run\-length encoding (RLE). In this encoding, a sequence of identical
pixels are compressed to a single value and repeat count. In VNC, this
is implemented with a background color, and then specifications of an
arbitrary number of subrectangles and color for each. This is an
efficient encoding for large blocks of constant color.
.TP
.B CoRRE
This is a minor variation on RRE, using a maximum of 255x255 pixel
rectangles. This allows for single\-byte values to be used, reducing
packet size. This is in general more efficient, because the savings
from sending 1\-byte values generally outweighs the losses from the
(relatively rare) cases where very large regions are painted the same
color.
.TP
.B Hextile
Here, rectangles are split up in to 16x16 tiles, which are sent in a
predetermined order. The data within the tiles is sent either raw or
as a variant on RRE. Hextile encoding is usually the best choice for
using in high\-speed network environments (e.g. Ethernet local\-area
networks).
.TP
.B Zlib
Zlib is a very simple encoding that uses zlib library to compress raw
pixel data. This encoding achieves good compression, but consumes a
lot of CPU time. Support for this encoding is provided for
compatibility with VNC servers that might not understand Tight
encoding which is more efficient than Zlib in nearly all real\-life
situations.
.TP
.B Tight
Like Zlib encoding, Tight encoding uses zlib library to compress the
pixel data, but it pre\-processes data to maximize compression ratios,
and to minimize CPU usage on compression. Also, JPEG compression may
be used to encode color\-rich screen areas (see the description of
\-quality and \-nojpeg options above). Tight encoding is usually the
best choice for low\-bandwidth network environments (e.g. slow modem
connections).
.TP
.B ZRLE
The SSVNC viewer has ported the RealVNC (www.realvnc.com) ZRLE encoding
to the unix tightvnc viewer.
.TP
.B ZYWRLE
The SSVNC viewer has ported the Hitachi lossy wavelet based ZRLE
encoding from http://mobile.hitachi-system.co.jp/publications/ZYWRLE/ 
to the unix tightvnc viewer.
.SH RESOURCES
X resources that \fBvncviewer\fR knows about, aside from the
normal Xt resources, are as follows:
.TP
.B shareDesktop
Equivalent of \fB\-shared\fR/\fB\-noshared\fR options. Default true.
.TP
.B viewOnly
Equivalent of \fB\-viewonly\fR option. Default false.
.TP
.B fullScreen
Equivalent of \fB\-fullscreen\fR option. Default false.
.TP
.B grabKeyboard
Grab keyboard in full-screen mode. This can help to solve problems
with losing keyboard focus. Default false.
.TP
.B raiseOnBeep
Equivalent of \fB\-noraiseonbeep\fR option, when set to false. Default
true.
.TP
.B passwordFile
Equivalent of \fB\-passwd\fR option.
.TP
.B userLogin
Equivalent of \fB\-user\fR option.
.TP
.B passwordDialog
Whether to use a dialog box to get the password (true) or get it from
the tty (false). Irrelevant if \fBpasswordFile\fR is set. Default
false.
.TP
.B encodings
Equivalent of \fB\-encodings\fR option.
.TP
.B compressLevel
Equivalent of \fB\-compresslevel\fR option (TightVNC\-specific).
.TP
.B qualityLevel
Equivalent of \fB\-quality\fR option (TightVNC\-specific).
.TP
.B enableJPEG
Equivalent of \fB\-nojpeg\fR option, when set to false. Default true.
.TP
.B useRemoteCursor
Equivalent of \fB\-nocursorshape\fR option, when set to false
(TightVNC\-specific). Default true.
.TP
.B useBGR233
Equivalent of \fB\-bgr233\fR option. Default false.
.TP
.B nColours
When using BGR233, try to allocate this many "exact" colors from the
BGR233 color cube. When using a shared colormap, setting this resource
lower leaves more colors for other X clients. Irrelevant when using
truecolor. Default is 256 (i.e. all of them).
.TP
.B useSharedColours
If the number of "exact" BGR233 colors successfully allocated is less
than 256 then the rest are filled in using the "nearest" colors
available. This resource says whether to only use the "exact" BGR233
colors for this purpose, or whether to use other clients' "shared"
colors as well. Default true (i.e. use other clients' colors).
.TP
.B forceOwnCmap
Equivalent of \fB\-owncmap\fR option. Default false.
.TP
.B forceTrueColour
Equivalent of \fB\-truecolour\fR option. Default false.
.TP
.B requestedDepth
Equivalent of \fB\-depth\fR option.
.TP
.B useSharedMemory
Use MIT shared memory extension if on the same machine as the X
server. Default true.
.TP
.B wmDecorationWidth, wmDecorationHeight
The total width and height taken up by window manager decorations.
This is used to calculate the maximum size of the VNC viewer window. 
Default is width 4, height 24.
.TP
.B bumpScrollTime, bumpScrollPixels
When in full screen mode and the VNC desktop is bigger than the X
display, scrolling happens whenever the mouse hits the edge of the
screen. The maximum speed of scrolling is bumpScrollPixels pixels
every bumpScrollTime milliseconds. The actual speed of scrolling will
be slower than this, of course, depending on how fast your machine is. 
Default 20 pixels every 25 milliseconds.
.TP
.B popupButtonCount
The number of buttons in the popup window. See the README file for
more information on how to customize the buttons.
.TP
.B debug
For debugging. Default false.
.TP
.B rawDelay, copyRectDelay
For debugging, see the README file for details. Default 0 (off).
.SH ENVIRONMENT
When started with the \fB\-via\fR option, vncviewer reads the
\fBVNC_VIA_CMD\fR environment variable, expands patterns beginning
with the "%" character, and executes result as a command assuming that
it would create TCP tunnel that should be used for VNC connection. If
not set, this environment variable defaults to "/usr/bin/ssh -f -L
%L:%H:%R %G sleep 20".

The following patterns are recognized in the \fBVNC_VIA_CMD\fR (note
that all the patterns %G, %H, %L and %R must be present in the command
template):
.TP
.B %%
A literal "%";
.TP
.B %G
gateway host name;
.TP
.B %H
remote VNC host name, as known to the gateway;
.TP
.B %L
local TCP port number;
.TP
.B %R
remote TCP port number.
.SH SEE ALSO
\fBvncserver\fR(1), \fBXvnc\fR(1), \fBvncpasswd\fR(1),
\fBvncconnect\fR(1), \fBssh\fR(1)
.SH AUTHORS
Original VNC was developed in AT&T Laboratories Cambridge. TightVNC
additions was implemented by Constantin Kaplinsky. Many other people
participated in development, testing and support.

\fBMan page authors:\fR
.br
Marcus Brinkmann <Marcus.Brinkmann@ruhr-uni-bochum.de>,
.br
Terran Melconian <terran@consistent.org>,
.br
Tim Waugh <twaugh@redhat.com>,
.br
Constantin Kaplinsky <const@ce.cctpu.edu.ru>
