dnl #   AC_PATH_TO_DEFINE(path)  (Scott C. Gray <gray@voicenet.com>)
dnl # 
dnl #   Converts its argument to a safe '#define' value, that is, it
dnl #   converts all characters to upper case, removes all leading
dnl #   .'s and /'s, and replaces all other .'s and /'s with _'s.
dnl #
AC_DEFUN(AC_PATH_TO_DEFINE,
[`echo $1 | sed -e 's/^[ \/\.]*//g' | tr '[a-z]./\055' '[A-Z]___'`])

dnl #   AC_VOLATILE (Scott C. Gray gray@voicenet.com)
dnl #
dnl #   Determines whether or not a compiler supports the volatile
dnl #   keyword.  Defines HAVE_VOLATILE
dnl #
AC_DEFUN(AC_VOLATILE,
[
	AC_MSG_CHECKING(whether ${CC-cc} supports volatile keyword)
	AC_CACHE_VAL(ac_cv_have_volatile,
	[
		AC_TRY_COMPILE(
			[#include <stdio.h>],
			[volatile int a ; a = 10 ;],
			ac_cv_have_volatile=yes, ac_cv_have_volatile=no )
	])
	AC_MSG_RESULT($ac_cv_have_volatile)

	if (test "$ac_cv_have_volatile" = "yes"); then
		AC_DEFINE(HAVE_VOLATILE)
	fi
])

AC_DEFUN(AC_SIGSETJMP,
[
	AC_MSG_CHECKING(for sigsetjmp)
	AC_CACHE_VAL(ac_cv_have_sigsetjmp,
	[
		AC_TRY_COMPILE([
#include <stdio.h>
#include <setjmp.h>
		],[
			sigjmp_buf  jb;

			sigsetjmp(jb, 1);
		],[
			ac_cv_have_sigsetjmp=yes
		],[
			ac_cv_have_sigsetjmp=no
		])
	])

	AC_MSG_RESULT($ac_cv_have_sigsetjmp)

	if (test "$ac_cv_have_sigsetjmp" = "yes"); then
		AC_DEFINE(HAVE_SIGSETJMP)
	fi
])

AC_DEFUN(AC_POSIX_SIGNALS,
[
	AC_MSG_CHECKING(for POSIX signal handling)
	AC_CACHE_VAL(ac_cv_have_posix_sigs,
	[
		AC_TRY_LINK(
		[
#include <stdio.h>
#include <signal.h>
   	],[
      		struct sigaction sa;
      		sigaction( SIGINT, NULL, &sa );
   	],[
				ac_cv_have_posix_sigs="yes"
		],[
				ac_cv_have_posix_sigs="no"
		])
   ])

	if test "$ac_cv_have_posix_sigs" = "yes"; then
		AC_DEFINE(HAVE_POSIX_SIGNALS)
	fi
	AC_MSG_RESULT($ac_cv_have_posix_sigs)
])

#
# AC_FIND_HEADER([hdr],[path],[action_found],[action_notfound])
#
AC_DEFUN([AC_FIND_HDR], [
	AC_MSG_CHECKING(for $1)
	ac_cache_var=ac_cv_hdr_`echo $1 | sed -e 's,[[/.]],_,g'`

	AC_CACHE_VAL($ac_cache_var,
		[
			SEARCH_PATH="/usr/include:/usr/local/include:${HOME}/include:${HOME}/usr/include"
			include_dir=""

			if test "$2" != ""; then
				SEARCH_PATH="$2:${SEARCH_PATH}"
			fi

			IFS="${IFS=  }"; ac_save_ifs="$IFS"; IFS="${IFS}:"
			for dir in ${SEARCH_PATH}; do
				if test -f ${dir}/$1; then
					include_dir=${dir}
					break;
				fi
			done
			IFS="$ac_save_ifs"

			eval ${ac_cache_var}=${include_dir}
		])

	include_dir=${ac_cache_var}
	include_dir=`eval echo '$'${include_dir}`

	if test "${include_dir}" != ""; then
		AC_MSG_RESULT($include_dir)
		$3
	else
		AC_MSG_RESULT(not found)
		$4
	fi
])

#
# AC_FIND_LIB([lib_name],[path],[action_found],[action_notfound])
#
AC_DEFUN(AC_FIND_LIB, [
	AC_MSG_CHECKING(for lib$1)
	AC_CACHE_VAL(ac_cv_lib$1,
		[
			SEARCH_PATH="/lib:/usr/lib:/usr/local/lib:${HOME}/lib:${HOME}/usr/lib"
			libdir=""

			if test "${LD_LIBRARY_PATH}" != ""; then
				SEARCH_PATH="${LD_LIBRARY_PATH}:${SEARCH_PATH}"
			fi

			if test "$2" != ""; then
				SEARCH_PATH="$2:${SEARCH_PATH}"
			fi

			IFS="${IFS=  }"; ac_save_ifs="$IFS"; IFS="${IFS}:"
			for dir in ${SEARCH_PATH}; do
				for lib in ${dir}/lib$1.*; do
					if test -f "${lib}"; then
						libdir=${dir}
						break;
					fi
				done

				if test "${libdir}" != ""; then
					break;
				fi
			done
			IFS="$ac_save_ifs"

			ac_cv_lib$1="${libdir}"
		])

	libdir=$ac_cv_lib$1

	if test "${libdir}" != ""; then
		AC_MSG_RESULT($libdir)
		$3
	else
		AC_MSG_RESULT(not found)
		$4
	fi
])


dnl #   AC_SYSV_SIGNALS  (Scott C. Gray gray@voicenet.com)
dnl #
dnl #   Determines behaviour of signals, if they need to be reinstalled
dnl #   immediately after calling.
dnl #
AC_DEFUN(AC_SYSV_SIGNALS,
[
	AC_MSG_CHECKING(signal behaviour)
	AC_CACHE_VAL(ac_cv_signal_behaviour,
	[
		AC_TRY_RUN(
		[
/*-- Exit 0 if BSD signal, 1 if SYSV signal --*/
#include <signal.h>
static int sg_sig_count = 0 ;
void sig_handler() { ++sg_sig_count ; }
main() {
#ifdef SIGCHLD
#define _SIG_ SIGCHLD
#else
#define _SIG_ SIGCLD
#endif
    signal( _SIG_, sig_handler ) ;
    kill( getpid(), _SIG_ ) ;
    kill( getpid(), _SIG_ ) ;
    exit( sg_sig_count != 2 ) ;
}
		], ac_cv_signal_behaviour=BSD, ac_cv_signal_behaviour=SYSV)
	])

	AC_MSG_RESULT($ac_cv_signal_behaviour)

	if (test "$ac_cv_signal_behaviour" = "SYSV"); then
		AC_DEFINE(SYSV_SIGNALS)
	fi
])

#   AC_CHECK_FILE(file)  (Scott C. Gray <gray@nas.nasa.gov>)
#
#   Checks for existence of a file on the system.  If the file exists
#   and is readable, then HAVE_${FILE} is defined.
#
AC_DEFUN(AC_CHECK_FILE,
[
	AC_MSG_CHECKING(for $1)
	flat_name=AC_PATH_TO_DEFINE($1)
	AC_CACHE_VAL(ac_cv_file_${flat_name},
	[
		if (test -r "$1"); then
			eval ac_cv_file_${flat_name}=yes
		else
			eval ac_cv_file_${flat_name}=no
		fi
	])

	# Yet another example of why bourne shell is broken. What we
	# really need here is shell support of multiple levels of
	# variable dereferencing. Long live rc! (es is cool too)

	if eval "test \"`echo '$ac_cv_file_'${flat_name}`\" = yes"; then
		AC_MSG_RESULT(yes)
		AC_DEFINE_UNQUOTED(HAVE_${flat_name})
	else
		AC_MSG_RESULT(no)
	fi
])

#  AC_PROG_CC_STDC
#
#  Copyright (C) 1992, 1994 Free Software Foundation, Inc.
#  Francois Pinard <pinard@iro.umontreal.ca>, 1992.
#  Modified by Scott C. Gray <gray@nas.nasa.gov>, 1995
#
#  This macro attempts to determine which flags (if any) are required 
#  for ${CC} in order to compile an ANSI C program.  The results are
#  added to @CFLAGS@
#
AC_DEFUN(AC_PROG_CC_STDC, 
[
	AC_MSG_CHECKING(for ${CC-cc} ANSI C option)
	AC_CACHE_VAL(ac_cv_prog_cc_stdc,
	[
		ac_cv_prog_cc_stdc=no
		cv_save_CFLAGS="$CFLAGS"

		# The following command line options are tried with the
		# current chosen C compiler to determine which flags supply
		# ANSI capabilities.
		#
		#    A Real Compiler(tm) ""
		#    AIX                 -qlanglvl=ansi
		#    Ultrix and OSF/1    -std1
		#    HP-UX               -Ae or -Aa -D_HPUX_SOURCE
		#    SVR4 (Solaris)      -Xc
		#    Cray                -hstdc
		#    IRIX                -cckr, -ansiposix
		#
		for ac_arg in "" -qlanglvl=ansi -std1 -cckr -ansiposix -Ae "-Aa -D_HPUX_SOURCE" -hstdc
		do
			CFLAGS="$ac_save_CFLAGS $ac_arg"
			AC_TRY_COMPILE(
			[
#if !defined(__STDC__) || __STDC__ != 1
choke me
#endif
			], 
			[
int test( int i, double x ) ;
struct s1 { int (*f) (int a) ; } ;
struct s2 { int (*f) (double a) ; } ;
			],
			[
				ac_cv_prog_cc_stdc="${ac_arg}"
				break
			])
		done

		CFLAGS="$ac_save_CFLAGS"
	])

	AC_MSG_RESULT($ac_cv_prog_cc_stdc)
	case "x${ac_cv_prog_cc_stdc}" in
		x|xno) ;;
		*) CC="${CC} ${ac_cv_prog_cc_stdc}" ;;
	esac
])


# 
# The following is stolen from ctsql-1.4 and modified by:
#    Copyright (C) 1995, 1996  Steve Etchelecu
# Modifications:
#    Copyright (C) 1996  Scott C. Gray
# 
# Permission to use, copy, modify, distribute, and sell this software
# and its documentation for any purpose is hereby granted without fee,
# provided that (i) the above copyright notices and this permission
# notice appear in all copies of the software and related documentation,
# and (ii) the name of Steve Etchelecu may not be used in any
# advertising or publicity relating to the software without the
# specific, prior written permission of Steve Etchelecu.
# 
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
# 
# IN NO EVENT SHALL STEVE ETCHELECU BE LIABLE FOR ANY SPECIAL,
# INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY
# OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.
# 
#   Author: Steve Etchelecu              	 DBA
# Internet: steve.etchelecu@sunquest.com 	 Sunquest Information Systems
#    Phone: (520)733-6363                	 4801 E. Broadway Blvd.
#      FAX: (520)733-6602                       Tucson, AZ 85711

AC_DEFUN(AC_SYBASE_INSTALLATION, [

#
#  Is $SYBASE defined?
#
AC_MSG_CHECKING(Open Client installation)

	if test "$SYBASE" != "" ; then
		AC_MSG_RESULT($SYBASE)
	else
		AC_MSG_RESULT(no)
		AC_MSG_ERROR([Unable to locate Sybase installation
			Check your SYBASE environment variable setting.])
	fi

	if test -d $SYBASE/include ; then
		SYBASE_INCDIR='-I$(SYBASE)/include'
	else
		AC_MSG_ERROR([Sybase include files not found in \$SYBASE
			Check your SYBASE environment variable setting.])
	fi

#
# What is the version of Open Client?
#
AC_MSG_CHECKING(Open Client version)

	SYBASE_VERSION=`strings $SYBASE/lib/libct.a 2>/dev/null | \
		cut -c1-80 | fgrep 'Sybase Client-Library' | cut -d '/' -f 2`
	AC_MSG_RESULT($SYBASE_VERSION)

AC_MSG_CHECKING(Open Client libraries)

	if test ! -d $SYBASE/lib ; then
		AC_MSG_ERROR([Sybase libraries not found in \$SYBASE
			Check your SYBASE environment variable setting.])
	fi

	if test "$with_devlib" = "yes"
	then
		SYBASE_LIBDIR='-L$(SYBASE)/devlib'
	else
		SYBASE_LIBDIR='-L$(SYBASE)/lib'
	fi

	#
	# The basic client libraries that are always needed
	# on all platforms.
	#
	SYBASE_LIBS="-lblk -lcs -lct -lcomn -ltcl -lintl"

	MAJOR_VERSION=`echo $SYBASE_VERSION | cut -d '.' -f 1`

	#
	# For versions prior to 10.0.x, the network drivers must
	# be linked in with the actual binary.
	#
	if test "$MAJOR_VERSION" -lt 11
	then
		if test -f $SYBASE/lib/libinsck.a -o  \
		        -f $SYBASE/lib/libinsck.so -o \
		        -f $SYBASE/lib/libinsck.sl
		then
			SYBASE_LIBS="$SYBASE_LIBS -linsck"
		else
			if test -f $SYBASE/lib/libtli.a -o  \
			        -f $SYBASE/lib/libtli.so -o \
			        -f $SYBASE/lib/libtli.sl
			then
				SYBASE_LIBS="$SYBASE_LIBS -ltli"
			fi
		fi
	fi

	AC_MSG_RESULT($SYBASE_LIBS)

AC_MSG_CHECKING(Open Client OS libraries)

	case "${host_os}" in
		linux*)
			SYBASE_OS="-ldl -lm";;
		irix*)
			SYBASE_OS="-lnsl -lm";;
		ncr*)
			SYBASE_OS="-ldl -lm";;
		sunos*)
			SYBASE_OS="-lm";;
		solaris*)
			SYBASE_OS="-lnsl -ldl -lm";;
		osf1*)
			SYBASE_OS="-lsdna -ldnet_stub -lm";;
		ultrix*)
			SYBASE_OS="-lsdna -ldnet_stub -lm";;
		hpux*)
			SYBASE_OS="-lcl -lm -lsec -lBSD";;
		dgux*)
			SYBASE_OS="-lm -ldl -ldgc";;
		aix*)
			SYBASE_OS="-lm";;
		*)
			SYBASE_OS="-lm -ldl";;
	esac

	AC_MSG_RESULT($SYBASE_OS)


	if test "$with_static" = "yes"
	then
		SYBASE_LIBS=`echo $SYBASE_LIBS | \
			sed -e 's,-l\([[a-z]]*\),\$(SYBASE)/lib/lib\1.a,g'`
	fi

	AC_SUBST(SYBASE)
	AC_SUBST(SYBASE_INCDIR)
	AC_SUBST(SYBASE_LIBDIR)
	AC_SUBST(SYBASE_LIBS)
	AC_SUBST(SYBASE_OS)

])
