/*
For general Sqliteman copyright and licensing information please refer
to the COPYING file provided with the program. Following this notice may exist
a copyright and/or license notice that predates the release of Sqliteman
for which a new license (GPL+exception) is in place.
*/

#ifndef DATAVIEWER_H
#define DATAVIEWER_H

#include <QMainWindow>
#include "ui_dataviewer.h"

class QAbstractItemModel;
class QTableView;
class QTextEdit;
class QToolBar;
class QAction;
class QSplitter;
class SqlTableModel;


/*! \brief A Complex widget handling the database outputs and status messages.
\author Petr Vanek <petr@scribus.info>
*/
class DataViewer : public QMainWindow
{
		Q_OBJECT
	public:
		DataViewer(QWidget * parent = 0);
		~DataViewer(){};

		/*! \brief Set data model. See Qt model/view documentation.
		\retval bool true when the model is set succesfully
		*/
		bool setTableModel(QAbstractItemModel * model);
		//! \brief Set text to the status widget.
		void setStatusText(const QString & text);
		//! \brief Show/hide status widget
		void showStatusText(bool show);
		//! \brief Show/hide action tools
		void showButtons(bool show);

		SqlTableModel* tableData();
		QStringList tableHeader();

		QByteArray saveSplitter() { return ui.splitter->saveState(); };
		void restoreSplitter(QByteArray state) { ui.splitter->restoreState(state); };

	private:
		Ui::DataViewer ui;

		void resizeViewToContents();

	private slots:
		void addRow();
		void removeRow();
		void truncateTable();
		void exportData();
		void commit();
		void rollback();
		/*! \brief Handle selection as "excel-like copypasting".
		Qt4 takes only last selected item into clipboard so
		we have to create structure such this:
		val1 [tab] val2 [tab] ... [tab] valN
		valX ...
		...
		valC ...
		\note The DisplayRole of the values is taken!
		*/
		void copyHandler();
};


//! \brief Support tools for DataViewer class
namespace DataViewerTools {

	/*! \brief Catch a "Copy to clipboard" key sequence.
	It depends on the OS system - mostly Ctrl+C.
	This class is used as an eventFilter for DataViewer::ui.tableView
	because this widget is handled in designer (I don't want to
	inherit it to live in my code). See DataViewer constructor.
	\author Petr Vanek <petr@scribus.info>
	*/
	class KeyPressEater : public QObject
	{
		Q_OBJECT

		public:
			KeyPressEater(QObject * parent = 0) : QObject(parent) {};
			~KeyPressEater(){};

		signals:
			/*! \brief Signal emitted when user press copy sequence.
			Raised in eventFilter() */
			void copyRequest();

		protected:
			//! \brief Just catch keys.
			bool eventFilter(QObject *obj, QEvent *event);
	};

}

#endif
