/*
For general Sqliteman copyright and licensing information please refer
to the COPYING file provided with the program. Following this notice may exist
a copyright and/or license notice that predates the release of Sqliteman
for which a new license (GPL+exception) is in place.
*/
#ifndef SQLMODELS_H
#define SQLMODELS_H

#include <QSqlTableModel>
#include <QItemDelegate>
#include <QSqlRecord>

#include "preferencesdialog.h"

class QPushButton;
class QByteArray;


/*! \brief An editor for blob items */
// class ItemDelegate : QItemDelegate
// {
// 	Q_OBJECT
// 
// 	public:
// 		ItemDelegate(QObject *parent = 0);
// 		QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option,
// 								const QModelIndex &index) const;
// 
// 		void setEditorData(QWidget *editor, const QModelIndex &index) const;
// 		void setModelData(QWidget *editor, QAbstractItemModel *model,
// 							const QModelIndex &index) const;
// 		void updateEditorGeometry(QWidget *editor,
// 		const QStyleOptionViewItem &option, const QModelIndex &index) const;
// 	private slots:
// 		void loadBlob();
// 	private:
// 		QPushButton * loadButton;
// 		QByteArray newBlob;
// };


/*! \brief Simple color/behaviour improvements for standard Qt4 Sql Models */
class SqlTableModel : public QSqlTableModel
{
	Q_OBJECT

	public:
		SqlTableModel( QObject * parent = 0, QSqlDatabase db = QSqlDatabase() );
		~SqlTableModel() {};
		void setSchema(const QString & schema) { m_schema = schema; };

	private:
		bool m_useNull;
		QColor m_nullColor;
		QString m_nullText;
		bool m_useBlob;
		QColor m_blobColor;
		QString m_blobText;

		QString m_schema;
		virtual QVariant data(const QModelIndex & item, int role = Qt::DisplayRole) const;
};

/*! \brief Simple color/behaviour improvements for standard Qt4 Sql Models */
class SqlQueryModel : public QSqlQueryModel
{
	Q_OBJECT

	public:
		SqlQueryModel( QObject * parent = 0);
		~SqlQueryModel() {};
		void setQuery ( const QSqlQuery & query );
		void setQuery ( const QString & query, const QSqlDatabase & db = QSqlDatabase() );

	private:
		bool m_useNull;
		QColor m_nullColor;
		QString m_nullText;
		bool m_useBlob;
		QColor m_blobColor;
		QString m_blobText;

		QSqlRecord info;
		virtual QVariant data(const QModelIndex & item, int role = Qt::DisplayRole) const;
};

#endif
